package org.ourfilesystem.utilities;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.Arrays;

import org.bouncycastle.util.encoders.Base64;

public class BBytes {
	
	private byte[] Bytes;
	
	public BBytes() {
	}
	
	public BBytes(byte b[]) {
		setBytes(b);
	}
	
	public boolean equals(Object o) {
		if (o == null) return false;
		if (!(o instanceof BBytes)) return false;
		BBytes d = (BBytes)o;
		if (getBytes() == null) return false;
		if (d.getBytes() == null) return false;
		boolean eq = Arrays.equals(getBytes(), d.getBytes());
		return eq;
	}
	
	public int hashCode() {
		if (getBytes() != null) {
			byte b[] = getBytes();
			if (b.length > 2) {
				int hc = (b[0] * 0x010000) +
					   (b[1] * 0x000100) +
					   (b[2] * 0x000001);
				return hc;
			}
			else if (b.length == 2) {
				return (b[0] * 0x010000) +
					   (b[1] * 0x000100);				
			}
			else if (b.length == 1) {
				return b[0];
			}
		}
		return 0;
	}
	
	public String toString() {
		String str = new String(Base64.encode(getBytes()));
		return str;
	}

	public byte[] getBytes() {
		return Bytes;
	}

	public void setBytes(byte[] bytes) {
		Bytes = bytes;
	}

}
