package org.ourfilesystem.ui.db;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

import org.ourfilesystem.db.Peer;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.utilities.BBytes;

public interface DBInterface {
	
	public void saveNewPost(PostDecoded p);
	
	/**
	 * 
	 * Search or  KEYWORD = poetry, novel, shortstory
	 * Search and KEYWORD = vampires
	 * Search and RANK    > 4 
	 * Exclude    DUPLICATES
	 */
	public QueryResultsInterface search(HashMap<String,HashSet<String>> orstring, 
							   HashMap<String,HashSet<String>> andstring,
							   HashMap<String,HashSet<String>> excludestrings,
							   HashMap<String,HashSet<Long>> ornum,
							   HashMap<String,Long> andnums,
							   HashMap<String,Long> lessthan,
							   HashMap<String,Long> greaterthan,
							   HashMap<String,Long> averagelessthan,
							   HashMap<String,Long> averagegreaterthan,
							   HashSet<String> excludebackrefs,
							   HashMap<String,HashSet<Object>> hasreferences,
							   HashSet<Object> directrefs,
							   HashSet<BBytes> includepeers,
							   HashSet<BBytes> excludepeers,
							   Date fromd, Date tod
							   );

	public Peer searchPeer(Object id);
	
}
