package org.ourfilesystem.simulator.com;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.util.concurrent.ConcurrentHashMap;

import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.db.DataBaseComInterface;
import org.ourfilesystem.db.Peer;

public class ComConnectionImpl implements ComConnectionInterface {
	
	public static ConcurrentHashMap<Object, ComConnectionImpl> ConnectMap = new ConcurrentHashMap<Object, ComConnectionImpl>();

	public CoreComInterface Core;
	public DataBaseComInterface DB;
	public Long ID;
	
	public ComConnectionImpl(long id, CoreComInterface core, DataBaseComInterface db) {
		Core = core;
		DB = db;
		ID = id;
		ConnectMap.put(ID, this);
	}
	
	public ComPeerImpl getNewComPeerInterface() {
		ComPeerImpl c = new ComPeerImpl();
		c.Core = Core;
		c.DB = DB;
		return c;
	}
	
	@Override
	public ComPeerInterface getComPeerInterface(Peer peer) {
		ComConnectionImpl pc = ConnectMap.get(peer.getLocation());
		ComPeerImpl c = this.getNewComPeerInterface();
		if (pc != null) {
			ComPeerImpl c2 = pc.getNewComPeerInterface();
			c.ConnectedTo = c2;
			c2.ConnectedTo = c;
			pc.Core.newConnection(c2);
		}
		return c;
	}

	@Override
	public void Close() {
		
	}

}
