package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;
import java.util.Set;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

import net.miginfocom.swing.MigLayout;

import org.ourfilesystem.db.Peer;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.ui.db.DBInterface;
import org.ourfilesystem.ui.db.QueryResultsInterface;
import org.ourfilesystem.utilities.BBytes;

import com.toedter.calendar.JDateChooser;

public class SearchPanel {
	
	private HashMap<String, JTextField> OrStrings;
	private HashMap<String, JTextField> AndStrings;
	private HashMap<String, JTextField> ExcludeStrings;
	private HashMap<String, HashMap<String,JCheckBox>> OrStringsOpt;
	private HashMap<String, HashMap<String,JCheckBox>> AndStringsOpt;
	private HashMap<String, HashMap<String,JCheckBox>> ExcludeStringsOpt;
	private HashMap<String, JTextField> OrNumbers;
	private HashMap<String, JTextField> AndNumbers;
	private HashMap<String, JTextField> LessThan;
	private HashMap<String, JTextField> GreaterThan;
	private HashMap<String, JTextField> AverageLessThan;
	private HashMap<String, JTextField> AverageGreaterThan;
	private HashMap<String, JCheckBox> ExcludeReferences;
	private HashMap<String, ReferencesTableModel> HasReferences;
	private ReferencesTableModel DirectReferences;
	private PeerTableModel IncludePeers;
	private PeerTableModel ExcludePeers;
	private JDateChooser FromDate;
	private JDateChooser ToDate;
	private JCheckBox UseDates;
	
	private SimpleGUI GUI;
	
	public SearchPanel(SimpleGUI gui) {
		GUI = gui;
		createObjects();
	}
	
	private void createObjects() {
		OrStrings           = new HashMap<String, JTextField>(); 
		AndStrings          = new HashMap<String, JTextField>(); 
		ExcludeStrings      = new HashMap<String, JTextField>();
		OrStringsOpt        = new HashMap<String, HashMap<String,JCheckBox>>(); 
		AndStringsOpt       = new HashMap<String, HashMap<String,JCheckBox>>(); 
		ExcludeStringsOpt   = new HashMap<String, HashMap<String,JCheckBox>>();
		OrNumbers           = new HashMap<String, JTextField>(); 
		AndNumbers          = new HashMap<String, JTextField>(); 
		LessThan            = new HashMap<String, JTextField>(); 
		GreaterThan         = new HashMap<String, JTextField>(); 
		AverageLessThan     = new HashMap<String, JTextField>();
		AverageGreaterThan  = new HashMap<String, JTextField>();
		ExcludeReferences   = new HashMap<String, JCheckBox> (); 
		HasReferences       = new HashMap<String, ReferencesTableModel>(); 
		DirectReferences    = new ReferencesTableModel(); 
		IncludePeers        = new PeerTableModel(); 
		ExcludePeers        = new PeerTableModel(); 
		FromDate     = new JDateChooser(); 
		ToDate       = new JDateChooser(); 
		UseDates     = new JCheckBox("Limit to these dates."); 		
	}
	
	private class ReferencesTableModel extends AbstractTableModel {
		private static final long serialVersionUID = 1L;
		public LinkedList<PostDecoded> List;
		public ReferencesTableModel() {
			List = new LinkedList<PostDecoded>();
		}
		public void addNew(PostDecoded pd) {
			List.add(pd);
			fireTableDataChanged();
		}
		public void clear() {
			List.clear();
			fireTableDataChanged();
		}
		@Override
		public String getColumnName(int col) {
			if (col == 0) {
				return "File Name";
			}
			if (col == 1) {
				return "Digest";
			}
			return null;
		}
		
		@Override
		public int getColumnCount() {
			return 2;
		}

		@Override
		public int getRowCount() {
			return List.size();
		}

		@Override
		public Object getValueAt(int arg0, int arg1) {
			PostDecoded pd = List.get(arg0);
			if (arg1 == 0 && pd != null) {
				Set<String> nl = pd.getStringValues().get(FileHandler.FILENAME);
				if (nl != null) {
					if (nl.size() > 0) {
						return nl.iterator().next();
					}
				}
				return "<none>";
			}
			if (arg1 == 1 && pd != null) {
				if (pd.getPost() != null) {
					if (pd.getPost().getPost() != null) {
						return pd.getPost().getPost().getFileReferenceDigest();
					}
				}
			}
			return null;
		}
		
	}
	
	private class PeerTableModel extends AbstractTableModel {
		private static final long serialVersionUID = 1L;
		public LinkedList<Peer> List;
		public PeerTableModel() {
			List = new LinkedList<Peer>();
		}
		public void addNew(Peer pd) {
			if (!List.contains(pd)) {
				List.add(pd);
			}
			fireTableDataChanged();
		}
		public void clear() {
			List.clear();
			fireTableDataChanged();
		}
		@Override
		public String getColumnName(int col) {
			if (col == 0) {
				return "Nickname";
			}
			if (col == 1) {
				return "Digest";
			}
			return null;
		}
		
		@Override
		public int getColumnCount() {
			return 2;
		}

		@Override
		public int getRowCount() {
			return List.size();
		}

		@Override
		public Object getValueAt(int arg0, int arg1) {
			Peer pd = List.get(arg0);
			if (arg1 == 0 && pd != null) {
				return pd.getNickSig();
			}
			if (arg1 == 1 && pd != null) {
				return pd.getPeerKeysAndIdentity().getSignature().getDigest();
			}
			return null;
		}
		
	}
	
	public synchronized void PopulatePanel(JPanel pan, File templatefile) throws IOException {
		pan.removeAll();
		
		pan.setVisible(false);
		
		createObjects();

		GUI.resetPopupMenu();
		
		pan.setLayout(new MigLayout("", "[][grow]", ""));
		
		int rows = 0;
		BufferedReader br = new BufferedReader(new FileReader(templatefile));
		String cmd = br.readLine();
		while (cmd != null) {
			String parts[] = cmd.split("\\s+");
			if (parts[0].equals("ORS")) {
				if (parts.length == 2) {
					if (OrStrings.get(parts[1]) == null) {
						JTextField f = new JTextField();
						OrStrings.put(parts[1], f);
						JLabel l = new JLabel(parts[1] + " has one of ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}
				}
			}
			else if (parts[0].equals("ANDS")) {
				if (parts.length == 2) {
					if (AndStrings.get(parts[1]) == null) {
						JTextField f = new JTextField();
						AndStrings.put(parts[1], f);
						JLabel l = new JLabel(parts[1] + " has all of ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}					
				}
			}
			else if (parts[0].equals("EXCLUDE")) {
				if (parts.length == 2) {
					if (ExcludeStrings.get(parts[1]) == null) {
						JTextField f = new JTextField();
						ExcludeStrings.put(parts[1], f);
						JLabel l = new JLabel(parts[1] + " exclude values ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}					
				}
			}
			if (parts[0].equals("ORSO")) {
				if (parts.length > 2) {
					if (OrStringsOpt.get(parts[1]) == null) {
						HashMap<String,JCheckBox> cb = new HashMap<String,JCheckBox>();
						OrStringsOpt.put(parts[1], cb);
						JLabel l = new JLabel(parts[1] + " has one of ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						for (int cnt = 2; cnt < parts.length; cnt++) {
							JCheckBox jcb = new JCheckBox(parts[cnt]);
							cb.put(parts[cnt], jcb);
							pan.add(jcb, "cell 1 " + rows + ",growx");
						}
						rows++;
					}
				}
			}
			else if (parts[0].equals("ANDSO")) {
				if (parts.length > 2) {
					if (AndStringsOpt.get(parts[1]) == null) {
						HashMap<String,JCheckBox> cb = new HashMap<String,JCheckBox>();
						AndStringsOpt.put(parts[1], cb);
						JLabel l = new JLabel(parts[1] + " has all of ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						for (int cnt = 2; cnt < parts.length; cnt++) {
							JCheckBox jcb = new JCheckBox(parts[cnt]);
							cb.put(parts[cnt], jcb);
							pan.add(jcb, "cell 1 " + rows + ",growx");
						}
						rows++;
					}					
				}
			}
			else if (parts[0].equals("EXCLUDEO")) {
				if (parts.length > 2) {
					if (ExcludeStringsOpt.get(parts[1]) == null) {
						HashMap<String,JCheckBox> cb = new HashMap<String,JCheckBox>();
						ExcludeStringsOpt.put(parts[1], cb);
						JLabel l = new JLabel(parts[1] + " exclude values ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						for (int cnt = 2; cnt < parts.length; cnt++) {
							JCheckBox jcb = new JCheckBox(parts[cnt]);
							cb.put(parts[cnt], jcb);
							pan.add(jcb, "cell 1 " + rows + ",growx");
						}
						rows++;
					}					
				}
			}
			else if (parts[0].equals("ORN")) {
				if (parts.length == 2) {
					if (OrNumbers.get(parts[1]) == null) {
						JTextField f = new JTextField();
						OrNumbers.put(parts[1], f);
						JLabel l = new JLabel(parts[1] + " has one of ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}
				}
			}
			else if (parts[0].equals("ANDN")) {
				if (parts.length == 2) {
					if (AndNumbers.get(parts[1]) == null) {
						JTextField f = new JTextField();
						AndNumbers.put(parts[1], f);
						JLabel l = new JLabel(parts[1] + " has all of ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}
				}
			}
			else if (parts[0].equals("LESS")) {
				if (parts.length == 2) {
					if (LessThan.get(parts[1]) == null) {
						JTextField f = new JTextField();
						LessThan.put(parts[1], f);
						JLabel l = new JLabel(parts[1] + " is less than ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}
				}
			}
			else if (parts[0].equals("GREATER")) {
				if (parts.length == 2) {
					if (GreaterThan.get(parts[1]) == null) {
						JTextField f = new JTextField();
						GreaterThan.put(parts[1], f);
						JLabel l = new JLabel(parts[1] + " is greater than ");
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}
				}
			}
			else if (parts[0].equals("EXCLUDEREF")) {
				if (parts.length == 2) {
					if (ExcludeReferences.get(parts[1]) == null) {
						JCheckBox f = new JCheckBox("Exclude references marked as " + parts[1]);
						ExcludeReferences.put(parts[1], f);
						pan.add(f, "cell 1 " + rows + ",growx");
						rows++;
					}
				}
			}
			else if (parts[0].equals("HASREF")) {
				if (parts.length == 2) {
					if (HasReferences.get(parts[1]) == null) {
						JLabel l = new JLabel("is a " + parts[1] + " of ");
						ReferencesTableModel m = new ReferencesTableModel();
						HasReferences.put(parts[1], m);
						GUI.addReference(parts[1]);
						JTable t = new JTable(m);
						JScrollPane p = new JScrollPane(t);
						p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
						pan.add(l, "cell 0 " + rows + ",alignx left");
						pan.add(p, "cell 1 " + rows + ",growx,growy");
						JButton but = new JButton("Clear");
						pan.add(but, "cell 1 " + rows);
						but.setActionCommand(parts[1]);
						but.addActionListener(new ActionListener() {
							@Override
							public void actionPerformed(ActionEvent arg0) {
								clearHasReferences(arg0.getActionCommand());
							}
						});
						rows++;
					}
				}
			}
			else if (parts[0].equals("REF")) {
				JLabel l = new JLabel("References to ");
				pan.add(l, "cell 0 " + rows + ",alignx left");
				JTable t = new JTable(DirectReferences);
				JScrollPane p = new JScrollPane(t);
				p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
				pan.add(p, "cell 1 " + rows + ",growx,growy");
				JButton but = new JButton("Clear");
				pan.add(but, "cell 1 " + rows);
				but.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						clearDirectReferences();
					}
				});
				rows++;
			}
			else if (parts[0].equals("INCPEERS")) {
				JLabel l = new JLabel("Only include posts from ");
				pan.add(l, "cell 0 " + rows + ",alignx left");
				JTable t = new JTable(IncludePeers);
				JScrollPane p = new JScrollPane(t);
				p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
				pan.add(p, "cell 1 " + rows + ",growx,growy");
				JButton but = new JButton("Clear");
				pan.add(but, "cell 1 " + rows);
				but.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						clearIncludePeers();
					}
				});
				rows++;
			}
			else if (parts[0].equals("EXPEERS")) {
				JLabel l = new JLabel("Exclude posts from ");
				pan.add(l, "cell 0 " + rows + ",alignx left");
				JTable t = new JTable(ExcludePeers);
				JScrollPane p = new JScrollPane(t);
				p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
				pan.add(p, "cell 1 " + rows + ",growx,growy");
				JButton but = new JButton("Clear");
				pan.add(but, "cell 1 " + rows);
				but.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						clearExcludePeers();
					}
				});
				rows++;
			}
			else if (parts[0].equals("DATES")) {
				JLabel l = new JLabel("From date ");
				pan.add(l, "cell 0 " + rows + ",alignx left");
				pan.add(FromDate, "cell 1 " + rows + ",growx");
				l = new JLabel("To date ");
				pan.add(l, "cell 0 " + rows + ",alignx left");
				pan.add(ToDate, "cell 1 " + rows + ",growx");
				pan.add(UseDates, "cell 1 " + rows + ",growx");				
				rows++;
			}
			cmd = br.readLine();
		}
		br.close();
		pan.setVisible(true);
	}
	
	private HashSet<String> parseString(String str) {
		HashSet<String> r = new HashSet<String>();
		String sr[] = str.split("\\s+");
		for (int cnt = 0; cnt < sr.length; cnt++) {
			if (sr[cnt].matches("\\S+")) {
				r.add(sr[cnt]);
			}
		}
		return r;
	}
	
	private void clearHasReferences(String ab) {
		ReferencesTableModel m = HasReferences.get(ab);
		if (m != null) {
			m.clear();
		}
	}
	
	private void clearDirectReferences() {
		DirectReferences.clear();
	}
	
	private void clearIncludePeers() {
		IncludePeers.clear();
	}
	
	private void clearExcludePeers() {
		ExcludePeers.clear();
	}
	
	public synchronized void addHasReference(String key, PostDecoded p) {
		if (HasReferences != null && p != null) {
			ReferencesTableModel m = HasReferences.get(key);
			if (m != null) {
				m.addNew(p);
			}
		}
	}
	
	public synchronized void addDirectReference(PostDecoded p) {
		if (DirectReferences != null && p != null) {
			DirectReferences.addNew(p);
		}
	}
	
	public synchronized void addIncludePeer(Peer p) {
		if (IncludePeers != null) {
			IncludePeers.addNew(p);
		}
	}
	
	public synchronized void addExcludePeer(Peer p) {
		if (ExcludePeers != null) {
			ExcludePeers.addNew(p);
		}
	}
	
	public synchronized QueryResultsInterface doSearch(DBInterface db) {
		HashMap<String,HashSet<String>> orstring = new HashMap<String,HashSet<String>>();
		HashMap<String,HashSet<String>> andstring = new HashMap<String,HashSet<String>>();
		HashMap<String,HashSet<String>> excludestring = new HashMap<String,HashSet<String>>();
		HashMap<String,HashSet<Long>> ornum = new HashMap<String,HashSet<Long>>();
		HashMap<String,Long> andnums = new HashMap<String,Long>();
		HashMap<String,Long> lessthan = new HashMap<String,Long>();
		HashMap<String,Long> greaterthan = new HashMap<String,Long>();
		HashMap<String,Long> averageless = new HashMap<String,Long>();
		HashMap<String,Long> averagegreater = new HashMap<String,Long>();
		HashSet<String> excludebackrefs = new HashSet<String>();
		HashMap<String,HashSet<Object>> hasrefs = new HashMap<String,HashSet<Object>>();
		HashSet<Object> directrefs = new HashSet<Object>();
		HashSet<BBytes> includepeers = new HashSet<BBytes>();
		HashSet<BBytes> excludepeers = new HashSet<BBytes>();
		Date fromdate = null;
		Date todate = null;
		
		Iterator<Entry<String,HashMap<String,JCheckBox>>> i0 = AndStringsOpt.entrySet().iterator();
		while (i0.hasNext()) {
			Entry<String,HashMap<String,JCheckBox>> e = i0.next();
			HashSet<String> vals = andstring.get(e.getKey());
			if (vals == null) {
				vals = new HashSet<String>();
				andstring.put(e.getKey(), vals);
			}
			Iterator<Entry<String,JCheckBox>> i9 = e.getValue().entrySet().iterator();
			while (i9.hasNext()) {
				Entry<String,JCheckBox> e9 = i9.next();
				if (e9.getValue().isSelected()) {
					vals.add(e9.getKey());
				}
			}
		}
		
		i0 = OrStringsOpt.entrySet().iterator();
		while (i0.hasNext()) {
			Entry<String,HashMap<String,JCheckBox>> e = i0.next();
			HashSet<String> vals = orstring.get(e.getKey());
			if (vals == null) {
				vals = new HashSet<String>();
				orstring.put(e.getKey(), vals);
			}
			Iterator<Entry<String,JCheckBox>> i9 = e.getValue().entrySet().iterator();
			while (i9.hasNext()) {
				Entry<String,JCheckBox> e9 = i9.next();
				if (e9.getValue().isSelected()) {
					vals.add(e9.getKey());
				}
			}
		}
		
		i0 = ExcludeStringsOpt.entrySet().iterator();
		while (i0.hasNext()) {
			Entry<String,HashMap<String,JCheckBox>> e = i0.next();
			HashSet<String> vals = excludestring.get(e.getKey());
			if (vals == null) {
				vals = new HashSet<String>();
				excludestring.put(e.getKey(), vals);
			}
			Iterator<Entry<String,JCheckBox>> i9 = e.getValue().entrySet().iterator();
			while (i9.hasNext()) {
				Entry<String,JCheckBox> e9 = i9.next();
				if (e9.getValue().isSelected()) {
					vals.add(e9.getKey());
				}
			}
		}
		
		Iterator<Entry<String,JTextField>> i = OrStrings.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			orstring.put(e.getKey(), parseString(e.getValue().getText()));
		}
		i = AndStrings.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			andstring.put(e.getKey(), parseString(e.getValue().getText()));
		}
		i = ExcludeStrings.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			HashSet<String> s = parseString(e.getValue().getText());
			excludestring.put(e.getKey(), s);
		}
		i = OrNumbers.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			HashSet<String> s = parseString(e.getValue().getText());
			HashSet<Long> ns = new HashSet<Long>();
			Iterator<String> i2 = s.iterator();
			while (i2.hasNext()) {
				try {
					ns.add(Long.valueOf(i2.next()));
				}
				catch (Exception ex) {
					//ex.printStackTrace();
				}
			}
			ornum.put(e.getKey(), ns);
		}
		i = AndNumbers.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			try {
				long t = Long.valueOf(e.getValue().getText());
				andnums.put(e.getKey(), t);
			}
			catch (Exception ex) {
				//ex.printStackTrace();
			}
		}
		i = LessThan.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			try {
				long t = Long.valueOf(e.getValue().getText());
				lessthan.put(e.getKey(), t);
			}
			catch (Exception ex) {
				//ex.printStackTrace();
			}
		}
		i = GreaterThan.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			try {
				long t = Long.valueOf(e.getValue().getText());
				greaterthan.put(e.getKey(), t);
			}
			catch (Exception ex) {
				//ex.printStackTrace();
			}
		}
		i = AverageLessThan.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			try {
				long t = Long.valueOf(e.getValue().getText());
				averageless.put(e.getKey(), t);
			}
			catch (Exception ex) {
				//ex.printStackTrace();
			}
		}
		i = AverageGreaterThan.entrySet().iterator();
		while (i.hasNext()) {
			Entry<String,JTextField> e = i.next();
			try {
				long t = Long.valueOf(e.getValue().getText());
				averagegreater.put(e.getKey(), t);
			}
			catch (Exception ex) {
				//ex.printStackTrace();
			}
		}
		Iterator<Entry<String,JCheckBox>> i2 = ExcludeReferences.entrySet().iterator();
		while (i2.hasNext()) {
			Entry<String,JCheckBox> e = i2.next();
			if (e.getValue().isSelected()) {
				excludebackrefs.add(e.getKey());
			}
		}
		Iterator<Entry<String,ReferencesTableModel>> i3 = HasReferences.entrySet().iterator();
		while (i3.hasNext()) {
			Entry<String,ReferencesTableModel> e = i3.next();
			HashSet<Object> h = new HashSet<Object>();
			Iterator<PostDecoded> i4 = e.getValue().List.iterator();
			while (i4.hasNext()) {
				PostDecoded p = i4.next();
				if (p.getPost() != null && p.getPost().getPost() != null && p.getPost().getPost().getFileReferenceDigest() != null) {
					h.add(p.getPost().getPost().getFileReferenceDigest());
				}
			}
			hasrefs.put(e.getKey(), h);
		}
		Iterator<PostDecoded> i4 = DirectReferences.List.iterator();
		while (i4.hasNext()) {
			PostDecoded p = i4.next();
			if (p.getPost() != null && p.getPost().getPost() != null && p.getPost().getPost().getFileReferenceDigest() != null) {
				directrefs.add(p.getPost().getPost().getFileReferenceDigest());
			}			
		}
		Iterator<Peer> i5 = IncludePeers.List.iterator();
		while (i5.hasNext()) {
			Peer p = i5.next();
			includepeers.add((BBytes) p.getPeerKeysAndIdentity().getSignature().getDigest());
		}
		i5 = ExcludePeers.List.iterator();
		while (i5.hasNext()) {
			Peer p = i5.next();
			excludepeers.add((BBytes) p.getPeerKeysAndIdentity().getSignature().getDigest());
		}
		if (UseDates.isSelected()) {
			fromdate = FromDate.getDate();
			todate = ToDate.getDate();
		}
		
		return db.search(orstring         , //HashMap<String,HashSet<String>> orstring, 
				         andstring        , //HashMap<String,HashSet<String>> andstring,
				         excludestring    , //HashMap<String,HashSet<String>> excludestrings,
				         ornum            , //HashMap<String,HashSet<Long>> ornum,
				         andnums          , //HashMap<String,Long> andnums,
				         lessthan         , //HashMap<String,Long> lessthan,
				         greaterthan      , //HashMap<String,Long> greaterthan,
						 averageless      , //HashMap<String,Long> averageless,
						 averagegreater   , //HashMap<String,Long> averagegreater,
				         excludebackrefs  , //HashSet<String> excludebackrefs,
				         hasrefs          , //HashMap<String,HashSet<Object>> hasreferences,
				         directrefs       , //HashSet<Object> directrefs,
				         includepeers     , //HashSet<BBytes> includepeers,
				         excludepeers     , //HashSet<BBytes> excludepeers,
				         fromdate         , //Date fromd, 
				         todate             //Date tod
			         );
	}

}
