package org.ourfilesystem.simpleui;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JScrollPane;
import javax.swing.WindowConstants;

import org.ourfilesystem.core.Core;
import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.utilities.FileUtils;

public class NewPostDialog extends JDialog {
	private static final long serialVersionUID = 1L;

	private final JPanel contentPanel = new JPanel();
	private JTextField textField;
	private JLabel fileLabel;
	private JTextPane textPane;
	
	private Core Core;
	private File TempDir;
	private File localFile;
	private FileReference FileReference;
	
	/**
	 * Create the dialog.
	 */
	public NewPostDialog(Core core, FileReference f, String dir) {
		TempDir = new File(dir);
		if (!TempDir.exists()) {
			TempDir.mkdirs();
		}
		Core = core;
		FileReference = f;
		setTitle("New Post");
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(new MigLayout("", "[grow]", "[][][][grow]"));
		{
			JLabel lblSubject = new JLabel("Subject");
			contentPanel.add(lblSubject, "cell 0 0,alignx left");
		}
		{
			textField = new JTextField();
			contentPanel.add(textField, "cell 0 1,growx");
			textField.setColumns(10);
		}
		{
			JScrollPane scrollPane = new JScrollPane();
			contentPanel.add(scrollPane, "cell 0 3,grow");
			{
				textPane = new JTextPane();
				scrollPane.setViewportView(textPane);
			}
		}
		{
			JButton btnAttachFile = new JButton("Attach File");
			contentPanel.add(btnAttachFile, "flowx,cell 0 2");
			btnAttachFile.setActionCommand("ATTACH");
			btnAttachFile.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					if (e.getActionCommand().equals("ATTACH")) {
						JFileChooser chooser = new JFileChooser();
						int returnVal = chooser.showOpenDialog(contentPanel);
						if (returnVal == JFileChooser.APPROVE_OPTION) {
							localFile = chooser.getSelectedFile();
							fileLabel.setText(localFile.getPath());
						}						
					}
				}
			});
		}
		{
			fileLabel = new JLabel("No File");
			contentPanel.add(fileLabel, "cell 0 2");
		}
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton okButton = new JButton("Post");
				buttonPane.add(okButton);
				getRootPane().setDefaultButton(okButton);
				okButton.setActionCommand("POST");
				okButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						if (e.getActionCommand().equals("POST")) {
							String subject = textField.getText();
							String text = textPane.getText();
							try {
								File tmpfile = File.createTempFile("post", ".dat", TempDir);
								FileOutputStream fos = new FileOutputStream(tmpfile);
								FileUtils.writeString(subject, fos);
								FileUtils.writeString(text, fos);
								fos.close();
								if (localFile == null || !localFile.exists()) {
									Object fr = null;
									if (FileReference != null) {
										fr = FileReference.getUnsignedDigest();
									}
									Core.addLocalPost(tmpfile, fr);
								}
								else {
									Core.addLocalFile(localFile, tmpfile);
								}
							} catch (IOException e1) {
								e1.printStackTrace();
							}
							dispose();
						}
					}
				});
			}
			{
				JButton cancelButton = new JButton("Cancel");
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
				cancelButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(ActionEvent e) {
						if (e.getActionCommand().equals("Cancel")) {
							dispose();
						}
					}
				});
			}
		}
		
		updateFileLabel();
	}
	
	private void updateFileLabel() {
		if (FileReference != null) {
			fileLabel.setText(FileReference.getUnsignedDigest().toString().substring(0, 10));
		}
	}

}
