package org.ourfilesystem.security;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.io.File;

import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;

public interface CryptoDataBaseInterface {

	public KeySet generateNewKeys();
	
	public boolean verifyPeer(PublicKeySetSigned sigdig, Object pub);
	
	public boolean digEquals(Object id0, Object id1);
	
	public void selfSignMyPeerId(Peer p, Object privkey);
	
	public Peer signPeer(Peer p, Object peerid, Object privkey);
	
	public void signLocation(Peer p, Object privkey);
	
	public boolean verifyLocation(Peer p, Object pub);
	
	public boolean verifyPost(Post p, Object pubkey);
	
	public Post signPost(Post p, Object peerid, Object privkey);
	
	public Object digestFile(File f);

}
