package org.ourfilesystem.security;

/*
OurFileSystem is a peer2peer file sharing program.
Copyright (C) 2012  Robert Gass

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

import java.security.SecureRandom;

import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.utilities.BBytes;

public class CryptoComImpl implements CryptoComInterface {

	public static int ChallengeLength = 16;
	
	private SecureRandom Random;
	
	public CryptoComImpl() {
		Random = new SecureRandom();
	}
	
	@Override
	public Object getChallenge() {
		byte b[] = new byte[ChallengeLength];
		Random.nextBytes(b);
		return new BBytes(b);
	}

	@Override
	public boolean verifyChallenge(Object sent, SignedDigest received, Peer p) {
		BBytes bbs = (BBytes)sent;
		return SecurityTools.verifySignedDigest(received, bbs.getBytes(), (RSAKeyParameters) p.getPeerKeysAndIdentity().getPublicSigningKey());
	}

	@Override
	public SignedDigest signChallenge(Object challenge, KeySet mykeys) {
		BBytes chbb = (BBytes)challenge;
		return SecurityTools.signDigest(chbb.getBytes(), null, (RSAPrivateCrtKeyParameters) mykeys.getPrivateSigningKey());
	}

}
