package org.ourfilesystem.com;

import java.io.IOException;

import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;

public class OFSI2PConnector implements OFSConnector {
	
	private I2PSocketManager Manager;
	
	public OFSI2PConnector(I2PSocketManager m) {
		Manager = m;
	}

	@Override
	public OFSSocket connect(String url) throws IOException {
		try {
			I2PSocket sock = Manager.connect(new Destination(url));
			if (sock != null) {
				return new OFSI2PSocket(sock);
			}
		} catch (DataFormatException e) {
			e.printStackTrace();
			throw new IOException(e);
		} catch (I2PException e) {
			e.printStackTrace();
			throw new IOException(e);
		}
		return null;
	}

}
