/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.MessageOutputStream;
import net.i2p.client.streaming.Packet;
import net.i2p.data.Destination;
import net.i2p.data.SessionKey;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class PacketLocal
extends Packet
implements MessageOutputStream.WriteStatus {
    private final I2PAppContext _context;
    private final Log _log;
    private final Connection _connection;
    private Destination _to;
    private SessionKey _keyUsed;
    private Set _tagsSent;
    private final long _createdOn;
    private int _numSends;
    private long _lastSend;
    private long _acceptedOn;
    private long _ackOn;
    private long _cancelledOn;
    private volatile int _nackCount;
    private volatile boolean _retransmitted;
    private SimpleTimer2.TimedEvent _resendEvent;

    public PacketLocal(I2PAppContext ctx, Destination to) {
        this(ctx, to, null);
    }

    public PacketLocal(I2PAppContext ctx, Destination to, Connection con) {
        this._context = ctx;
        this._createdOn = ctx.clock().now();
        this._log = ctx.logManager().getLog(PacketLocal.class);
        this._to = to;
        this._connection = con;
        this._lastSend = -1L;
        this._cancelledOn = -1L;
    }

    public Destination getTo() {
        return this._to;
    }

    public void setTo(Destination to) {
        this._to = to;
    }

    public SessionKey getKeyUsed() {
        return this._keyUsed;
    }

    public void setKeyUsed(SessionKey key) {
        if (key != null) {
            this._log.error("Who is sending tags thru the streaming lib?");
        }
        this._keyUsed = key;
    }

    public Set getTagsSent() {
        return this._tagsSent;
    }

    public void setTagsSent(Set tags) {
        if (tags != null && !tags.isEmpty()) {
            this._log.error("Who is sending tags thru the streaming lib? " + tags.size());
        }
        if (this._tagsSent != null && !this._tagsSent.isEmpty() && !tags.isEmpty()) {
            if (!((Object)this._tagsSent).equals(tags)) {
                System.out.println("ERROR: dup tags: old=" + this._tagsSent.size() + " new=" + tags.size() + " packet: " + this.toString());
            }
        } else {
            this._tagsSent = tags;
        }
    }

    public boolean shouldSign() {
        return this.isFlagSet(8) || this.isFlagSet(1) || this.isFlagSet(2) || this.isFlagSet(512);
    }

    public void prepare() {
        if (this._connection != null) {
            this._connection.getInputStream().updateAcks(this);
        }
        if (this._numSends > 0) {
            this.setOptionalDelay(this._numSends * 1000);
            this.setFlag(64);
        }
    }

    public long getCreatedOn() {
        return this._createdOn;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._createdOn;
    }

    public void incrementSends() {
        ++this._numSends;
        this._lastSend = this._context.clock().now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackReceived() {
        PacketLocal packetLocal = this;
        synchronized (packetLocal) {
            if (this._ackOn <= 0L) {
                this._ackOn = this._context.clock().now();
            }
            this.releasePayload();
            this.notifyAll();
        }
        this._resendEvent.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelled() {
        PacketLocal packetLocal = this;
        synchronized (packetLocal) {
            this._cancelledOn = this._context.clock().now();
            this.releasePayload();
            this.notifyAll();
        }
        this._resendEvent.cancel();
        if (this._log.shouldLog(10)) {
            this._log.debug("Cancelled! " + this.toString(), (Throwable)new Exception("cancelled"));
        }
    }

    public SimpleTimer2.TimedEvent getResendEvent() {
        return this._resendEvent;
    }

    public int getAckTime() {
        if (this._ackOn <= 0L) {
            return -1;
        }
        return (int)(this._ackOn - this._createdOn);
    }

    public int getNumSends() {
        return this._numSends;
    }

    public long getLastSend() {
        return this._lastSend;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void incrementNACKs() {
        int cnt = ++this._nackCount;
        SimpleTimer2.TimedEvent evt = this._resendEvent;
        if (cnt >= 2 && evt != null && !this._retransmitted) {
            this._retransmitted = true;
            evt.reschedule(0L);
        }
    }

    public int getNACKs() {
        return this._nackCount;
    }

    public void setResendPacketEvent(SimpleTimer2.TimedEvent evt) {
        this._resendEvent = evt;
    }

    public StringBuilder formatAsString() {
        StringBuilder buf = super.formatAsString();
        Connection con = this._connection;
        if (con != null) {
            buf.append(" rtt ").append(con.getOptions().getRTT());
        }
        if (this._tagsSent != null && !this._tagsSent.isEmpty()) {
            buf.append(" with tags");
        }
        if (this._ackOn > 0L) {
            buf.append(" ack after ").append(this.getAckTime());
        }
        if (this._numSends > 1) {
            buf.append(" sent ").append(this._numSends).append(" times");
        }
        if ((this.isFlagSet(1) || this.isFlagSet(2) || this.isFlagSet(4)) && con != null) {
            buf.append(" from ");
            Destination local = con.getSession().getMyDestination();
            if (local != null) {
                buf.append(local.calculateHash().toBase64().substring(0, 4));
            } else {
                buf.append("unknown");
            }
            buf.append(" to ");
            Destination remote = con.getRemotePeer();
            if (remote != null) {
                buf.append(remote.calculateHash().toBase64().substring(0, 4));
            } else {
                buf.append("unknown");
            }
        }
        return buf;
    }

    public void waitForAccept(int maxWaitMs) {
        if (this._connection == null) {
            throw new IllegalStateException("Cannot wait for accept with no connection");
        }
        long before = this._context.clock().now();
        int queued = this._connection.getUnackedPacketsSent();
        int window = this._connection.getOptions().getWindowSize();
        boolean accepted = this._connection.packetSendChoke(maxWaitMs);
        long after = this._context.clock().now();
        if (accepted) {
            this._acceptedOn = after;
        } else {
            this._acceptedOn = -1L;
            this.releasePayload();
        }
        int afterQueued = this._connection.getUnackedPacketsSent();
        if (after - before > 1000L && this._log.shouldLog(10)) {
            this._log.debug("Took " + (after - before) + "ms to get " + (accepted ? " accepted" : " rejected") + (this._cancelledOn > 0L ? " and CANCELLED" : "") + ", queued behind " + queued + " with a window size of " + window + ", finally accepted with " + afterQueued + " queued: " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(int maxWaitMs) {
        long timeRemaining;
        long expiration = this._context.clock().now() + (long)maxWaitMs;
        while ((timeRemaining = expiration - this._context.clock().now()) > 0L || maxWaitMs <= 0) {
            try {
                PacketLocal packetLocal = this;
                synchronized (packetLocal) {
                    if (this._ackOn > 0L) {
                        break;
                    }
                    if (this._cancelledOn > 0L) {
                        break;
                    }
                    if (!this._connection.getIsConnected()) {
                        break;
                    }
                    if (timeRemaining > 60000L) {
                        timeRemaining = 60000L;
                    } else if (timeRemaining <= 0L) {
                        timeRemaining = 10000L;
                    }
                    this.wait(timeRemaining);
                }
            }
            catch (InterruptedException ie) {
            }
        }
        if (!this.writeSuccessful()) {
            this.releasePayload();
        }
    }

    public boolean writeAccepted() {
        return this._acceptedOn > 0L && this._cancelledOn <= 0L;
    }

    public boolean writeFailed() {
        return this._cancelledOn > 0L;
    }

    public boolean writeSuccessful() {
        return this._ackOn > 0L && this._cancelledOn <= 0L;
    }
}

