/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionManager;
import net.i2p.client.streaming.Packet;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.data.Destination;
import net.i2p.util.Log;

class PacketHandler {
    private final ConnectionManager _manager;
    private final I2PAppContext _context;
    private final Log _log;
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("HH:mm:ss.SSS");

    public PacketHandler(I2PAppContext ctx, ConnectionManager mgr) {
        this._manager = mgr;
        this._context = ctx;
        this._log = ctx.logManager().getLog(PacketHandler.class);
    }

    void receivePacket(Packet packet) {
        this.receivePacketDirect(packet, true);
    }

    void receivePacketDirect(Packet packet, boolean queueIfNoConn) {
        Connection con;
        long sendId = packet.getSendStreamId();
        Connection connection = con = sendId > 0L ? this._manager.getConnectionByInboundId(sendId) : null;
        if (con != null) {
            this.receiveKnownCon(con, packet);
            if (this._log.shouldLog(20)) {
                this.displayPacket(packet, "RECV", "wsize " + con.getOptions().getWindowSize() + " rto " + con.getOptions().getRTO());
            }
        } else {
            this.receiveUnknownCon(packet, sendId, queueIfNoConn);
            this.displayPacket(packet, "UNKN", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayPacket(Packet packet, String prefix, String suffix) {
        if (!this._log.shouldLog(20)) {
            return;
        }
        StringBuilder buf = new StringBuilder(256);
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            buf.append(_fmt.format(new Date()));
        }
        buf.append(": ").append(prefix).append(" ");
        buf.append(packet.toString());
        if (suffix != null) {
            buf.append(" ").append(suffix);
        }
        String str = buf.toString();
        System.out.println(str);
        if (this._log.shouldLog(10)) {
            this._log.debug(str);
        }
    }

    private void receiveKnownCon(Connection con, Packet packet) {
        if (packet.isFlagSet(512)) {
            if (packet.getSendStreamId() > 0L) {
                if (con.getOptions().getAnswerPings()) {
                    this.receivePing(packet);
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping Echo packet on existing con: " + packet);
                }
            } else if (packet.getReceiveStreamId() > 0L) {
                this.receivePong(packet);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Echo packet received with no stream IDs: " + packet);
            }
            packet.releasePayload();
            return;
        }
        if (PacketHandler.isValidMatch(con.getSendStreamId(), packet.getReceiveStreamId())) {
            try {
                con.getPacketHandler().receivePacket(packet, con);
            }
            catch (I2PException ie) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Received forged packet for " + con, (Throwable)ie);
                }
            }
        } else if (packet.isFlagSet(4)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("receive reset: " + packet);
            }
            try {
                con.getPacketHandler().receivePacket(packet, con);
            }
            catch (I2PException ie) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Received forged reset for " + con, (Throwable)ie);
                }
            }
        } else if (con.getSendStreamId() <= 0L || con.getSendStreamId() == packet.getReceiveStreamId() || packet.getSequenceNum() <= 1L) {
            long oldId = con.getSendStreamId();
            if (packet.isFlagSet(1)) {
                if (oldId <= 0L) {
                    con.setSendStreamId(packet.getReceiveStreamId());
                } else if (oldId != packet.getReceiveStreamId()) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Received a syn with the wrong IDs, con=" + con + " packet=" + packet);
                    }
                    this.sendReset(packet);
                    packet.releasePayload();
                    return;
                }
            }
            try {
                con.getPacketHandler().receivePacket(packet, con);
            }
            catch (I2PException ie) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Received forged packet for " + con + "/" + oldId + ": " + packet, (Throwable)ie);
                }
                con.setSendStreamId(oldId);
            }
        } else if (packet.isFlagSet(1)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Receive a syn packet with the wrong IDs, sending reset: " + packet);
            }
            this.sendReset(packet);
            packet.releasePayload();
        } else {
            if (!con.getResetSent() && this._log.shouldLog(40)) {
                Set<Connection> cons = this._manager.listConnections();
                StringBuilder buf = new StringBuilder(512);
                buf.append("Received a packet on the wrong stream: ");
                buf.append(packet);
                buf.append("\nthis connection:\n");
                buf.append(con);
                buf.append("\nall connections:");
                for (Connection cur : cons) {
                    buf.append('\n').append(cur);
                }
                this._log.error(buf.toString(), (Throwable)new Exception("Wrong stream"));
            }
            packet.releasePayload();
        }
    }

    private void sendReset(Packet packet) {
        Destination from = packet.getOptionalFrom();
        if (from == null) {
            return;
        }
        boolean ok = packet.verifySignature(this._context, from, null);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Can't send reset after recv spoofed packet: " + packet);
            }
            return;
        }
        PacketLocal reply = new PacketLocal(this._context, from);
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setSendStreamId(packet.getReceiveStreamId());
        reply.setReceiveStreamId(packet.getSendStreamId());
        reply.setOptionalFrom(this._manager.getSession().getMyDestination());
        this._manager.getPacketQueue().enqueue(reply);
    }

    private void receiveUnknownCon(Packet packet, long sendId, boolean queueIfNoConn) {
        if (packet.isFlagSet(512)) {
            if (packet.getSendStreamId() > 0L) {
                if (this._manager.answerPings()) {
                    this.receivePing(packet);
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping Echo packet on unknown con: " + packet);
                }
            } else if (packet.getReceiveStreamId() > 0L) {
                this.receivePong(packet);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Echo packet received with no stream IDs: " + packet);
            }
            packet.releasePayload();
        } else {
            Connection con;
            if (this._log.shouldLog(30) && !packet.isFlagSet(1)) {
                this._log.warn("Packet received on an unknown stream (and not an ECHO or SYN): " + packet);
            }
            if (sendId <= 0L && (con = this._manager.getConnectionByOutboundId(packet.getReceiveStreamId())) != null) {
                if (con.getHighestAckedThrough() <= 5L && packet.getSequenceNum() <= 5L) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Received additional packet w/o SendStreamID after the syn on " + con + ": " + packet);
                    }
                    this.receiveKnownCon(con, packet);
                    return;
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("hrmph, received while ack of syn was in flight on " + con + ": " + packet + " acked: " + con.getAckedPackets());
                }
                this.receiveKnownCon(con, packet);
                return;
            }
            if (packet.isFlagSet(1)) {
                this._manager.getConnectionHandler().receiveNewSyn(packet);
            } else if (queueIfNoConn) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Packet belongs to no other cons, putting on the syn queue: " + packet);
                }
                if (this._log.shouldLog(10)) {
                    StringBuilder buf = new StringBuilder(128);
                    Set<Connection> cons = this._manager.listConnections();
                    for (Connection con2 : cons) {
                        buf.append(con2.toString()).append(" ");
                    }
                    this._log.debug("connections: " + buf.toString() + " sendId: " + (sendId > 0L ? Packet.toId(sendId) : " unknown"));
                }
                this._manager.getConnectionHandler().receiveNewSyn(packet);
            } else {
                this.sendReset(packet);
                packet.releasePayload();
            }
        }
    }

    private void receivePing(Packet packet) {
        boolean ok = packet.verifySignature(this._context, packet.getOptionalFrom(), null);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                if (packet.getOptionalFrom() == null) {
                    this._log.warn("Ping with no from (flagged? " + packet.isFlagSet(32) + ")");
                } else if (packet.getOptionalSignature() == null) {
                    this._log.warn("Ping with no signature (flagged? " + packet.isFlagSet(8) + ")");
                } else {
                    this._log.warn("Forged ping, discard (from=" + packet.getOptionalFrom().calculateHash().toBase64() + " sig=" + packet.getOptionalSignature().toBase64() + ")");
                }
            }
        } else {
            PacketLocal pong = new PacketLocal(this._context, packet.getOptionalFrom());
            pong.setFlag(512, true);
            pong.setFlag(8, false);
            pong.setReceiveStreamId(packet.getSendStreamId());
            this._manager.getPacketQueue().enqueue(pong);
        }
    }

    private void receivePong(Packet packet) {
        this._manager.receivePong(packet.getReceiveStreamId());
    }

    private static final boolean isValidMatch(long conStreamId, long packetStreamId) {
        return conStreamId == packetStreamId && conStreamId != 0L;
    }
}

