/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io.block.index;

import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.metanotion.io.block.BlockFile;
import net.metanotion.io.block.index.BSkipList;
import net.metanotion.io.block.index.BSkipSpan;
import net.metanotion.util.skiplist.SkipLevels;
import net.metanotion.util.skiplist.SkipList;
import net.metanotion.util.skiplist.SkipSpan;

public class BSkipLevels
extends SkipLevels {
    private static final long MAGIC = 4779247628231994483L;
    static final int HEADER_LEN = 16;
    public final int levelPage;
    public final int spanPage;
    public final BlockFile bf;
    private final BSkipList bsl;
    private boolean isKilled;

    public BSkipLevels(BlockFile bf, int levelPage, BSkipList bsl) throws IOException {
        this.levelPage = levelPage;
        this.bf = bf;
        this.bsl = bsl;
        BlockFile.pageSeek(bf.file, levelPage);
        long magic = bf.file.readLong();
        if (magic != 4779247628231994483L) {
            throw new IOException("Bad SkipLevels magic number 0x" + Long.toHexString(magic) + " on page " + levelPage);
        }
        bsl.levelHash.put(this.levelPage, this);
        int maxLen = bf.file.readUnsignedShort();
        int nonNull = bf.file.readUnsignedShort();
        if (maxLen < 1 || maxLen > 32 || nonNull > maxLen) {
            throw new IOException("Invalid Level Skip size " + nonNull + " / " + maxLen);
        }
        this.spanPage = bf.file.readUnsignedInt();
        this.bottom = bsl.spanHash.get(this.spanPage);
        if (this.bottom == null) {
            bf.log.error("No span found in cache???");
            throw new IOException("No span found in cache???");
        }
        this.levels = new BSkipLevels[maxLen];
        if (bf.log.shouldLog(10)) {
            bf.log.debug("Reading New BSkipLevels with " + nonNull + " / " + maxLen + " valid levels page " + levelPage);
        }
        int[] lps = new int[nonNull];
        for (int i = 0; i < nonNull; ++i) {
            lps[i] = bf.file.readUnsignedInt();
        }
        boolean fail = false;
        for (int i = 0; i < nonNull; ++i) {
            int lp = lps[i];
            if (lp != 0) {
                this.levels[i] = bsl.levelHash.get(lp);
                if (this.levels[i] == null) {
                    try {
                        this.levels[i] = new BSkipLevels(bf, lp, bsl);
                        bsl.levelHash.put(lp, this.levels[i]);
                    }
                    catch (IOException ioe) {
                        bf.log.error("Corrupt database, bad level " + i + " at page " + lp, ioe);
                        this.levels[i] = null;
                        fail = true;
                        continue;
                    }
                }
                Comparable ourKey = this.key();
                Comparable nextKey = this.levels[i].key();
                if (ourKey == null || nextKey == null || ourKey.compareTo(nextKey) < 0) continue;
                bf.log.warn("Corrupt database, level out of order " + this + ' ' + this.print() + " i = " + i + ' ' + this.levels[i]);
                continue;
            }
            if (bf.log.shouldLog(30)) {
                bf.log.warn("WTF " + this + " i = " + i + " of " + nonNull + " / " + maxLen + " valid levels but page is zero");
            }
            this.levels[i] = null;
            fail = true;
        }
        if (fail && bf.file.canWrite()) {
            bf.log.error("Repairing corruption of " + this + ' ' + this.print());
            this.flush();
        }
    }

    public static void init(BlockFile bf, int page, int spanPage, int maxHeight) throws IOException {
        BlockFile.pageSeek(bf.file, page);
        bf.file.writeLong(4779247628231994483L);
        bf.file.writeShort((short)maxHeight);
        bf.file.writeShort(0);
        bf.file.writeInt(spanPage);
    }

    public void flush() {
        if (this.isKilled) {
            this.bf.log.error("Already killed!! " + this, new Exception());
            return;
        }
        try {
            int i;
            BlockFile.pageSeek(this.bf.file, this.levelPage);
            this.bf.file.writeLong(4779247628231994483L);
            this.bf.file.writeShort((short)this.levels.length);
            for (i = 0; i < this.levels.length && this.levels[i] != null; ++i) {
            }
            this.bf.file.writeShort(i);
            this.bf.file.writeInt(((BSkipSpan)this.bottom).page);
            for (int j = 0; j < i; ++j) {
                this.bf.file.writeInt(((BSkipLevels)this.levels[j]).levelPage);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error writing to database", ioe);
        }
    }

    public void killInstance() {
        if (this.isKilled) {
            this.bf.log.error("Already killed!! " + this, new Exception());
            return;
        }
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Killing " + this + ' ' + this.print(), new Exception());
        }
        this.isKilled = true;
        this.bsl.levelHash.remove(this.levelPage);
        this.bf.freePage(this.levelPage);
    }

    public SkipLevels newInstance(int levels, SkipSpan ss, SkipList sl) {
        try {
            BSkipSpan bss = (BSkipSpan)ss;
            BSkipList bsl = (BSkipList)sl;
            int page = this.bf.allocPage();
            BSkipLevels.init(this.bf, page, bss.page, levels);
            if (this.bf.log.shouldLog(10)) {
                this.bf.log.debug("New BSkipLevels height " + levels + " page " + page);
            }
            return new BSkipLevels(this.bf, page, bsl);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error creating database page", ioe);
        }
    }

    public boolean blvlck(boolean fix) {
        if (fix) {
            return this.blvlfix();
        }
        return this.blvlck(fix, 0, null);
    }

    private boolean blvlfix() {
        TreeSet<SkipLevels> lvls = new TreeSet<SkipLevels>(new LevelComparator());
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Starting level search");
        }
        this.getAllLevels(this, lvls);
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Finished level search, found " + lvls.size() + " levels");
        }
        if (!this.equals(lvls.last())) {
            this.bf.log.error("First level is out of order! " + this.print());
        }
        boolean rv = false;
        SkipLevels after = null;
        for (SkipLevels lv : lvls) {
            boolean modified = false;
            if (this.bf.log.shouldLog(10)) {
                this.bf.log.debug("Checking " + lv.print());
            }
            if (after != null) {
                int min = Math.min(after.levels.length, lv.levels.length);
                for (int i = 0; i < min; ++i) {
                    SkipLevels cur = lv.levels[i];
                    if (cur == after) continue;
                    if (cur != null) {
                        this.bf.log.warn("Level " + i + " was wrong, fixing for " + lv.print());
                    } else {
                        this.bf.log.warn("Level " + i + " was null, fixing for " + lv.print());
                    }
                    lv.levels[i] = after;
                    modified = true;
                }
            } else {
                for (int i = 0; i < lv.levels.length; ++i) {
                    if (lv.levels[i] == null) continue;
                    lv.levels[i] = null;
                    this.bf.log.warn("Last level " + i + " was non-null, fixing for " + lv.print());
                    modified = true;
                }
            }
            if (modified) {
                lv.flush();
                rv = true;
            }
            after = lv;
        }
        if (this.bf.log.shouldLog(20)) {
            this.bf.log.info("Checked " + lvls.size() + " levels");
        }
        return rv;
    }

    private void getAllLevels(SkipLevels l, Set lvlSet) {
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("GAL " + l.print());
        }
        SkipLevels cur = l;
        while (cur != null && lvlSet.add(cur)) {
            if (this.bf.log.shouldLog(10)) {
                this.bf.log.debug("Adding " + cur.print());
            }
            if (!cur.equals(this) && cur.key() == null && this.bf.log.shouldLog(30)) {
                this.bf.log.debug("Null KEY!!! " + cur.print());
            }
            cur = cur.levels[0];
        }
        for (int i = 1; i < l.levels.length; ++i) {
            SkipLevels lv = l.levels[i];
            if (lv == null || lvlSet.contains(lv)) continue;
            this.getAllLevels(lv, lvlSet);
        }
    }

    public boolean blvlck(boolean fix, int width, SkipLevels[] prevLevels) {
        this.bf.log.warn("    Skip level at width " + width);
        this.bf.log.warn("        levels " + this.levels.length);
        this.bf.log.warn("        first key " + this.key());
        this.bf.log.warn("        spanPage " + this.spanPage);
        this.bf.log.warn("        levelPage " + this.levelPage);
        SkipLevels higher = null;
        for (int i = this.levels.length - 1; i >= 0; --i) {
            if (this.levels[i] != null) {
                this.bf.log.info("                level " + i + " -> " + this.levels[i].key() + " ");
                if (higher == null || higher.key().compareTo(this.key()) >= 0) continue;
                this.bf.log.warn("                Higher level has lower key " + higher.key());
                continue;
            }
            this.bf.log.info("                level " + i + " empty");
            if (higher == null) continue;
            this.bf.log.warn("                Higher level is not empty, key is " + higher.key());
        }
        if (prevLevels != null) {
            int min = Math.min(prevLevels.length, this.levels.length);
            for (int i = 0; i < min; ++i) {
                if (prevLevels[i] == this) {
                    prevLevels[i] = this.levels[i];
                    continue;
                }
                if (prevLevels[i] != null) {
                    this.bf.log.warn("                Previous levels is non-null " + prevLevels[i].key() + " but not pointing to us at level " + i);
                    prevLevels[i] = this.levels[i];
                    continue;
                }
                if (this.levels[i] == null) continue;
                this.bf.log.warn("                Previous levels is null but we are non-null " + this.levels[i].key() + " at level " + i);
                prevLevels[i] = this.levels[i];
            }
        } else {
            prevLevels = new SkipLevels[this.levels.length];
            System.arraycopy(this.levels, 0, prevLevels, 0, this.levels.length);
        }
        if (this.levels[0] != null) {
            this.levels[0].blvlck(fix, width + 1, prevLevels);
        }
        return false;
    }

    public String toString() {
        String rv = "BSL height: " + this.levels.length + " page: " + this.levelPage + " span: " + this.bottom;
        if (this.isKilled) {
            rv = rv + " KILLED";
        }
        return rv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LevelComparator
    implements Comparator<SkipLevels> {
        private LevelComparator() {
        }

        @Override
        public int compare(SkipLevels l, SkipLevels r) {
            Comparable lk = l.key();
            Comparable rk = r.key();
            if (lk == null && rk == null) {
                return 0;
            }
            if (lk == null) {
                return 1;
            }
            if (rk == null) {
                return -1;
            }
            return rk.compareTo(lk);
        }
    }
}

