/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public final class SimpleByteCache {
    private static final Map<Integer, SimpleByteCache> _caches = new ConcurrentHashMap<Integer, SimpleByteCache>(8);
    private static final int DEFAULT_SIZE = 16;
    private Queue<byte[]> _available;
    private int _maxCached;
    private int _entrySize;

    public static SimpleByteCache getInstance(int size) {
        return SimpleByteCache.getInstance(16, size);
    }

    public static SimpleByteCache getInstance(int cacheSize, int size) {
        Integer sz = size;
        SimpleByteCache cache = _caches.get(sz);
        if (cache == null) {
            cache = new SimpleByteCache(cacheSize, size);
            _caches.put(sz, cache);
        }
        cache.resize(cacheSize);
        return cache;
    }

    public static void clearAll() {
        for (SimpleByteCache bc : _caches.values()) {
            bc.clear();
        }
    }

    private SimpleByteCache(int maxCachedEntries, int entrySize) {
        this._available = new LinkedBlockingQueue<byte[]>(maxCachedEntries);
        this._maxCached = maxCachedEntries;
        this._entrySize = entrySize;
    }

    private void resize(int maxCachedEntries) {
        byte[] ba;
        if (this._maxCached >= maxCachedEntries) {
            return;
        }
        this._maxCached = maxCachedEntries;
        LinkedBlockingQueue<byte[]> newLBQ = new LinkedBlockingQueue<byte[]>(maxCachedEntries);
        while ((ba = this._available.poll()) != null) {
            newLBQ.offer(ba);
        }
        this._available = newLBQ;
    }

    public static byte[] acquire(int size) {
        return SimpleByteCache.getInstance(size).acquire();
    }

    private byte[] acquire() {
        byte[] rv = this._available.poll();
        if (rv == null) {
            rv = new byte[this._entrySize];
        }
        return rv;
    }

    public static void release(byte[] entry) {
        SimpleByteCache cache = _caches.get(entry.length);
        if (cache != null) {
            cache.releaseIt(entry);
        }
    }

    private void releaseIt(byte[] entry) {
        if (entry == null || entry.length != this._entrySize) {
            return;
        }
        this._available.offer(entry);
    }

    private void clear() {
        this._available.clear();
    }
}

