/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;

public class MessageStatusMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 22;
    private long _sessionId = -1L;
    private long _messageId = -1L;
    private long _nonce = -1L;
    private long _size = -1L;
    private int _status = -1;
    public static final int STATUS_AVAILABLE = 0;
    public static final int STATUS_SEND_ACCEPTED = 1;
    public static final int STATUS_SEND_BEST_EFFORT_SUCCESS = 2;
    public static final int STATUS_SEND_BEST_EFFORT_FAILURE = 3;
    public static final int STATUS_SEND_GUARANTEED_SUCCESS = 4;
    public static final int STATUS_SEND_GUARANTEED_FAILURE = 5;

    public long getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(long id) {
        this._sessionId = id;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public void setMessageId(long id) {
        this._messageId = id;
    }

    public long getSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public long getNonce() {
        return this._nonce;
    }

    public void setNonce(long nonce) {
        this._nonce = nonce;
    }

    public static final String getStatusString(int status) {
        switch (status) {
            case 0: {
                return "AVAILABLE          ";
            }
            case 1: {
                return "SEND ACCEPTED      ";
            }
            case 2: {
                return "BEST EFFORT SUCCESS";
            }
            case 3: {
                return "BEST EFFORT FAILURE";
            }
            case 4: {
                return "GUARANTEED SUCCESS ";
            }
            case 5: {
                return "GUARANTEED FAILURE ";
            }
        }
        return "***INVALID STATUS: " + status;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
            this._status = (int)DataHelper.readLong(in, 1);
            this._size = DataHelper.readLong(in, 4);
            this._nonce = DataHelper.readLong(in, 4);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        int len = 15;
        try {
            DataHelper.writeLong(out, 4, len);
            DataHelper.writeLong(out, 1, this.getType());
            DataHelper.writeLong(out, 2, this._sessionId);
            DataHelper.writeLong(out, 4, this._messageId);
            DataHelper.writeLong(out, 1, this._status);
            DataHelper.writeLong(out, 4, this._size);
            DataHelper.writeLong(out, 4, this._nonce);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new UnsupportedOperationException("This shouldn't be called... use writeMessage(out)");
    }

    public int getType() {
        return 22;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MessageStatusMessage) {
            MessageStatusMessage msg = (MessageStatusMessage)object;
            return this._sessionId == msg.getSessionId() && this._messageId == msg.getMessageId() && this._nonce == msg.getNonce() && this._size == msg.getSize() && this._status == msg.getStatus();
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[MessageStatusMessage: ");
        buf.append("\n\tSessionId: ").append(this._sessionId);
        buf.append("\n\tNonce: ").append(this._nonce);
        buf.append("\n\tMessageId: ").append(this._messageId);
        buf.append("\n\tStatus: ").append(MessageStatusMessage.getStatusString(this._status));
        buf.append("\n\tSize: ").append(this._size);
        buf.append("]");
        return buf.toString();
    }
}

