/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.LookupDest;
import net.i2p.client.naming.NamingService;
import net.i2p.data.Destination;

class DummyNamingService
extends NamingService {
    protected static final int BASE32_HASH_LENGTH = 52;
    public static final String PROP_B32 = "i2p.naming.hostsTxt.useB32";
    protected static final int CACHE_MAX_SIZE = 32;
    public static final int DEST_SIZE = 516;
    private static final Map<String, Destination> _cache = new LHM<String, Destination>(32);

    protected DummyNamingService(I2PAppContext context) {
        super(context);
    }

    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        Destination d = DummyNamingService.getCache(hostname);
        if (d != null) {
            return d;
        }
        if (hostname.length() >= 516) {
            d = this.lookupBase64(hostname);
            if (d != null) {
                DummyNamingService.putCache(hostname, d);
            }
            return d;
        }
        if (hostname.length() == 60 && hostname.toLowerCase(Locale.US).endsWith(".b32.i2p") && this._context.getBooleanPropertyDefaultTrue(PROP_B32) && (d = LookupDest.lookupBase32Hash(this._context, hostname.substring(0, 52))) != null) {
            DummyNamingService.putCache(hostname, d);
            return d;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void putCache(String s, Destination d) {
        if (d == null) {
            return;
        }
        Map<String, Destination> map = _cache;
        synchronized (map) {
            _cache.put(s, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Destination getCache(String s) {
        Map<String, Destination> map = _cache;
        synchronized (map) {
            return _cache.get(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeCache(String s) {
        Map<String, Destination> map = _cache;
        synchronized (map) {
            _cache.remove(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearCache() {
        Map<String, Destination> map = _cache;
        synchronized (map) {
            _cache.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LHM<K, V>
    extends LinkedHashMap<K, V> {
        private final int _max;

        public LHM(int max) {
            super(max, 0.75f, true);
            this._max = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this._max;
        }
    }
}

