/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simulator.db;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.PostHoles;
import org.ourfilesystem.db.StorageInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.utilities.FileUtils;

public class StorageImpl
implements StorageInterface {
    public File BaseDir;
    public Peer MyPeerData;
    public KeySet KeySet;
    public ConcurrentHashMap<Long, Peer> Peers;
    public ConcurrentHashMap<Long, ConcurrentHashMap<Long, LocalPost>> Posts;
    public ConcurrentHashMap<Long, Long> MaxPostValue;
    public ConcurrentHashMap<Long, List<LocalPost>> File2Post;
    public ConcurrentHashMap<Long, LocalFileReference> Files;

    public StorageImpl(String base) {
        this.BaseDir = new File(base);
        this.BaseDir.mkdirs();
        this.Peers = new ConcurrentHashMap();
        this.Posts = new ConcurrentHashMap();
        this.MaxPostValue = new ConcurrentHashMap();
        this.File2Post = new ConcurrentHashMap();
        this.Files = new ConcurrentHashMap();
    }

    @Override
    public void saveMyPeerData(Peer peer) {
        this.MyPeerData = peer;
    }

    @Override
    public Peer getMyPeerData() {
        return this.MyPeerData;
    }

    @Override
    public void saveMyKeySet(KeySet keyset) {
        this.KeySet = keyset;
    }

    @Override
    public KeySet getMyKeySet() {
        return this.KeySet;
    }

    @Override
    public void savePeer(Peer peer) {
        this.Peers.put((Long)peer.getPeerKeysAndIdentity().getSignature().getDigest(), peer);
    }

    @Override
    public Peer getPeer(Object peerid) {
        return this.Peers.get((Long)peerid);
    }

    @Override
    public List<Peer> getPeerList() {
        LinkedList<Peer> pr = new LinkedList<Peer>();
        pr.addAll(this.Peers.values());
        return pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePost(LocalPost post) {
        LocalPost tp;
        ConcurrentHashMap<Long, LocalPost> pp = this.Posts.get(post.getPost().getSignedDigest().getPeerIdentifier());
        if (pp == null) {
            pp = new ConcurrentHashMap();
            this.Posts.put((Long)post.getPost().getSignedDigest().getPeerIdentifier(), pp);
        }
        if ((tp = pp.get(post.getPost().getPostNumber())) != null) {
            System.out.println("ERROR: The same post was received more than once! I am: " + this.MyPeerData.getPeerKeysAndIdentity().getSignature().getDigest() + " received the same post from peer: " + post.getPost().getSignedDigest().getPeerIdentifier() + " post number: " + post.getPost().getPostNumber());
        }
        pp.put(post.getPost().getPostNumber(), post);
        Long val = this.MaxPostValue.get(post.getPost().getSignedDigest().getPeerIdentifier());
        if (val == null) {
            val = post.getPost().getPostNumber();
            this.MaxPostValue.put((Long)post.getPost().getSignedDigest().getPeerIdentifier(), val);
        }
        if (val < post.getPost().getPostNumber()) {
            val = post.getPost().getPostNumber();
            this.MaxPostValue.put((Long)post.getPost().getSignedDigest().getPeerIdentifier(), val);
        }
        if (post.getPost().getFileReferenceDigest() != null) {
            List<LocalPost> pl = this.File2Post.get((Long)post.getPost().getFileReferenceDigest());
            if (pl == null) {
                pl = new LinkedList<LocalPost>();
                this.File2Post.put((Long)post.getPost().getFileReferenceDigest(), pl);
            }
            List<LocalPost> list = pl;
            synchronized (list) {
                pl.add(post);
            }
        }
    }

    @Override
    public List<LocalPost> getPeerPosts(Peer p, int page, int pagesize) {
        ConcurrentHashMap<Long, LocalPost> psts = this.Posts.get(p.getPeerKeysAndIdentity().getSignature().getDigest());
        LinkedList<LocalPost> rl = new LinkedList<LocalPost>();
        if (psts != null) {
            long cnt = page * pagesize;
            while (cnt < (long)((page + 1) * pagesize)) {
                LocalPost pst = psts.get(cnt);
                if (pst != null) {
                    rl.add(pst);
                }
                ++cnt;
            }
        }
        return rl;
    }

    @Override
    public List<LocalPost> getPeerPosts(Peer p, long start, long end) {
        ConcurrentHashMap<Long, LocalPost> psts = this.Posts.get(p.getPeerKeysAndIdentity().getSignature().getDigest());
        Long maxval = this.MaxPostValue.get(p.getPeerKeysAndIdentity().getSignature().getDigest());
        LinkedList<LocalPost> rl = new LinkedList<LocalPost>();
        if (psts != null) {
            long cnt = start;
            while (cnt <= end && cnt <= maxval) {
                LocalPost pst = psts.get(cnt);
                if (pst != null) {
                    rl.add(pst);
                }
                ++cnt;
            }
        }
        return rl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LocalPost> getFilePosts(Object dig, int page, int pagesize) {
        LinkedList<LocalPost> rl = new LinkedList<LocalPost>();
        List<LocalPost> pl = this.File2Post.get((Long)dig);
        if (pl != null) {
            List<LocalPost> list = pl;
            synchronized (list) {
                int idx = page * pagesize;
                while (idx < (page + 1) * pagesize) {
                    if (idx < pl.size()) {
                        rl.add(pl.get(idx));
                    }
                    ++idx;
                }
            }
        }
        return rl;
    }

    @Override
    public List<LocalPost> getPosts(Date fromdate) {
        LinkedList<LocalPost> rl = new LinkedList<LocalPost>();
        LinkedList peerlist = new LinkedList();
        peerlist.addAll(this.Posts.keySet());
        for (Long key : peerlist) {
            ConcurrentHashMap<Long, LocalPost> ppl = this.Posts.get(key);
            boolean done = false;
            long pn = this.MaxPostValue.get(key);
            while (pn >= 0L && !done) {
                LocalPost lp = ppl.get(pn);
                if (lp != null) {
                    if (lp.getLocalDate().compareTo(fromdate) >= 0) {
                        rl.add(lp);
                    } else {
                        done = true;
                    }
                }
                --pn;
            }
        }
        return rl;
    }

    @Override
    public void saveFile(LocalFileReference ref) {
        try {
            File fcopy = File.createTempFile("reference", ".dat");
            FileUtils.copyFile(ref.getFileReference().getFile(), fcopy, false);
            FileReference fr = new FileReference();
            fr.setFile(fcopy);
            fr.setUnsignedDigest(ref.getFileReference().getUnsignedDigest());
            ref.setFileReference(fr);
            this.Files.put((Long)fr.getUnsignedDigest(), ref);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public LocalFileReference getFileReference(Object dig) {
        if (dig == null) {
            return null;
        }
        return this.Files.get(dig);
    }

    @Override
    public List<LocalFileReference> getFileReferences(int page, int pagesize) {
        LinkedList<LocalFileReference> tlist = new LinkedList<LocalFileReference>();
        tlist.addAll(this.Files.values());
        LinkedList<LocalFileReference> rl = new LinkedList<LocalFileReference>();
        Iterator i = tlist.iterator();
        int cnt = 0;
        while (cnt < page * pagesize && i.hasNext()) {
            i.next();
            ++cnt;
        }
        cnt = 0;
        while (cnt < pagesize && i.hasNext()) {
            rl.add((LocalFileReference)i.next());
            ++cnt;
        }
        return rl;
    }

    @Override
    public List<LocalFileReference> getFileReferences(Date fromdate) {
        LinkedList<LocalFileReference> tlist = new LinkedList<LocalFileReference>();
        tlist.addAll(this.Files.values());
        LinkedList<LocalFileReference> rl = new LinkedList<LocalFileReference>();
        for (LocalFileReference lf : tlist) {
            if (lf.getLocalDate().compareTo(fromdate) < 0) continue;
            rl.add(lf);
        }
        return rl;
    }

    @Override
    public void close() {
    }

    @Override
    public Long getLastPostNumber(Peer p) {
        ConcurrentHashMap<Long, LocalPost> pp = this.Posts.get(p.getPeerKeysAndIdentity().getSignature().getDigest());
        if (pp != null) {
            long r = 0L;
            Iterator i = pp.keySet().iterator();
            while (i.hasNext()) {
                long v = (Long)i.next();
                if (v <= r) continue;
                r = v;
            }
            return r;
        }
        return null;
    }

    @Override
    public List<PostHoles> getPostHoles(Peer p) {
        return null;
    }

    @Override
    public void saveBadPeer(Peer p) {
    }

    @Override
    public List<Peer> listBadPeers() {
        return null;
    }

    @Override
    public boolean isBadPeer(Object id) {
        return false;
    }

    @Override
    public void removeBadPeer(Object id) {
    }

    @Override
    public void removePeer(Peer peer) {
    }
}

