/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simulator.com;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseComInterface;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.simulator.com.FileRequestQueueEntry;
import org.ourfilesystem.simulator.com.PeerRequestQueueEntry;
import org.ourfilesystem.simulator.com.PostRequestQueueEntry;
import org.ourfilesystem.utilities.Cloning;

public class ComPeerImpl
implements ComPeerInterface,
ConnectionUpdateInterface {
    public static List<ComPeerImpl> PeerConnections = new LinkedList<ComPeerImpl>();
    public boolean Closed = false;
    public Random Random;
    public CoreComInterface Core;
    public DataBaseComInterface DB;
    public ComPeerImpl ConnectedTo;
    public ConcurrentLinkedQueue<PeerRequestQueueEntry> PeerRequests = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<PostRequestQueueEntry> PostRequests = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<FileRequestQueueEntry> FileRequests = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Post> SentPosts;
    public ConcurrentLinkedQueue<List<Peer>> PeerReturns = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<List<Post>> PostReturns = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<File> FileReturns = new ConcurrentLinkedQueue();

    public static void StepProcess() {
        LinkedList<ComPeerImpl> copylist = new LinkedList<ComPeerImpl>();
        copylist.addAll(PeerConnections);
        for (ComPeerImpl c : copylist) {
            c.Process();
        }
        Iterator<Object> i = PeerConnections.iterator();
        while (i.hasNext()) {
            ComPeerImpl c;
            c = (ComPeerImpl)i.next();
            if (c.isOk()) continue;
            i.remove();
        }
    }

    public ComPeerImpl() {
        this.SentPosts = new ConcurrentLinkedQueue();
        this.Random = new Random();
        PeerConnections.add(this);
    }

    public Peer getThisPeer() {
        return this.DB.getMyPeer();
    }

    @Override
    public Peer getPeer() {
        if (this.ConnectedTo != null) {
            return this.ConnectedTo.getThisPeer();
        }
        return null;
    }

    @Override
    public boolean isOk() {
        return !this.Closed;
    }

    @Override
    public int getPendingRequests() {
        return this.PeerRequests.size() + this.PostRequests.size() + this.FileRequests.size() + this.PeerReturns.size() + this.PostReturns.size() + this.FileReturns.size();
    }

    @Override
    public void Close() {
        if (!this.Closed) {
            this.Closed = true;
            if (this.ConnectedTo != null) {
                this.ConnectedTo.Close();
            }
            while (this.getPendingRequests() > 0) {
                this.Process();
            }
            this.Core.connectionClosed(this.getPeer().getPeerKeysAndIdentity().getSignature().getDigest(), true);
        }
    }

    @Override
    public void requtestPosts(Object peerid, long fromnumber, long tonumber) {
        this.PostRequests.add(new PostRequestQueueEntry(peerid, fromnumber, tonumber));
    }

    @Override
    public void requestPeers() {
        this.PeerRequests.add(new PeerRequestQueueEntry());
    }

    @Override
    public void requestsFile(Object digest) {
        this.FileRequests.add(new FileRequestQueueEntry(digest));
    }

    public List<Post> doPostRequest(PostRequestQueueEntry p) {
        LinkedList<Post> lp = new LinkedList<Post>();
        List<Post> dlp = this.DB.requestPosts(p.Peer, p.From, p.To);
        Iterator<Post> i = dlp.iterator();
        while (i.hasNext()) {
            lp.add(Cloning.clonePost(i.next()));
        }
        return lp;
    }

    public List<Peer> doPeerRequest(PeerRequestQueueEntry p) {
        LinkedList<Peer> lp = new LinkedList<Peer>();
        List<Peer> dlp = this.DB.requestPeers();
        Iterator<Peer> i = dlp.iterator();
        while (i.hasNext()) {
            lp.add(Cloning.clonePeer(i.next()));
        }
        return lp;
    }

    public File doFileRequest(FileRequestQueueEntry p) {
        return this.DB.requestsFiles(p.Digest);
    }

    public void Process() {
        Post p;
        FileRequestQueueEntry fr;
        List<Peer> p2;
        PeerRequestQueueEntry er;
        PostRequestQueueEntry pr;
        File f;
        List<Peer> peerreturns;
        List<Post> postreturns;
        if ((double)this.Random.nextFloat() < 0.4) {
            return;
        }
        if ((double)this.Random.nextFloat() < 0.1) {
            this.Close();
        }
        if ((postreturns = this.PostReturns.poll()) != null) {
            this.DB.processPeerPosts(postreturns);
        }
        if ((peerreturns = this.PeerReturns.poll()) != null) {
            this.DB.processPeers(peerreturns);
        }
        if ((f = this.FileReturns.poll()) != null) {
            this.DB.processPeerFile(f);
        }
        if ((pr = this.PostRequests.poll()) != null) {
            if (this.isOk()) {
                List<Post> p3 = this.ConnectedTo.doPostRequest(pr);
                if (p3 != null) {
                    this.PostReturns.add(p3);
                }
            } else {
                this.Core.requestPostsFailed(this.getPeer().getPeerKeysAndIdentity().getSignature().getDigest(), pr.Peer, pr.From, pr.To);
            }
        }
        if ((er = this.PeerRequests.poll()) != null && this.isOk() && (p2 = this.ConnectedTo.doPeerRequest(er)) != null) {
            this.PeerReturns.add(p2);
        }
        if ((fr = this.FileRequests.poll()) != null) {
            if (this.isOk()) {
                File file = this.ConnectedTo.doFileRequest(fr);
                if (file != null) {
                    this.FileReturns.add(file);
                }
            } else {
                this.Core.requestFileFailed(this.getPeer().getPeerKeysAndIdentity().getSignature().getDigest(), fr.Digest);
            }
        }
        if ((p = this.SentPosts.poll()) != null) {
            LinkedList<Post> pl = new LinkedList<Post>();
            pl.add(p);
            this.ConnectedTo.DB.processPeerPosts(pl);
        }
    }

    @Override
    public void sendPost(Post post) {
        this.SentPosts.add(post);
    }

    @Override
    public void addEventInterface(EventInterface ev) {
    }
}

