/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simulator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.junit.Test;
import org.ourfilesystem.core.Core;
import org.ourfilesystem.db.DataBaseComImpl;
import org.ourfilesystem.db.LocalFileReference;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.simulator.UserImpl;
import org.ourfilesystem.simulator.com.ComConnectionImpl;
import org.ourfilesystem.simulator.com.ComPeerImpl;
import org.ourfilesystem.simulator.db.StorageImpl;
import org.ourfilesystem.simulator.db.TimeImpl;
import org.ourfilesystem.simulator.security.CryptoDataBaseImpl;
import org.ourfilesystem.utilities.Cloning;

public class Instance {
    private long CurFileNumber = 0L;
    private long CurPostNumber = 0L;
    private StorageImpl DB;
    private Core Core;
    private Random Random = new Random();
    private long ID;

    public void createNewFile() {
        try {
            File nf = File.createTempFile("datafile" + this.CurFileNumber, ".tmp");
            FileOutputStream fos = new FileOutputStream(nf);
            byte[] b = new byte[8];
            ByteBuffer buf = ByteBuffer.wrap(b);
            buf.putLong(0x1000000L * this.ID + this.CurFileNumber);
            fos.write(b);
            fos.close();
            this.Core.addLocalFile(nf, "User: " + this.ID + " adding file: " + this.CurFileNumber);
            ++this.CurFileNumber;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createPost() {
        this.Core.addLocalPost("User: " + this.ID + " added post: " + this.CurPostNumber, null);
        ++this.CurPostNumber;
    }

    public void requestFile() {
        List<LocalPost> plist = this.DB.getPosts(new Date(0L));
        Iterator<LocalPost> i = plist.iterator();
        LinkedList<Object> files = new LinkedList<Object>();
        while (i.hasNext()) {
            LocalPost lp = i.next();
            if (lp.getPost().getFileReferenceDigest() == null || !lp.getPost().isPosterHasFile() || lp.getPost().getSignedDigest().getPeerIdentifier().equals(this.getMyPeer().getPeerKeysAndIdentity().getSignature().getDigest())) continue;
            files.add(lp.getPost().getFileReferenceDigest());
        }
        if (files.size() > 0) {
            int idx = (int)(this.Random.nextFloat() * (float)files.size());
            Object dig = files.get(idx);
            this.Core.downloadFile(dig);
        }
    }

    public Peer getMyPeer() {
        return this.DB.getMyPeerData();
    }

    public void signPeer(Peer p) {
        this.Core.signPeer(Cloning.clonePeer(p));
    }

    public void update() {
        this.Core.updatePeers();
        this.Core.updatePosts();
    }

    public void setup(long id) {
        this.ID = id;
        this.Core = new Core();
        this.Core.setBusyMultiplier(1.0);
        this.Core.setMaxDownloadAttempts(30);
        this.Core.setMaxPostQuery(100);
        DataBaseComImpl dbcom = new DataBaseComImpl(this.Core);
        ComConnectionImpl com = new ComConnectionImpl(id, this.Core, dbcom);
        this.DB = new StorageImpl("dir" + id);
        CryptoDataBaseImpl crypt = new CryptoDataBaseImpl(id);
        TimeImpl time = new TimeImpl();
        UserImpl usr = new UserImpl();
        this.Core.setComDataBase(dbcom);
        this.Core.setUserDataBase(this.DB);
        this.Core.setComConnector(com);
        this.Core.addEventInterface(usr);
        dbcom.setSecurity(crypt);
        dbcom.setStore(this.DB);
        dbcom.setTime(time);
        dbcom.addEventInterface(usr);
        this.Core.setSecurity(crypt);
        this.Core.setUserDataBase(this.DB);
        this.Core.setTime(time);
        this.Core.setMyLocation(id);
        this.Core.generateNewKeys();
    }

    public static void run(Instance[] i) {
        int cnt = 0;
        while (cnt < 100) {
            int cnt2 = 0;
            while (cnt2 < i.length) {
                i[cnt2].update();
                ++cnt2;
            }
            cnt2 = 0;
            while (cnt2 < 100) {
                ComPeerImpl.StepProcess();
                ++cnt2;
            }
            ++cnt;
        }
    }

    public void dump() {
        System.out.println("\n====================== (" + this.ID + ") =======================");
        List<Peer> pl = this.DB.getPeerList();
        for (Peer p : pl) {
            System.out.println("PEER: " + p.getLocation() + " signed by: " + p.getPeerKeysAndIdentity().getSignature().getPeerIdentifier());
        }
        List<LocalPost> pstl = this.DB.getPosts(new Date(0L));
        for (LocalPost lp : pstl) {
            System.out.println("POST: " + lp.getLocalDate() + " " + lp.getPost().getPostNumber() + " " + lp.getPost().getMessage() + " " + Long.toHexString((Long)lp.getPost().getSignedDigest().getSignature()));
        }
        List<LocalFileReference> fl = this.DB.getFileReferences(new Date(0L));
        for (LocalFileReference f : fl) {
            System.out.println("FILE: " + f.getLocalDate() + " " + f.getFileReference().getFile() + " " + Long.toHexString((Long)f.getFileReference().getUnsignedDigest()));
        }
    }

    @Test
    public void main() {
        int NumInst = 4;
        Instance[] i = new Instance[NumInst];
        int cnt = 0;
        while (cnt < NumInst) {
            i[cnt] = new Instance();
            i[cnt].setup(cnt);
            ++cnt;
        }
        Peer p0 = i[0].getMyPeer();
        Peer p1 = i[1].getMyPeer();
        Peer p2 = i[2].getMyPeer();
        Peer p3 = i[3].getMyPeer();
        i[0].signPeer(p1);
        i[0].createPost();
        i[0].createNewFile();
        Instance.run(i);
        i[0].dump();
        i[1].dump();
        i[1].signPeer(p0);
        i[1].createNewFile();
        i[1].createPost();
        Instance.run(i);
        i[0].dump();
        i[1].dump();
        i[2].signPeer(p0);
        i[0].signPeer(p2);
        i[2].createPost();
        i[2].createNewFile();
        Instance.run(i);
        i[0].dump();
        i[1].dump();
        i[2].dump();
        i[3].dump();
        i[2].signPeer(p3);
        i[3].signPeer(p2);
        i[2].requestFile();
        Instance.run(i);
        i[0].dump();
        i[1].dump();
        i[2].dump();
        i[3].dump();
        Instance.run(i);
        i[0].requestFile();
        i[1].requestFile();
        i[2].requestFile();
        i[3].requestFile();
        Instance.run(i);
        i[0].dump();
        i[1].dump();
        i[2].dump();
        i[3].dump();
    }
}

