/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.core.Core;
import org.ourfilesystem.db.FileReference;
import org.ourfilesystem.utilities.FileUtils;

public class NewPostDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField textField;
    private JLabel fileLabel;
    private JTextPane textPane;
    private Core Core;
    private File TempDir;
    private File localFile;
    private FileReference FileReference;

    public NewPostDialog(Core core, FileReference f, String dir) {
        this.TempDir = new File(dir);
        if (!this.TempDir.exists()) {
            this.TempDir.mkdirs();
        }
        this.Core = core;
        this.FileReference = f;
        this.setTitle("New Post");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][][][grow]"));
        JLabel lblSubject = new JLabel("Subject");
        this.contentPanel.add((Component)lblSubject, "cell 0 0,alignx left");
        this.textField = new JTextField();
        this.contentPanel.add((Component)this.textField, "cell 0 1,growx");
        this.textField.setColumns(10);
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "cell 0 3,grow");
        this.textPane = new JTextPane();
        scrollPane.setViewportView(this.textPane);
        JButton btnAttachFile = new JButton("Attach File");
        this.contentPanel.add((Component)btnAttachFile, "flowx,cell 0 2");
        btnAttachFile.setActionCommand("ATTACH");
        btnAttachFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser;
                int returnVal;
                if (e.getActionCommand().equals("ATTACH") && (returnVal = (chooser = new JFileChooser()).showOpenDialog(NewPostDialog.this.contentPanel)) == 0) {
                    NewPostDialog.this.localFile = chooser.getSelectedFile();
                    NewPostDialog.this.fileLabel.setText(NewPostDialog.this.localFile.getPath());
                }
            }
        });
        this.fileLabel = new JLabel("No File");
        this.contentPanel.add((Component)this.fileLabel, "cell 0 2");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Post");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.setActionCommand("POST");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("POST")) {
                    String subject = NewPostDialog.this.textField.getText();
                    String text = NewPostDialog.this.textPane.getText();
                    try {
                        File tmpfile = File.createTempFile("post", ".dat", NewPostDialog.this.TempDir);
                        FileOutputStream fos = new FileOutputStream(tmpfile);
                        FileUtils.writeString(subject, fos);
                        FileUtils.writeString(text, fos);
                        fos.close();
                        if (NewPostDialog.this.localFile == null || !NewPostDialog.this.localFile.exists()) {
                            Object fr = null;
                            if (NewPostDialog.this.FileReference != null) {
                                fr = NewPostDialog.this.FileReference.getUnsignedDigest();
                            }
                            NewPostDialog.this.Core.addLocalPost(tmpfile, fr);
                        } else {
                            NewPostDialog.this.Core.addLocalFile(NewPostDialog.this.localFile, tmpfile);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    NewPostDialog.this.dispose();
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Cancel")) {
                    NewPostDialog.this.dispose();
                }
            }
        });
        this.updateFileLabel();
    }

    private void updateFileLabel() {
        if (this.FileReference != null) {
            this.fileLabel.setText(this.FileReference.getUnsignedDigest().toString().substring(0, 10));
        }
    }
}

