/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.LocalPost;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.Codec;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.simpleui.SimpleGUI;
import org.ourfilesystem.simpleui.UploadDialog;

public class NewExpandedPostDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JPanel PostPanel;
    private File TempDir;
    private PostDecoded Reference;
    private JLabel ReferenceLabel;
    private File NewReferenceFile;
    private HashMap<String, JTextField> StringValues;
    private HashMap<String, JTextField> StringCompleteValues;
    private HashMap<String, JTextField> NumberValues;
    private HashMap<String, HashMap<String, JCheckBox>> StringSelect;
    private HashMap<String, ReferencesTableModel> References;
    private JTextPane Comment;
    private SimpleGUI GUI;
    private File ChooserDir;
    public static String COMMENT = "COMMENT";

    public NewExpandedPostDialog(SimpleGUI gui, String template, String tmpdir) {
        this.GUI = gui;
        this.ChooserDir = new File(".");
        this.TempDir = new File(tmpdir);
        this.setTitle("New Post");
        this.setBounds(100, 100, 750, 550);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.contentPanel);
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 3));
        this.setDefaultCloseOperation(1);
        final JPanel buttonpanel = new JPanel();
        buttonpanel.setBorder(BorderFactory.createLineBorder(Color.black));
        buttonpanel.setMinimumSize(new Dimension(0, 150));
        JButton loadbtn = new JButton("Load Post Template");
        buttonpanel.add(loadbtn);
        loadbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(NewExpandedPostDialog.this.ChooserDir);
                int returnVal = chooser.showOpenDialog(buttonpanel);
                if (returnVal == 0) {
                    System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
                    File f = chooser.getSelectedFile();
                    try {
                        NewExpandedPostDialog.this.setVisible(false);
                        NewExpandedPostDialog.this.loadTemplateFile(NewExpandedPostDialog.this.PostPanel, f);
                        NewExpandedPostDialog.this.setVisible(true);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(buttonpanel, "There was a problem with that template file.");
                        e.printStackTrace();
                    }
                }
                NewExpandedPostDialog.this.ChooserDir = chooser.getCurrentDirectory();
            }
        });
        this.ReferenceLabel = new JLabel("<none>");
        JButton attachfile = new JButton("Attach File");
        attachfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(NewExpandedPostDialog.this.ChooserDir);
                int returnVal = chooser.showOpenDialog(buttonpanel);
                if (returnVal == 0) {
                    System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
                    File f = chooser.getSelectedFile();
                    NewExpandedPostDialog.this.addFile(f);
                }
                NewExpandedPostDialog.this.ChooserDir = chooser.getCurrentDirectory();
            }
        });
        buttonpanel.add(attachfile);
        JButton clearref = new JButton("Clear File");
        clearref.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewExpandedPostDialog.this.clearFile();
            }
        });
        buttonpanel.add(clearref);
        buttonpanel.add(this.ReferenceLabel);
        this.contentPanel.add(buttonpanel);
        this.PostPanel = new JPanel();
        this.PostPanel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this.PostPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel buttonpanel2 = new JPanel();
        buttonpanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        JButton clearall = new JButton("Clear All");
        clearall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewExpandedPostDialog.this.clearValues();
            }
        });
        buttonpanel2.add(clearall);
        JButton post = new JButton("Post");
        buttonpanel2.add(post);
        post.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewExpandedPostDialog.this.doPost();
            }
        });
        JButton cancel = new JButton("Cancel");
        buttonpanel2.add(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NewExpandedPostDialog.this.setVisible(false);
            }
        });
        File f = new File(template);
        if (f.exists()) {
            try {
                this.setVisible(false);
                this.loadTemplateFile(this.PostPanel, f);
                this.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(buttonpanel2, "There was a problem with that template file.");
                e.printStackTrace();
            }
        }
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.PostPanel);
        this.PostPanel.setMinimumSize(new Dimension(0, 500));
        this.contentPanel.add(sp);
        this.contentPanel.add(buttonpanel2);
        this.setVisible(false);
    }

    public synchronized void doPost() {
        boolean oktopost = true;
        boolean hasdata = false;
        PostDecoded pd = new PostDecoded();
        if (this.StringSelect != null) {
            for (Map.Entry<String, Serializable> entry : this.StringSelect.entrySet()) {
                for (Map.Entry e2 : ((HashMap)entry.getValue()).entrySet()) {
                    if (!((JCheckBox)e2.getValue()).isSelected()) continue;
                    pd.pushStringValue(entry.getKey(), (String)e2.getKey());
                    hasdata = true;
                }
            }
        }
        if (this.StringValues != null) {
            for (Map.Entry<String, Serializable> entry : this.StringValues.entrySet()) {
                String[] parts = ((JTextField)entry.getValue()).getText().split("\\s+");
                int cnt = 0;
                while (cnt < parts.length) {
                    pd.pushStringValue(entry.getKey(), parts[cnt]);
                    hasdata = true;
                    ++cnt;
                }
            }
        }
        if (this.StringCompleteValues != null) {
            for (Map.Entry<String, Serializable> entry : this.StringCompleteValues.entrySet()) {
                String v = ((JTextField)entry.getValue()).getText();
                Matcher m = Pattern.compile("\\S+").matcher(v);
                if (!m.find()) continue;
                pd.pushStringValue(entry.getKey(), v);
                hasdata = true;
            }
        }
        if (this.NumberValues != null) {
            for (Map.Entry<String, Serializable> entry : this.NumberValues.entrySet()) {
                String vs = ((JTextField)entry.getValue()).getText();
                if (vs.equals("")) {
                    pd.getNumberValues().put(entry.getKey(), 0L);
                    continue;
                }
                try {
                    long v = Long.valueOf(((JTextField)entry.getValue()).getText());
                    pd.getNumberValues().put(entry.getKey(), v);
                    hasdata = true;
                }
                catch (Exception exp) {
                    oktopost = false;
                    JOptionPane.showMessageDialog(this.contentPanel, String.valueOf(entry.getKey()) + " should be a number.");
                }
            }
        }
        if (this.References != null) {
            for (Map.Entry<String, Serializable> entry : this.References.entrySet()) {
                for (PostDecoded npd : ((ReferencesTableModel)entry.getValue()).List) {
                    Object ref = npd.getPost().getPost().getFileReferenceDigest();
                    if (ref == null) continue;
                    pd.pushReferenceValue(entry.getKey(), ref);
                    hasdata = true;
                }
            }
        }
        Post p = new Post();
        if (this.Reference != null) {
            p.setFileReferenceDigest(this.Reference.getPost().getPost().getFileReferenceDigest());
            hasdata = true;
        }
        if (this.Comment != null) {
            pd.pushStringValue(COMMENT, this.Comment.getText());
            hasdata = true;
        }
        if (oktopost && hasdata) {
            try {
                LocalPost localPost = new LocalPost();
                localPost.setPost(p);
                pd.setPost(localPost);
                File tf = File.createTempFile("newpost", ".dat", this.TempDir);
                p.setMessage(tf);
                if (this.Reference != null) {
                    Long num;
                    Set<String> fnstr = this.Reference.getStringKeySet(FileHandler.FILENAME);
                    if (fnstr != null) {
                        pd.getStringValues().put(FileHandler.FILENAME, fnstr);
                    }
                    if ((num = this.Reference.getNumberValues().get(FileHandler.LARGEFILEKEY)) != null) {
                        pd.getNumberValues().put(FileHandler.LARGEFILEKEY, num);
                    }
                }
                Codec.ecnode(pd);
                if (this.NewReferenceFile != null) {
                    final File newfile = this.NewReferenceFile;
                    final PostDecoded rpd = pd;
                    final UploadDialog ud = new UploadDialog();
                    ud.setVisible(true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewExpandedPostDialog.this.GUI.insertFile(newfile, rpd);
                            ud.setVisible(false);
                        }
                    });
                } else if (this.Reference != null) {
                    this.GUI.addLocalPost(p.getMessage(), this.Reference.getPost().getPost().getFileReferenceDigest());
                } else {
                    this.GUI.addLocalPost(p.getMessage(), null);
                }
                this.setVisible(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void clearStringOptions() {
        for (Map.Entry<String, HashMap<String, JCheckBox>> e1 : this.StringSelect.entrySet()) {
            for (JCheckBox jcb : e1.getValue().values()) {
                jcb.setSelected(false);
            }
        }
    }

    public synchronized void clearValues() {
        Iterator<Map.Entry<String, Serializable>> i;
        this.clearFile();
        this.clearStringOptions();
        if (this.StringValues != null) {
            i = this.StringValues.entrySet().iterator();
            while (i.hasNext()) {
                i.next().getValue().setText("");
            }
        }
        if (this.StringCompleteValues != null) {
            i = this.StringCompleteValues.entrySet().iterator();
            while (i.hasNext()) {
                i.next().getValue().setText("");
            }
        }
        if (this.NumberValues != null) {
            i = this.NumberValues.entrySet().iterator();
            while (i.hasNext()) {
                ((JTextField)i.next().getValue()).setText("");
            }
        }
        if (this.References != null) {
            for (Map.Entry<String, Serializable> entry : this.References.entrySet()) {
                ((ReferencesTableModel)entry.getValue()).clear();
            }
        }
        if (this.Comment != null) {
            this.Comment.setText("");
        }
    }

    public synchronized void addFile(File f) {
        if (f != null && f.exists() && f.isFile()) {
            this.NewReferenceFile = f;
            this.Reference = null;
            this.ReferenceLabel.setText(this.NewReferenceFile.getName());
        }
    }

    public synchronized void clearFile() {
        this.NewReferenceFile = null;
        this.Reference = null;
        this.ReferenceLabel.setText("<none>");
    }

    public synchronized void addReference(String key, PostDecoded p) {
        ReferencesTableModel m = this.References.get(key);
        if (m != null) {
            m.addNew(p);
        }
    }

    public synchronized void addReference(PostDecoded pd) {
        this.Reference = pd;
        this.NewReferenceFile = null;
        Set<String> fn = pd.getStringKeySet(FileHandler.FILENAME);
        if (fn != null && fn.size() > 0) {
            this.ReferenceLabel.setText(fn.iterator().next());
        }
    }

    public synchronized Set<String> getReferenceKeys() {
        HashSet<String> hs = new HashSet<String>();
        Iterator<String> i = this.References.keySet().iterator();
        while (i.hasNext()) {
            hs.add(i.next());
        }
        return hs;
    }

    private void loadTemplateFile(JPanel panel, File templatefile) throws IOException {
        this.StringValues = new HashMap();
        this.StringCompleteValues = new HashMap();
        this.NumberValues = new HashMap();
        this.StringSelect = new HashMap();
        this.References = new HashMap();
        this.Comment = new JTextPane();
        panel.removeAll();
        int rows = 0;
        FileReader fr = new FileReader(templatefile);
        BufferedReader br = new BufferedReader(fr);
        String cmd = br.readLine();
        while (cmd != null) {
            JTextField tf;
            JLabel l;
            String[] lp = cmd.split("\\s+");
            if (lp[0].equals("STRO") && lp.length > 2 && this.StringSelect.get(lp[1]) == null) {
                l = new JLabel(lp[1]);
                panel.add((Component)l, "cell 0 " + rows + ",alignx left");
                HashMap<String, JCheckBox> cblist = new HashMap<String, JCheckBox>();
                this.StringSelect.put(lp[1], cblist);
                int cnt = 2;
                while (cnt < lp.length) {
                    JCheckBox cb = new JCheckBox(lp[cnt]);
                    cblist.put(lp[cnt], cb);
                    panel.add((Component)cb, "cell 1 " + rows + ",growx");
                    ++cnt;
                }
                ++rows;
            }
            if (lp[0].equals("STR") && lp.length == 2 && this.StringValues.get(lp[1]) == null) {
                l = new JLabel(lp[1]);
                panel.add((Component)l, "cell 0 " + rows + ",alignx left");
                tf = new JTextField();
                panel.add((Component)tf, "cell 1 " + rows + ",growx");
                this.StringValues.put(lp[1], tf);
                ++rows;
            }
            if (lp[0].equals("STRC") && lp.length == 2 && this.StringCompleteValues.get(lp[1]) == null) {
                l = new JLabel(lp[1]);
                panel.add((Component)l, "cell 0 " + rows + ",alignx left");
                tf = new JTextField();
                panel.add((Component)tf, "cell 1 " + rows + ",growx");
                this.StringCompleteValues.put(lp[1], tf);
                ++rows;
            }
            if (lp[0].equals("NUM") && lp.length == 2 && this.NumberValues.get(lp[1]) == null) {
                l = new JLabel(lp[1]);
                panel.add((Component)l, "cell 0 " + rows + ",alignx left");
                tf = new JTextField();
                panel.add((Component)tf, "cell 1 " + rows + ",growx");
                this.NumberValues.put(lp[1], tf);
                ++rows;
            }
            if (lp[0].equals("REF") && lp.length == 2 && this.References.get(lp[1]) == null) {
                l = new JLabel("is a " + lp[1] + " of");
                panel.add((Component)l, "cell 0 " + rows + ",alignx left");
                ReferencesTableModel mod = new ReferencesTableModel();
                JTable t = new JTable(mod);
                JScrollPane p = new JScrollPane(t);
                p.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
                panel.add((Component)p, "cell 1 " + rows + ",growx");
                JButton but = new JButton("Clear");
                panel.add((Component)but, "cell 1 " + rows);
                but.setActionCommand(lp[1]);
                but.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        NewExpandedPostDialog.this.clearReferences(arg0.getActionCommand());
                    }
                });
                this.References.put(lp[1], mod);
                ++rows;
            }
            if (lp[0].equals("COMMENT")) {
                l = new JLabel("Comment");
                panel.add((Component)l, "cell 0 " + rows + ",alignx left,grow");
                JScrollPane sp = new JScrollPane();
                sp.setMinimumSize(new Dimension(0, 200));
                sp.setViewportView(this.Comment);
                panel.add((Component)sp, "cell 1 " + rows + ",growx");
                ++rows;
            }
            cmd = br.readLine();
        }
        br.close();
    }

    private void clearReferences(String ref) {
        ReferencesTableModel m = this.References.get(ref);
        if (m != null) {
            m.clear();
        }
    }

    private class ReferencesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public LinkedList<PostDecoded> List = new LinkedList();

        public void addNew(PostDecoded pd) {
            this.List.add(pd);
            this.fireTableDataChanged();
        }

        public void clear() {
            this.List.clear();
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "File Name";
            }
            if (col == 1) {
                return "Digest";
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.List.size();
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            PostDecoded pd = this.List.get(arg0);
            if (arg1 == 0 && pd != null) {
                Set<String> nl = pd.getStringValues().get(FileHandler.FILENAME);
                if (nl != null && nl.size() > 0) {
                    return nl.iterator().next();
                }
                return "<none>";
            }
            if (arg1 == 1 && pd != null && pd.getPost() != null && pd.getPost().getPost() != null) {
                return pd.getPost().getPost().getFileReferenceDigest();
            }
            return null;
        }
    }
}

