/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSI2PConnector;
import org.ourfilesystem.com.OFSI2PServerSocket;
import org.ourfilesystem.com.OFSServerSocket;
import org.ourfilesystem.com.SimpleConnector;
import org.ourfilesystem.com.SimpleServerSocket;
import org.ourfilesystem.simpleui.SimpleGUI;

public class NetworkConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static String I2PKey = "USEI2P";
    private static String ProxyAddrKey = "PROXYADDR";
    private static String ProxyPortKey = "PROXYPORT";
    private static String ProxyUseKey = "PROXYUSE";
    private static String PeerPortKey = "PEERPORT";
    private final JPanel contentPanel = new JPanel();
    private JTextField textField;
    private JTextField textField_1;
    private JCheckBox useproxy;
    private boolean SimpleStarted;
    private boolean I2PStarted;
    private boolean UseI2P;
    private boolean UseProxy;
    private String ProxyAddr;
    private int ProxyPort;
    private int PeerPort;
    private SimpleServerSocket SimpleServer;
    private SimpleConnector SimpleConnector;
    private OFSI2PServerSocket I2PServer;
    private OFSI2PConnector I2PConnector;
    private String BaseDir;
    private SimpleGUI GUI;
    private File ConfigFile;
    private JTextField peerPort;
    private JCheckBox UseI2PBox;

    private boolean LoadConfig() {
        boolean loadedok = false;
        Properties p = new Properties();
        if (this.ConfigFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.ConfigFile);
                p.load(fis);
                fis.close();
                loadedok = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not read the proxy configuration file!");
            }
        }
        this.UseI2P = Boolean.valueOf(p.getProperty(I2PKey, "false"));
        this.UseProxy = Boolean.valueOf(p.getProperty(ProxyUseKey, "true"));
        this.ProxyAddr = p.getProperty(ProxyAddrKey, "127.0.0.1");
        this.ProxyPort = Integer.valueOf(p.getProperty(ProxyPortKey, "9050"));
        this.PeerPort = Integer.valueOf(p.getProperty(PeerPortKey, "9140"));
        return loadedok;
    }

    private void SaveConfig() {
        Properties p = new Properties();
        p.setProperty(I2PKey, Boolean.toString(this.UseI2P));
        p.setProperty(ProxyUseKey, Boolean.toString(this.UseProxy));
        p.setProperty(ProxyAddrKey, this.ProxyAddr);
        p.setProperty(ProxyPortKey, Integer.toString(this.ProxyPort));
        p.setProperty(PeerPortKey, Integer.toString(this.PeerPort));
        try {
            FileOutputStream fos = new FileOutputStream(this.ConfigFile);
            p.store(fos, "proxy configuration for ofs");
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OFSServerSocket getServerSocket() {
        if (this.SimpleServer == null) {
            try {
                this.SimpleServer = new SimpleServerSocket(new ServerSocket(this.PeerPort));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.SimpleServer;
        }
        return this.SimpleServer;
    }

    public OFSConnector getConnector() {
        if (this.SimpleConnector == null) {
            this.SimpleConnector = new SimpleConnector(this.UseProxy, this.ProxyAddr, this.ProxyPort);
        }
        this.SimpleConnector.setProxyAddr(this.ProxyAddr);
        this.SimpleConnector.setUseProxy(this.UseProxy);
        this.SimpleConnector.setProxyPort(this.ProxyPort);
        return this.SimpleConnector;
    }

    public NetworkConfigDialog(SimpleGUI gui, String bd) {
        this.GUI = gui;
        this.SimpleStarted = false;
        this.I2PStarted = false;
        this.BaseDir = bd;
        File basedir = new File(this.BaseDir);
        if (!basedir.exists()) {
            basedir.mkdirs();
        }
        this.ConfigFile = new File(String.valueOf(this.BaseDir) + File.separator + "proxy.cfg");
        boolean justgo = this.LoadConfig();
        this.setTitle("Network Configuration");
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][][][][]"));
        this.UseI2PBox = new JCheckBox("Use I2P");
        this.contentPanel.add((Component)this.UseI2PBox, "cell 1 2");
        this.UseI2PBox.setSelected(this.UseI2P);
        JSeparator separator = new JSeparator();
        this.contentPanel.add((Component)separator, "cell 1 5");
        JLabel lblSocksProxyAddress = new JLabel("SOCKS Proxy address");
        this.contentPanel.add((Component)lblSocksProxyAddress, "cell 0 6,alignx trailing");
        this.textField = new JTextField();
        this.contentPanel.add((Component)this.textField, "cell 1 6,growx");
        this.textField.setColumns(10);
        this.textField.setText(this.getProxyAddr());
        JLabel lblSocksProxyPort = new JLabel("SOCKS Proxy Port");
        this.contentPanel.add((Component)lblSocksProxyPort, "cell 0 7,alignx trailing");
        this.textField_1 = new JTextField();
        this.contentPanel.add((Component)this.textField_1, "cell 1 7,growx");
        this.textField_1.setColumns(10);
        this.textField_1.setText(Integer.toString(this.getProxyPort()));
        this.useproxy = new JCheckBox("Enable SOCKS Proxy");
        this.useproxy.setSelected(this.isUseProxy());
        this.contentPanel.add((Component)this.useproxy, "cell 1 8");
        JLabel lblPeerPort = new JLabel("Peer Port");
        this.contentPanel.add((Component)lblPeerPort, "cell 0 9,alignx trailing");
        this.peerPort = new JTextField();
        this.contentPanel.add((Component)this.peerPort, "cell 1 9,growx");
        this.peerPort.setColumns(10);
        this.peerPort.setText(Integer.toString(this.getPeerPort()));
        this.setEditable();
        this.UseI2PBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                NetworkConfigDialog.this.setEditable();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                NetworkConfigDialog.this.go();
            }
        });
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        if (justgo) {
            this.setVisible(false);
            this.go();
        } else {
            this.setVisible(true);
        }
    }

    private void setEditable() {
        this.useproxy.setEnabled(!this.UseI2PBox.isSelected());
        this.textField.setEditable(!this.UseI2PBox.isSelected());
        this.textField_1.setEditable(!this.UseI2PBox.isSelected());
        this.peerPort.setEditable(!this.UseI2PBox.isSelected());
    }

    private void go() {
        if (this.UseI2PBox.isSelected()) {
            this.UseI2P = true;
            this.goI2P();
        } else {
            this.UseI2P = false;
            if (!this.useproxy.isSelected()) {
                this.UseProxy = false;
                this.goSimple();
            } else {
                String addr = this.textField.getText();
                if (!addr.matches("\\S+")) {
                    JOptionPane.showMessageDialog(this.contentPanel, "Improper proxy address.");
                } else {
                    String portstr = this.textField_1.getText();
                    if (!portstr.matches("\\d+")) {
                        JOptionPane.showMessageDialog(this.contentPanel, "Proxy port must be a number.");
                    } else {
                        try {
                            this.ProxyPort = Integer.valueOf(portstr);
                            this.ProxyAddr = addr;
                            this.UseProxy = true;
                            this.goSimple();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(this.contentPanel, "The proxy port seems to be invalid.");
                        }
                    }
                }
            }
        }
    }

    public void goI2P() {
        this.SaveConfig();
        if (!this.SimpleStarted) {
            if (this.I2PServer == null) {
                try {
                    this.I2PServer = new OFSI2PServerSocket(String.valueOf(this.BaseDir) + File.separator + "i2pkey.dat");
                    this.I2PConnector = (OFSI2PConnector)this.I2PServer.getOFSConnector();
                    this.GUI.InitPeer(this.I2PServer, this.I2PConnector, false);
                    this.GUI.setLocation(this.I2PServer.getMyLocation());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.contentPanel, "Sorry, I couldn't get I2P.  Did you install with I2P?");
                }
                this.I2PStarted = true;
            }
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, "You will have to restart for your changes to take effect.");
        }
        this.setVisible(false);
    }

    public void goSimple() {
        this.SaveConfig();
        if (!this.I2PStarted) {
            try {
                this.PeerPort = Integer.valueOf(this.peerPort.getText());
                if (this.SimpleServer == null) {
                    this.SimpleServer = new SimpleServerSocket(new ServerSocket(this.PeerPort));
                    this.SimpleConnector = new SimpleConnector(this.UseProxy, this.ProxyAddr, this.ProxyPort);
                    this.GUI.InitPeer(this.SimpleServer, this.SimpleConnector, true);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.contentPanel, "The peer port seems to be invalid.");
                return;
            }
            this.SimpleConnector.setProxyAddr(this.ProxyAddr);
            this.SimpleConnector.setProxyPort(this.ProxyPort);
            this.SimpleConnector.setUseProxy(this.UseProxy);
            if (this.SimpleStarted) {
                JOptionPane.showMessageDialog(this.contentPanel, "If you have changed your peer port you will need to restart.");
            }
            this.SimpleStarted = true;
        } else {
            JOptionPane.showMessageDialog(this.contentPanel, "You will have to restart for your changes to take effect.");
        }
        this.setVisible(false);
    }

    public boolean isUseProxy() {
        return this.UseProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.UseProxy = useProxy;
    }

    public String getProxyAddr() {
        return this.ProxyAddr;
    }

    public void setProxyAddr(String proxyAddr) {
        this.ProxyAddr = proxyAddr;
    }

    public int getProxyPort() {
        return this.ProxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.ProxyPort = proxyPort;
    }

    public int getPeerPort() {
        return this.PeerPort;
    }

    public JCheckBox getUseI2PBox() {
        return this.UseI2PBox;
    }
}

