/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.filehander.FileHandler;
import org.ourfilesystem.postcodec.PostDecoded;
import org.ourfilesystem.ui.db.DBInterface;
import org.ourfilesystem.ui.db.QueryResultsInterface;
import org.ourfilesystem.utilities.HumReadFileSize;

public class ExpandedPostTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Data;
    private DBInterface DB;
    private String[] columns = new String[]{"Date", "Poster", "Subject", "Rating", "File", "Size"};

    public ExpandedPostTableModel(DBInterface db) {
        this.DB = db;
    }

    public synchronized void setQueryResults(QueryResultsInterface data) {
        this.Data = data;
        System.out.println("ExpandedPostTable received new data: " + this.Data);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    public Class getColumnClass(int col) {
        if (col == 3) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public synchronized int getRowCount() {
        QueryResultsInterface qr = this.Data;
        if (qr != null) {
            return qr.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public synchronized PostDecoded getPost(int rowIndex) {
        QueryResultsInterface qr = this.Data;
        if (qr != null) {
            PostDecoded dec = qr.get(rowIndex);
            return dec;
        }
        return null;
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        PostDecoded dec = this.getPost(rowIndex);
        if (dec != null) {
            Set<String> l;
            Peer p;
            if (columnIndex == 0) {
                return dec.getPost().getLocalDate().toString();
            }
            if (columnIndex == 1 && (p = this.DB.searchPeer(dec.getPost().getPost().getSignedDigest().getPeerIdentifier())) != null) {
                return p.getNickSig();
            }
            if (columnIndex == 2 && (l = dec.getStringKeySet("SUBJECT")) != null && l.size() > 0) {
                return l.iterator().next();
            }
            if (columnIndex == 3) {
                Long r = dec.getNumberValues().get("RATING");
                if (r != null) {
                    return r;
                }
                return 0L;
            }
            if (columnIndex == 4 && (l = dec.getStringKeySet(FileHandler.FILENAME)) != null && l.size() > 0) {
                return l.iterator().next();
            }
            if (columnIndex == 5) {
                Long v = dec.getNumberValues().get(FileHandler.FILESIZE);
                if (v != null) {
                    return HumReadFileSize.fileSize(v);
                }
                return "";
            }
        }
        return null;
    }
}

