/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.simpleui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.StorageInterface;
import org.ourfilesystem.simpleui.PeerTable;
import org.ourfilesystem.simpleui.SearchPanel;

public class BadPeerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTable table;
    private PeerTable PeerTable;
    private JPopupMenu PeerPopup;
    private StorageInterface Store;
    private SearchPanel SearchPanel;

    public void addAllPeers(List<Peer> peers) {
        this.PeerTable.addAllPeers(peers);
    }

    public BadPeerDialog() {
        this.setTitle("Bad Peers");
        this.setBounds(100, 100, 450, 300);
        this.PeerTable = new PeerTable();
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.PeerPopup = new JPopupMenu("Bad Peers");
        JMenuItem exp = new JMenuItem("Mark Selected Peers as Good");
        this.PeerPopup.add(exp);
        exp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] rows = BadPeerDialog.this.table.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = BadPeerDialog.this.table.convertRowIndexToModel(rows[cnt]);
                    Peer p = BadPeerDialog.this.PeerTable.getPeer(r);
                    BadPeerDialog.this.Store.removeBadPeer(p.getPeerKeysAndIdentity().getSignature().getDigest());
                    ++cnt;
                }
                BadPeerDialog.this.update();
            }
        });
        JMenuItem exl = new JMenuItem("Exclude selected peers from search results.");
        this.PeerPopup.add(exl);
        exl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] rows = BadPeerDialog.this.table.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = BadPeerDialog.this.table.convertRowIndexToModel(rows[cnt]);
                    Peer p = BadPeerDialog.this.PeerTable.getPeer(r);
                    if (p != null) {
                        BadPeerDialog.this.SearchPanel.addExcludePeer(p);
                    }
                    ++cnt;
                }
                BadPeerDialog.this.update();
            }
        });
        JMenuItem inc = new JMenuItem("Include selected peers in search results.");
        this.PeerPopup.add(inc);
        inc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                int[] rows = BadPeerDialog.this.table.getSelectedRows();
                int cnt = 0;
                while (cnt < rows.length) {
                    int r = BadPeerDialog.this.table.convertRowIndexToModel(rows[cnt]);
                    Peer p = BadPeerDialog.this.PeerTable.getPeer(r);
                    if (p != null) {
                        BadPeerDialog.this.SearchPanel.addIncludePeer(p);
                    }
                    ++cnt;
                }
                BadPeerDialog.this.update();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "Center");
        this.table = new JTable(this.PeerTable);
        this.table.setAutoCreateRowSorter(true);
        scrollPane.setViewportView(this.table);
        this.table.setComponentPopupMenu(this.PeerPopup);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton btnNewButton = new JButton("Update");
        buttonPane.add(btnNewButton);
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BadPeerDialog.this.update();
            }
        });
        JButton cancelButton = new JButton("Dismiss");
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BadPeerDialog.this.setVisible(false);
            }
        });
    }

    public void update() {
        this.addAllPeers(this.Store.listBadPeers());
    }

    public void setStore(StorageInterface store) {
        this.Store = store;
    }

    public SearchPanel getSearchPanel() {
        return this.SearchPanel;
    }

    public void setSearchPanel(SearchPanel searchPanel) {
        this.SearchPanel = searchPanel;
    }
}

