/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.filehander;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;

public class FileSplitter {
    public static long MAXFILESIZE = 0x1900000000L;

    public static List<File> split(File f, File tmpdir, long size) throws IOException {
        LinkedList<File> rl = new LinkedList<File>();
        FileInputStream fis = new FileInputStream(f);
        FileChannel fic = fis.getChannel();
        long remainlen = fic.size();
        long pos = 0L;
        while (remainlen > 0L) {
            File nf = File.createTempFile("peice", ".dat", tmpdir);
            System.out.println("> " + nf);
            rl.add(nf);
            FileOutputStream fos = new FileOutputStream(nf);
            FileChannel foc = fos.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(16);
            long transfersize = Math.min(remainlen, size);
            remainlen -= transfersize;
            buf.putLong(pos);
            buf.putLong(transfersize);
            buf.clear();
            while (buf.hasRemaining()) {
                foc.write(buf);
            }
            long wrlen = fic.transferTo(pos, transfersize, foc);
            while (wrlen < transfersize) {
                wrlen = fic.transferTo(pos += wrlen, transfersize -= wrlen, foc);
            }
            pos += wrlen;
            foc.close();
        }
        fic.close();
        return rl;
    }

    public static void insert(File fullfile, File peice) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(fullfile, "rw");
        FileChannel foc = raf.getChannel();
        FileInputStream fis = new FileInputStream(peice);
        FileChannel fic = fis.getChannel();
        ByteBuffer buf = ByteBuffer.allocate(16);
        while (buf.hasRemaining()) {
            fic.read(buf);
        }
        buf.clear();
        long pos = buf.getLong();
        long size = buf.getLong();
        if (pos + size > MAXFILESIZE) {
            throw new IOException("Cannot create file this large.");
        }
        if (size != fic.size() - fic.position()) {
            throw new IOException("File peice corrupted.");
        }
        foc.position(pos);
        buf = ByteBuffer.allocateDirect(1024);
        while (size > 0L) {
            fic.read(buf);
            buf.flip();
            foc.write(buf);
            size -= (long)buf.position();
            buf.compact();
        }
        foc.close();
        fic.close();
    }
}

