/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.com;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKeyFile;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSI2PConnector;
import org.ourfilesystem.com.OFSI2PSocket;
import org.ourfilesystem.com.OFSServerSocket;
import org.ourfilesystem.com.OFSSocket;

public class OFSI2PServerSocket
implements OFSServerSocket {
    private I2PSocketManager Manager = null;
    private I2PServerSocket Server;

    public OFSI2PServerSocket(String kfn) throws IOException, DataFormatException {
        File f = new File(kfn);
        if (f.exists()) {
            FileInputStream fis = new FileInputStream(f);
            this.Manager = I2PSocketManagerFactory.createManager((InputStream)fis);
            fis.close();
        } else {
            this.Manager = I2PSocketManagerFactory.createManager();
            PrivateKeyFile pkf = new PrivateKeyFile(f, this.Manager.getSession());
            pkf.write();
        }
        this.Server = this.Manager.getServerSocket();
    }

    public String getMyLocation() {
        I2PSession ses = this.Manager.getSession();
        return ses.getMyDestination().toBase64();
    }

    public OFSConnector getOFSConnector() {
        OFSI2PConnector con = new OFSI2PConnector(this.Manager);
        return con;
    }

    @Override
    public OFSSocket accept() throws IOException {
        try {
            I2PSocket sock = this.Server.accept();
            if (sock != null) {
                return new OFSI2PSocket(sock);
            }
        }
        catch (I2PException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        try {
            this.Server.close();
        }
        catch (I2PException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }
}

