/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.com;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSSocket;
import org.ourfilesystem.com.SignatureRequestInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseComInterface;
import org.ourfilesystem.db.Peer;
import org.ourfilesystem.db.Post;
import org.ourfilesystem.security.CryptoComInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class ComPeerImpl
implements ComPeerInterface,
ConnectionUpdateInterface {
    public static int FilePendingPentality = 1;
    private OFSConnector Connector;
    private Object PeerId;
    private OFSSocket Socket;
    private boolean Ok;
    private boolean CClosed;
    private CoreComInterface Core;
    private SignatureRequestInterface SignatureRequest;
    private DataBaseComInterface DB;
    private CryptoComInterface Crypt;
    private IncomingThread Incoming;
    private OutgoingThread Outgoing;
    private int RequestsPending;
    private File TempDir;
    private ConcurrentLinkedQueue<PostRequest> PostRequestPending;
    private ConcurrentLinkedQueue<Object> FileRequestPending;
    private LinkedList<EventInterface> Events;
    private Peer ConnectedPeer;
    private long MaxPendingWithNoData = 300000L;
    private InputTimer Timer;
    private static int REQUEST_POSTS = 1;
    private static int REQUEST_PEERS = 2;
    private static int REQUEST_FILES = 3;
    private static int SEND_POSTS = 4;
    private static int SEND_PEERS = 5;
    private static int SEND_FILES = 6;
    private static int PUSH_POST = 7;
    private static int SEND_FILE_NOT_FOUND = 8;
    private static int SEND_NO_POSTS = 9;

    public ComPeerImpl(CoreComInterface core, DataBaseComInterface db, CryptoComInterface crypt, SignatureRequestInterface req, Peer p, File td, OFSSocket sock) {
        this.init(core, db, crypt, req, p, td, null, sock);
    }

    public ComPeerImpl(CoreComInterface core, DataBaseComInterface db, CryptoComInterface crypt, SignatureRequestInterface req, Peer p, File td, OFSConnector con) {
        this.init(core, db, crypt, req, p, td, con, null);
    }

    public ComPeerImpl(CoreComInterface core, DataBaseComInterface db, CryptoComInterface crypt, SignatureRequestInterface req, Peer p, File td, OFSConnector con, OFSSocket sock) {
        this.init(core, db, crypt, req, p, td, con, sock);
    }

    private void init(CoreComInterface core, DataBaseComInterface db, CryptoComInterface crypt, SignatureRequestInterface req, Peer p, File td, OFSConnector con, OFSSocket sock) {
        this.Events = new LinkedList();
        this.CClosed = false;
        this.Connector = con;
        this.Socket = sock;
        this.SignatureRequest = req;
        this.ConnectedPeer = p;
        if (this.ConnectedPeer != null) {
            this.PeerId = this.ConnectedPeer.getPeerKeysAndIdentity().getSignature().getDigest();
        }
        this.Core = core;
        this.Crypt = crypt;
        this.DB = db;
        this.Ok = true;
        this.TempDir = td;
        this.Timer = new InputTimer();
        Thread t2 = new Thread(this.Timer);
        t2.start();
        this.PostRequestPending = new ConcurrentLinkedQueue();
        this.FileRequestPending = new ConcurrentLinkedQueue();
        this.Incoming = new IncomingThread(this);
        this.Outgoing = new OutgoingThread(this);
        HandShakeThread hs = new HandShakeThread(this);
        Thread t = new Thread(hs);
        t.start();
    }

    private void startBigThreads() {
        Thread ti = new Thread(this.Incoming);
        ti.start();
        Thread to = new Thread(this.Outgoing);
        to.start();
    }

    @Override
    public Peer getPeer() {
        return this.ConnectedPeer;
    }

    @Override
    public boolean isOk() {
        return this.Ok;
    }

    @Override
    public int getPendingRequests() {
        return this.RequestsPending;
    }

    @Override
    public void Close() {
        if (!this.CClosed && this.PeerId != null) {
            this.Core.connectionClosed(this.PeerId, true);
        }
        this.Ok = false;
        this.CClosed = true;
        try {
            if (this.Socket != null) {
                this.Socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Timer.DataReceived();
        if (this.Incoming != null) {
            this.Incoming.Close();
        }
        if (this.Outgoing != null) {
            this.Outgoing.Close();
        }
        this.failPending();
    }

    private void failPending() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (this.PostRequestPending.size() > 0) {
            PostRequest pr = this.PostRequestPending.poll();
            if (pr == null) continue;
            this.Core.requestPostsFailed(this.PeerId, pr.Id, pr.Start, pr.End);
        }
        while (this.FileRequestPending.size() > 0) {
            Object dig = this.FileRequestPending.poll();
            if (dig == null) continue;
            this.Core.requestFileFailed(this.PeerId, dig);
        }
    }

    @Override
    public void requtestPosts(Object peerid, long fromnumber, long tonumber) {
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.addRequest();
            this.Outgoing.requestPosts(peerid, fromnumber, tonumber);
        } else {
            this.Core.requestPostsFailed(this.PeerId, peerid, fromnumber, tonumber);
        }
    }

    @Override
    public void requestPeers() {
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.addRequest();
            this.Outgoing.requestPeers();
        }
    }

    @Override
    public void requestsFile(Object digest) {
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.addFileRequest();
            this.Outgoing.requestFile(digest);
        } else {
            this.Core.requestFileFailed(this.PeerId, digest);
        }
    }

    @Override
    public void sendPost(Post post) {
        this.Outgoing.sendPost(post);
    }

    public void doRequtestPosts(Object peerid, long fromnumber, long tonumber) {
        List<Post> list = this.DB.requestPosts(peerid, fromnumber, tonumber);
        if (list.size() > 0) {
            this.Outgoing.addPosts(list);
        } else {
            this.Outgoing.addNoPosts(peerid);
        }
    }

    public void doRequestPeers() {
        List<Peer> list = this.DB.requestPeers();
        this.Outgoing.addPeers(list);
    }

    public void doRequestsFile(Object digest) {
        File f = this.DB.requestsFiles(digest);
        if (f != null) {
            this.Outgoing.addFile(f);
        } else {
            this.Outgoing.addNotFound(digest);
        }
    }

    private synchronized void addFileRequest() {
        this.RequestsPending += FilePendingPentality;
        this.fireUpdate();
    }

    private synchronized void popFileRequest() {
        this.RequestsPending -= FilePendingPentality;
        if (this.RequestsPending < 0) {
            this.RequestsPending = 0;
        }
        this.fireUpdate();
    }

    private synchronized void addRequest() {
        ++this.RequestsPending;
        this.fireUpdate();
    }

    private synchronized void popRequest() {
        --this.RequestsPending;
        if (this.RequestsPending < 0) {
            this.RequestsPending = 0;
        }
        this.fireUpdate();
    }

    private void addPostRequestPending(PostRequest pr) {
        if (pr != null) {
            this.PostRequestPending.add(pr);
        }
    }

    private void addFileRequestPending(Object dig) {
        if (dig != null) {
            this.FileRequestPending.add(dig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePostRequestPending(Object dig) {
        if (dig != null) {
            ConcurrentLinkedQueue<PostRequest> concurrentLinkedQueue = this.PostRequestPending;
            synchronized (concurrentLinkedQueue) {
                Iterator<PostRequest> i = this.PostRequestPending.iterator();
                while (i.hasNext()) {
                    PostRequest pr = i.next();
                    if (!pr.Id.equals(dig)) continue;
                    i.remove();
                }
            }
        }
    }

    private void removeFileRequestPending(Object dig) {
        while (this.FileRequestPending.remove(dig)) {
        }
    }

    public long getMaxPendingWithNoData() {
        return this.MaxPendingWithNoData;
    }

    public void setMaxPendingWithNoData(long maxPendingWithNoData) {
        this.MaxPendingWithNoData = maxPendingWithNoData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdate() {
        LinkedList<EventInterface> rl = new LinkedList<EventInterface>();
        LinkedList<EventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            rl.addAll(this.Events);
        }
        Iterator i = rl.iterator();
        while (i.hasNext()) {
            ((EventInterface)i.next()).connectionEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventInterface(EventInterface ev) {
        LinkedList<EventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            this.Events.add(ev);
        }
    }

    class HandShakeThread
    implements Runnable {
        private ComPeerImpl Com;

        public HandShakeThread(ComPeerImpl i) {
            this.Com = i;
        }

        @Override
        public void run() {
            try {
                if (ComPeerImpl.this.Socket == null) {
                    ComPeerImpl.this.Socket = ComPeerImpl.this.Connector.connect((String)ComPeerImpl.this.ConnectedPeer.getLocation());
                }
                if (ComPeerImpl.this.Socket == null) {
                    ComPeerImpl.this.Close();
                } else {
                    InputStream is = ComPeerImpl.this.Socket.getInputStream();
                    OutputStream os = ComPeerImpl.this.Socket.getOutputStream();
                    BBytes outchallenge = (BBytes)this.Com.Crypt.getChallenge();
                    FileUtils.writeBytes(os, outchallenge.getBytes());
                    os.flush();
                    KeySet ks = this.Com.DB.getMyKeySet();
                    BBytes inchallenge = new BBytes(FileUtils.readBytes(is));
                    SignedDigest signedchallenge = this.Com.Crypt.signChallenge(inchallenge, ks);
                    Peer mypeer = this.Com.DB.getMyPeer();
                    FileUtils.writePeer(os, mypeer);
                    SecurityTools.writeSignedDigest(signedchallenge, os);
                    os.flush();
                    ComPeerImpl.this.ConnectedPeer = FileUtils.readPeer(is);
                    SignedDigest inchallenge_check = SecurityTools.readSignedDigest(is);
                    boolean rightconnection = true;
                    if (this.Com.PeerId != null) {
                        if (!this.Com.PeerId.equals(ComPeerImpl.this.ConnectedPeer.getPeerKeysAndIdentity().getSignature().getDigest())) {
                            rightconnection = false;
                            System.out.println("ERROR: We're not connected to who we thought we were!");
                        }
                    } else {
                        this.Com.PeerId = ComPeerImpl.this.ConnectedPeer.getPeerKeysAndIdentity().getSignature().getDigest();
                    }
                    LinkedList<Peer> pl = new LinkedList<Peer>();
                    pl.add(ComPeerImpl.this.ConnectedPeer);
                    this.Com.DB.processPeers(pl);
                    Peer check_peer = this.Com.DB.getPeer(ComPeerImpl.this.ConnectedPeer.getPeerKeysAndIdentity().getSignature().getDigest());
                    if (check_peer == null) {
                        if (!ComPeerImpl.this.DB.isBadPeer(ComPeerImpl.this.ConnectedPeer.getPeerKeysAndIdentity().getSignature().getDigest())) {
                            ComPeerImpl.this.SignatureRequest.SignatureRequest(ComPeerImpl.this.ConnectedPeer);
                        }
                        this.Com.Close();
                    } else if (check_peer != null && rightconnection) {
                        if (this.Com.Crypt.verifyChallenge(outchallenge, inchallenge_check, check_peer)) {
                            LinkedList<Peer> uplist = new LinkedList<Peer>();
                            uplist.add(ComPeerImpl.this.ConnectedPeer);
                            this.Com.DB.processPeers(uplist);
                            this.Com.startBigThreads();
                            ComPeerImpl.this.Core.newConnection(this.Com);
                        } else {
                            System.out.println("ERROR: Invalid authentication signature!");
                            this.Com.Close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.Com.Close();
            }
        }
    }

    class IncomingThread
    implements Runnable {
        private ComPeerImpl Com;
        private boolean Ok;
        private boolean Closed;

        public IncomingThread(ComPeerImpl i) {
            this.Com = i;
            this.Ok = true;
            this.Closed = false;
        }

        public void Close() {
            if (!this.Closed) {
                this.Closed = true;
                this.Com.Close();
            }
        }

        @Override
        public void run() {
            try {
                InputStream is = ComPeerImpl.this.Socket.getInputStream();
                while (this.Ok && ComPeerImpl.this.Socket.isConnected() && !ComPeerImpl.this.Socket.isClosed() && !this.Closed) {
                    LinkedList<Post> list;
                    int v = is.read();
                    if (v == REQUEST_PEERS) {
                        ComPeerImpl.this.addRequest();
                        this.Com.doRequestPeers();
                    } else if (v == REQUEST_POSTS) {
                        ComPeerImpl.this.addRequest();
                        BBytes id = new BBytes(FileUtils.readBytes(is));
                        long start = FileUtils.readLong(is);
                        long end = FileUtils.readLong(is);
                        this.Com.doRequtestPosts(id, start, end);
                    } else if (v == REQUEST_FILES) {
                        ComPeerImpl.this.addFileRequest();
                        BBytes id = new BBytes(FileUtils.readBytes(is));
                        this.Com.doRequestsFile(id);
                    } else if (v == SEND_POSTS) {
                        long numposts = FileUtils.readLong(is);
                        list = new LinkedList<Post>();
                        Post p = null;
                        int cnt = 0;
                        while ((long)cnt < numposts) {
                            p = FileUtils.readPost(is, ComPeerImpl.this.TempDir);
                            list.add(p);
                            ++cnt;
                        }
                        this.Com.DB.processPeerPosts(list);
                        if (p != null) {
                            ComPeerImpl.this.removePostRequestPending(p.getSignedDigest().getPeerIdentifier());
                            ComPeerImpl.this.Core.requestPostSucceed(this.Com, p.getSignedDigest().getPeerIdentifier());
                        }
                        this.Com.popRequest();
                    } else if (v == SEND_NO_POSTS) {
                        BBytes db = new BBytes(FileUtils.readBytes(is));
                        ComPeerImpl.this.removePostRequestPending(db);
                        ComPeerImpl.this.Core.requestPostSucceed(this.Com, db);
                        this.Com.popRequest();
                    } else if (v == SEND_PEERS) {
                        long numpeers = FileUtils.readLong(is);
                        list = new LinkedList();
                        int cnt = 0;
                        while ((long)cnt < numpeers) {
                            Peer p = FileUtils.readPeer(is);
                            list.add((Post)((Object)p));
                            ++cnt;
                        }
                        this.Com.DB.processPeers(list);
                        this.Com.popRequest();
                    } else if (v == SEND_FILES) {
                        File f = File.createTempFile("datafile", ".dat", ComPeerImpl.this.TempDir);
                        FileUtils.readFile(is, f);
                        Object dig = this.Com.DB.processPeerFile(f);
                        ComPeerImpl.this.removeFileRequestPending(dig);
                        ComPeerImpl.this.Core.requestFileSucceed(this.Com, dig);
                        this.Com.popFileRequest();
                    } else if (v == PUSH_POST) {
                        Post p = FileUtils.readPost(is, ComPeerImpl.this.TempDir);
                        LinkedList<Post> l = new LinkedList<Post>();
                        l.add(p);
                        this.Com.DB.processPeerPosts(l);
                    } else if (v == SEND_FILE_NOT_FOUND) {
                        BBytes db = new BBytes(FileUtils.readBytes(is));
                        ComPeerImpl.this.Core.requestFileFailed(ComPeerImpl.this.PeerId, db);
                        this.Com.popFileRequest();
                    } else {
                        System.out.println("Unexpected command: " + v);
                        this.Close();
                    }
                    ComPeerImpl.this.Timer.DataReceived();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.Close();
            }
        }
    }

    class InputTimer
    implements Runnable {
        InputTimer() {
        }

        public synchronized void waitInputProgress() {
            long timestart = new Date().getTime();
            try {
                this.wait(ComPeerImpl.this.MaxPendingWithNoData);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long endtime = new Date().getTime();
            if (endtime - timestart > ComPeerImpl.this.MaxPendingWithNoData - 10L && ComPeerImpl.this.getPendingRequests() > 0) {
                ComPeerImpl.this.Close();
            }
        }

        public synchronized void DataReceived() {
            this.notifyAll();
        }

        @Override
        public void run() {
            while (!ComPeerImpl.this.CClosed) {
                this.waitInputProgress();
            }
        }
    }

    class OutgoingThread
    implements Runnable {
        private ComPeerImpl Com;
        private boolean Ok;
        private boolean Closed;
        private boolean RequestPeers;
        private ConcurrentLinkedQueue<PostRequest> PostRequestQueue;
        private ConcurrentLinkedQueue<Object> FileRequestQueue;
        private ConcurrentLinkedQueue<List<Peer>> PeerQueue;
        private ConcurrentLinkedQueue<List<Post>> PostQueue;
        private ConcurrentLinkedQueue<File> FileQueue;
        private ConcurrentLinkedQueue<Post> OutPostQueue;
        private ConcurrentLinkedQueue<Object> NotFoundQueue;
        private ConcurrentLinkedQueue<Object> NoPostsQueue;

        public OutgoingThread(ComPeerImpl i) {
            this.Com = i;
            this.Ok = true;
            this.Closed = false;
            this.RequestPeers = false;
            this.PeerQueue = new ConcurrentLinkedQueue();
            this.PostQueue = new ConcurrentLinkedQueue();
            this.FileQueue = new ConcurrentLinkedQueue();
            this.PostRequestQueue = new ConcurrentLinkedQueue();
            this.FileRequestQueue = new ConcurrentLinkedQueue();
            this.OutPostQueue = new ConcurrentLinkedQueue();
            this.NotFoundQueue = new ConcurrentLinkedQueue();
            this.NoPostsQueue = new ConcurrentLinkedQueue();
        }

        public synchronized void requestFile(Object id) {
            this.FileRequestQueue.add(id);
            this.notifyAll();
        }

        public synchronized void requestPosts(Object id, long start, long end) {
            PostRequest pr = new PostRequest();
            pr.Id = id;
            pr.Start = start;
            pr.End = end;
            this.PostRequestQueue.add(pr);
            this.notifyAll();
        }

        public synchronized void addNoPosts(Object peerid) {
            this.NoPostsQueue.add(peerid);
            this.notifyAll();
        }

        public synchronized void addNotFound(Object dig) {
            this.NotFoundQueue.add(dig);
            this.notifyAll();
        }

        public synchronized void sendPost(Post p) {
            this.OutPostQueue.add(p);
            this.notifyAll();
        }

        public synchronized void requestPeers() {
            this.RequestPeers = true;
            this.notifyAll();
        }

        public synchronized void addPeers(List<Peer> p) {
            this.PeerQueue.add(p);
            this.notifyAll();
        }

        public synchronized void addPosts(List<Post> p) {
            this.PostQueue.add(p);
            this.notifyAll();
        }

        public synchronized void addFile(File f) {
            this.FileQueue.add(f);
            this.notifyAll();
        }

        public void Close() {
            if (!this.Closed) {
                this.Closed = true;
                this.Com.Close();
            }
            while (this.PostRequestQueue.size() > 0) {
                PostRequest pr = this.PostRequestQueue.poll();
                if (pr == null) continue;
                this.Com.Core.requestPostsFailed(this.Com.PeerId, pr.Id, pr.Start, pr.End);
            }
            while (this.FileRequestQueue.size() > 0) {
                Object dig = this.FileRequestQueue.poll();
                if (dig == null) continue;
                this.Com.Core.requestFileFailed(this.Com.PeerId, dig);
            }
        }

        private synchronized void WaitForData() {
            if (this.RequestPeers) {
                return;
            }
            if (this.PeerQueue.size() > 0) {
                return;
            }
            if (this.PostQueue.size() > 0) {
                return;
            }
            if (this.FileQueue.size() > 0) {
                return;
            }
            if (this.PostRequestQueue.size() > 0) {
                return;
            }
            if (this.FileRequestQueue.size() > 0) {
                return;
            }
            if (this.OutPostQueue.size() > 0) {
                return;
            }
            if (this.NotFoundQueue.size() > 0) {
                return;
            }
            if (this.NoPostsQueue.size() > 0) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                OutputStream os = ComPeerImpl.this.Socket.getOutputStream();
                while (this.Ok && ComPeerImpl.this.Socket.isConnected() && !ComPeerImpl.this.Socket.isClosed() && !this.Closed) {
                    File sf;
                    List<Post> postlist;
                    List<Peer> peerlist;
                    Post pp;
                    Object np;
                    Object nfd;
                    Object dig;
                    this.WaitForData();
                    if (this.RequestPeers) {
                        this.RequestPeers = false;
                        os.write(REQUEST_PEERS);
                    }
                    PostRequest pr = this.PostRequestQueue.poll();
                    ComPeerImpl.this.addPostRequestPending(pr);
                    if (pr != null) {
                        os.write(REQUEST_POSTS);
                        dig = (BBytes)pr.Id;
                        FileUtils.writeBytes(os, ((BBytes)dig).getBytes());
                        FileUtils.writeLong(pr.Start, os);
                        FileUtils.writeLong(pr.End, os);
                    }
                    dig = this.FileRequestQueue.poll();
                    ComPeerImpl.this.addFileRequestPending(dig);
                    if (dig != null) {
                        os.write(REQUEST_FILES);
                        BBytes b = (BBytes)dig;
                        FileUtils.writeBytes(os, b.getBytes());
                    }
                    if ((nfd = this.NotFoundQueue.poll()) != null) {
                        BBytes nfb = (BBytes)nfd;
                        os.write(SEND_FILE_NOT_FOUND);
                        FileUtils.writeBytes(os, nfb.getBytes());
                        ComPeerImpl.this.popFileRequest();
                    }
                    if ((np = this.NoPostsQueue.poll()) != null) {
                        BBytes nfb = (BBytes)np;
                        os.write(SEND_NO_POSTS);
                        FileUtils.writeBytes(os, nfb.getBytes());
                        ComPeerImpl.this.popRequest();
                    }
                    if ((pp = this.OutPostQueue.poll()) != null) {
                        os.write(PUSH_POST);
                        FileUtils.writePost(os, pp);
                    }
                    if ((peerlist = this.PeerQueue.poll()) != null) {
                        os.write(SEND_PEERS);
                        int sendsize = peerlist.size();
                        int sentsize = 0;
                        FileUtils.writeLong(sendsize, os);
                        Iterator<Peer> i = peerlist.iterator();
                        while (i.hasNext() && sentsize < sendsize) {
                            Peer peer = i.next();
                            FileUtils.writePeer(os, peer);
                            ++sentsize;
                        }
                        if (sentsize != sendsize) {
                            this.Close();
                        }
                        ComPeerImpl.this.popRequest();
                    }
                    if ((postlist = this.PostQueue.poll()) != null) {
                        os.write(SEND_POSTS);
                        int sendsize = postlist.size();
                        int sentsize = 0;
                        FileUtils.writeLong(sendsize, os);
                        Iterator<Post> i = postlist.iterator();
                        while (i.hasNext() && sentsize < sendsize) {
                            Post post = i.next();
                            FileUtils.writePost(os, post);
                            ++sentsize;
                        }
                        if (sentsize != sendsize) {
                            this.Close();
                        }
                        ComPeerImpl.this.popRequest();
                    }
                    if ((sf = this.FileQueue.poll()) == null) continue;
                    os.write(SEND_FILES);
                    FileUtils.sendFile(os, sf);
                    ComPeerImpl.this.popFileRequest();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.Close();
            }
        }
    }

    class PostRequest {
        public Object Id;
        public long Start;
        public long End;

        PostRequest() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PostRequest)) {
                return false;
            }
            PostRequest pr = (PostRequest)obj;
            if (this.Id == null) {
                return false;
            }
            if (pr.Id == null) {
                return false;
            }
            return this.Id.equals(pr.Id);
        }

        public int hashCode() {
            return this.Id.hashCode();
        }
    }
}

