/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.qlin;

import com.db4o.foundation.DynamicVariable;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.qlin.Prototypes;
import com.db4o.qlin.PrototypesException;
import com.db4o.qlin.QLinException;
import com.db4o.qlin.QLinOrderByDirection;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.core.ReflectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QLinSupport {
    private static final boolean IGNORE_TRANSIENT_FIELDS = true;
    private static final int RECURSION_DEPTH = 4;
    private static final Prototypes _prototypes = new Prototypes(Prototypes.defaultReflector(), 4, true);
    private static final DynamicVariable<ReflectClass> _context = DynamicVariable.newInstance();

    public static <T> T prototype(Class<T> clazz) {
        try {
            return _prototypes.prototypeForClass(clazz);
        }
        catch (PrototypesException ex) {
            throw new QLinException(ex);
        }
    }

    public static void context(ReflectClass claxx) {
        _context.value(claxx);
    }

    public static void context(Class clazz) {
        _context.value(ReflectorUtils.reflectClassFor(_prototypes.reflector(), clazz));
    }

    public static <T> T p(Class<T> clazz) {
        return QLinSupport.prototype(clazz);
    }

    public static QLinOrderByDirection ascending() {
        return QLinOrderByDirection.ASCENDING;
    }

    public static QLinOrderByDirection descending() {
        return QLinOrderByDirection.DESCENDING;
    }

    public static Iterator4<String> backingFieldPath(Object expression) {
        QLinSupport.checkForNull(expression);
        if (expression instanceof ReflectField) {
            return Iterators.iterate(((ReflectField)expression).getName());
        }
        Iterator4<String> path = _prototypes.backingFieldPath(_context.value(), expression);
        if (path != null) {
            return path;
        }
        return Iterators.iterate(QLinSupport.fieldByFieldName(expression).getName());
    }

    public static ReflectField field(Object expression) {
        QLinSupport.checkForNull(expression);
        if (expression instanceof ReflectField) {
            return (ReflectField)expression;
        }
        Iterator4<String> path = _prototypes.backingFieldPath(_context.value(), expression);
        if (path != null) {
            if (path.moveNext()) {
                expression = path.current();
            }
            if (path.moveNext()) {
                path.reset();
                throw new QLinException("expression can not be converted to a single field. It evaluates to: " + Iterators.join(path, "[", "]", ", "));
            }
        }
        return QLinSupport.fieldByFieldName(expression);
    }

    private static ReflectField fieldByFieldName(Object expression) {
        ReflectField field;
        if (expression instanceof String && (field = ReflectorUtils.field(_context.value(), (String)expression)) != null) {
            return field;
        }
        throw new QLinException("expression can not be mapped to a field");
    }

    private static void checkForNull(Object expression) {
        if (expression == null) {
            throw new QLinException("expression can not be null");
        }
    }
}

