/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.qlin;

import com.db4o.ObjectSet;
import com.db4o.foundation.IntIterator4;
import com.db4o.internal.qlin.QLinSodaNode;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.qlin.QLin;
import com.db4o.qlin.QLinException;
import com.db4o.qlin.QLinSupport;
import com.db4o.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QLinRoot<T>
extends QLinSodaNode<T> {
    private final QQuery _query;
    private int _limit = -1;

    public QLinRoot(Query query, Class<T> clazz) {
        this._query = (QQuery)query;
        query.constrain(clazz);
        QLinSupport.context(clazz);
    }

    public Query query() {
        return this._query;
    }

    @Override
    public ObjectSet<T> select() {
        if (this._limit == -1) {
            return this._query.execute();
        }
        QueryResult queryResult = this._query.getQueryResult();
        IdListQueryResult limitedResult = new IdListQueryResult(this._query.transaction(), this._limit);
        int counter = 0;
        IntIterator4 i = queryResult.iterateIDs();
        while (i.moveNext() && counter++ < this._limit) {
            limitedResult.add(i.currentInt());
        }
        return new ObjectSetFacade(limitedResult);
    }

    @Override
    public QLin<T> limit(int size) {
        if (size < 1) {
            throw new QLinException("Limit must be greater that 0");
        }
        this._limit = size;
        return this;
    }

    @Override
    protected QLinRoot<T> root() {
        return this;
    }

    Query descend(Object expression) {
        return this.query().descend(QLinSupport.field(expression).getName());
    }
}

