/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.config;

import com.db4o.EmbeddedObjectContainer;
import com.db4o.config.CacheConfiguration;
import com.db4o.config.CommonConfiguration;
import com.db4o.config.Configuration;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.config.EmbeddedConfigurationItem;
import com.db4o.config.FileConfiguration;
import com.db4o.config.IdSystemConfiguration;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.config.CacheConfigurationImpl;
import com.db4o.internal.config.Db4oLegacyConfigurationBridge;
import com.db4o.internal.config.FileConfigurationImpl;
import com.db4o.internal.config.IdSystemConfigurationImpl;
import com.db4o.internal.config.LegacyConfigurationProvider;
import java.util.ArrayList;
import java.util.List;

public class EmbeddedConfigurationImpl
implements EmbeddedConfiguration,
LegacyConfigurationProvider {
    private final Config4Impl _legacy;
    private List<EmbeddedConfigurationItem> _configItems;

    public EmbeddedConfigurationImpl(Configuration legacy) {
        this._legacy = (Config4Impl)legacy;
    }

    public CacheConfiguration cache() {
        return new CacheConfigurationImpl(this._legacy);
    }

    public FileConfiguration file() {
        return new FileConfigurationImpl(this._legacy);
    }

    public CommonConfiguration common() {
        return Db4oLegacyConfigurationBridge.asCommonConfiguration(this.legacy());
    }

    public Config4Impl legacy() {
        return this._legacy;
    }

    public void addConfigurationItem(EmbeddedConfigurationItem configItem) {
        if (this._configItems != null && this._configItems.contains(configItem)) {
            return;
        }
        configItem.prepare(this);
        if (this._configItems == null) {
            this._configItems = new ArrayList<EmbeddedConfigurationItem>();
        }
        this._configItems.add(configItem);
    }

    public void applyConfigurationItems(EmbeddedObjectContainer container) {
        if (this._configItems == null) {
            return;
        }
        for (EmbeddedConfigurationItem configItem : this._configItems) {
            configItem.apply(container);
        }
    }

    public IdSystemConfiguration idSystem() {
        return new IdSystemConfigurationImpl(this._legacy);
    }
}

