/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public final class PrimitiveCodec {
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 8;

    public static final int readInt(byte[] buffer, int offset) {
        return buffer[offset += 3] & 0xFF | (buffer[--offset] & 0xFF) << 8 | (buffer[--offset] & 0xFF) << 16 | buffer[--offset] << 24;
    }

    public static final int readInt(ByteArrayInputStream in) {
        return in.read() << 24 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
    }

    public static final void writeInt(byte[] buffer, int offset, int val) {
        buffer[offset += 3] = (byte)val;
        buffer[--offset] = (byte)(val >>= 8);
        buffer[--offset] = (byte)(val >>= 8);
        buffer[--offset] = (byte)(val >> 8);
    }

    public static final void writeInt(ByteArrayOutputStream out, int val) {
        out.write((byte)(val >> 24));
        out.write((byte)(val >> 16));
        out.write((byte)(val >> 8));
        out.write((byte)val);
    }

    public static final void writeLong(byte[] buffer, long val) {
        PrimitiveCodec.writeLong(buffer, 0, val);
    }

    public static final void writeLong(byte[] buffer, int offset, long val) {
        for (int i = 0; i < 8; ++i) {
            buffer[offset++] = (byte)(val >> (7 - i) * 8);
        }
    }

    public static final void writeLong(ByteArrayOutputStream out, long val) {
        for (int i = 0; i < 8; ++i) {
            out.write((byte)(val >> (7 - i) * 8));
        }
    }

    public static final long readLong(byte[] buffer, int offset) {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret = (ret << 8) + (long)(buffer[offset++] & 0xFF);
        }
        return ret;
    }

    public static final long readLong(ByteArrayInputStream in) {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret = (ret << 8) + (long)((byte)in.read() & 0xFF);
        }
        return ret;
    }
}

