/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.PassCommand;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;
import java.io.IOException;

final class SecondPassCommand
implements PassCommand {
    protected final int _objectCommitFrequency;
    protected int _objectCount = 0;

    public SecondPassCommand(int objectCommitFrequency) {
        this._objectCommitFrequency = objectCommitFrequency;
    }

    public void processClass(DefragmentServicesImpl services, final ClassMetadata classMetadata, int id, final int classIndexID) throws CorruptionException, IOException {
        if (services.mappedID(id, -1) == -1) {
            System.err.println("MAPPING NOT FOUND: " + id);
        }
        DefragmentContextImpl.processCopy(services, id, new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl context) {
                classMetadata.defragClass(context, classIndexID);
            }
        });
    }

    public void processObjectSlot(final DefragmentServicesImpl services, ClassMetadata classMetadata, int id) throws CorruptionException, IOException {
        ByteArrayBuffer sourceBuffer = services.sourceBufferByID(id);
        DefragmentContextImpl.processCopy(services, id, new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl context) {
                ClassMetadata.defragObject(context);
                if (SecondPassCommand.this._objectCommitFrequency > 0) {
                    ++SecondPassCommand.this._objectCount;
                    if (SecondPassCommand.this._objectCount == SecondPassCommand.this._objectCommitFrequency) {
                        services.targetCommit();
                        services.mapping().commit();
                        SecondPassCommand.this._objectCount = 0;
                    }
                }
            }
        }, sourceBuffer);
    }

    public void processClassCollection(final DefragmentServicesImpl services) throws CorruptionException, IOException {
        DefragmentContextImpl.processCopy(services, services.sourceClassCollectionID(), new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl context) {
                int acceptedClasses = 0;
                int numClassesOffset = context.targetBuffer().offset();
                acceptedClasses = this.copyAcceptedClasses(context, acceptedClasses);
                this.writeIntAt(context.targetBuffer(), numClassesOffset, acceptedClasses);
            }

            private int copyAcceptedClasses(DefragmentContextImpl context, int acceptedClasses) {
                int numClasses = context.readInt();
                for (int classIdx = 0; classIdx < numClasses; ++classIdx) {
                    int classId = context.sourceBuffer().readInt();
                    if (!this.accept(classId)) continue;
                    ++acceptedClasses;
                    context.writeMappedID(classId);
                }
                return acceptedClasses;
            }

            private void writeIntAt(ByteArrayBuffer target, int offset, int value) {
                int currentOffset = target.offset();
                target.seek(offset);
                target.writeInt(value);
                target.seek(currentOffset);
            }

            private boolean accept(int classId) {
                return services.accept(services.classMetadataForId(classId));
            }
        });
    }

    public void processBTree(DefragmentServicesImpl context, BTree btree) throws CorruptionException, IOException {
        btree.defragBTree(context);
    }

    public void flush(DefragmentServicesImpl context) {
    }
}

