﻿using System;
using System.IO;
using System.Xml;

namespace I2PTalk
{
    public static class Utils
    {
        const int nameMaxLength = 32;

        public static bool IsValidAddress(string s)
        {
            if (s.Length < 10 + 1 + 1 + 52 || s.Length > 10 + nameMaxLength + 1 + 52)
                return false;

            if (!s.StartsWith("i2ptalk://", StringComparison.InvariantCultureIgnoreCase))
                return false;

            int p = s.Length - 53;

            if (s[p] != '/')
                return false;

            string name = s.Substring(10, p - 10);

            if (!IsValidName(name))
                return false;

            return true;
        }

        public static bool IsValidAddress(string s, out string name, out Destination destination)
        {
            name = null;
            destination = null;

            if (s.Length < 10 + 1 + 1 + 52 || s.Length > 10 + nameMaxLength + 1 + 52)
                return false;

            if (!s.StartsWith("i2ptalk://", StringComparison.InvariantCultureIgnoreCase))
                return false;

            int p = s.Length - 53;

            if (s[p] != '/')
                return false;

            name = s.Substring(10, p - 10);

            if (!IsValidName(name))
                return false;

            destination = Destination.FromBase32(s.Substring(p + 1) + ".b32.i2p");

            //for (int i = p + 1; i < s.Length; i++)
            //{
            //    char c = s[i];

            //    if (!(c >= 'A' && c <= 'Z') &&
            //        !(c >= 'a' && c <= 'z') &&
            //        !(c >= '0' && c <= '9') &&
            //        c != '+' && c != '/')
            //        return false;
            //}

            return true;
        }

        public static bool IsValidName(string s)
        {
            if (s.Length < 1 || s.Length > nameMaxLength)
                return false;

            for (int i = 0; i < s.Length; i++)
            {
                char c = s[i];

                if (!(c >= 'A' && c <= 'Z') &&
                    !(c >= 'a' && c <= 'z') &&
                    !(c >= '0' && c <= '9') &&
                    !(c == '-' || c == '_'))
                    return false;
            }

            return true;
        }
    }

    public static class ExtensionMethods
    {
        public static void WriteElementBoolean(this XmlWriter xmlWriter, string localName, bool value)
        {
            xmlWriter.WriteStartElement(localName);
            xmlWriter.WriteValue(value);
            xmlWriter.WriteEndElement();
        }

        public static void WriteElementInt(this XmlWriter xmlWriter, string localName, int value)
        {
            xmlWriter.WriteStartElement(localName);
            xmlWriter.WriteValue(value);
            xmlWriter.WriteEndElement();
        }
    }
}
