﻿using System.Collections.Generic;
using System.Net.Sockets;
using System.Threading.Tasks;

namespace I2PTalk.SamLib
{
    public class StreamSession
    {
        SamClient samClient = new SamClient();

        public string Nickname { get; private set; }
        public string Destination { get; private set; }
        Dictionary<string, string> options;

        public StreamSession(string nickname, string destination = null, Dictionary<string, string> options = null)
        {
            Nickname = nickname;
            Destination = destination;
            this.options = options;

            if (this.options == null)
                this.options = new Dictionary<string, string>(1);

            if (!this.options.ContainsKey("inbound.nickname"))
                this.options.Add("inbound.nickname", Nickname);
        }

        public async Task OpenAsync(string samHost, int samPort)
        {
            await samClient.ConnectAsync(samHost, samPort);

            Destination = await samClient.CreateSessionAsync(SessionStyle.Stream, Nickname, Destination, options);
        }

        public void Close()
        {
            samClient.Disconnect();
        }

        public async Task<TcpClient> ConnectAsync(string destination)
        {
            SamClient samClient2 = new SamClient();

            await samClient2.ConnectAsync(samClient.Host, samClient.Port);

            try
            {
                await samClient2.StreamConnectAsync(Nickname, destination);
            }
            catch (SamException)
            {
                samClient2.Disconnect();
                throw;
            }

            return samClient2.TcpClient;
        }

        public async Task<AcceptedStream> AcceptAsync()
        {
            SamClient samClient2 = new SamClient();

            await samClient2.ConnectAsync(samClient.Host, samClient.Port);

            try
            {
                await samClient2.StreamAcceptAsync(Nickname);
            }
            catch (SamException)
            {
                samClient2.Disconnect();
                throw;
            }

            string clientDestination = await samClient2.ReceiveLineAsync();

            return new AcceptedStream(clientDestination, samClient2.TcpClient);
        }

        public bool Alive
        {
            get
            {
                return samClient.Connected;
            }
        }
    }

    public class AcceptedStream
    {
        public string ClientDestination { get; private set; }
        public TcpClient TcpClient { get; private set; }

        internal AcceptedStream(string clientDestination, TcpClient tcpClient)
        {
            ClientDestination = clientDestination;
            TcpClient = tcpClient;
        }
    }
}
