﻿using I2PTalk.Properties;
using System;
using System.Drawing;
using System.Windows.Forms;
using System.Xml;

namespace I2PTalk.Forms
{
    public partial class NewIdentityForm : Form
    {
        bool firstStart;

        public Identity Identity { get; private set; }

        public NewIdentityForm(bool firstStart)
        {
            InitializeComponent();

            this.firstStart = firstStart;

            buttonImport.Visible = firstStart;
        }

        private void buttonImport_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();

            openFileDialog.Tag = "Import identity";
            openFileDialog.FileName = "identity.xml";
            openFileDialog.Filter = "I2PTalk identity files (*.xml)|*.xml";

            if (openFileDialog.ShowDialog() != DialogResult.OK)
                return;

            XmlDocument xmlDocument = new XmlDocument();

            xmlDocument.Load(openFileDialog.FileName);

            Identity = Identity.FromXml(xmlDocument["Identity"]);
            textBoxName.Text = Identity.Name;
            textBoxProfile.Text = Identity.Profile;

            MessageBox.Show("Identity successfully imported.", "Notice", MessageBoxButtons.OK, MessageBoxIcon.Information);

            DialogResult = DialogResult.OK;
        } 

        private void buttonOK_Click(object sender, EventArgs e)
        {
            if (!Utils.IsValidName(textBoxName.Text))
            {
                MessageBox.Show("The contact name you have entered is invalid. Valid names have a maximum length of 32 characters and may only contain: A-Z, a-z, 0-9, -, _", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            Identity = Identity.CreateNew(textBoxName.Text, textBoxProfile.ForeColor == SystemColors.ControlText ? textBoxProfile.Text.Trim() : string.Empty);

            DialogResult = DialogResult.OK;
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            if (firstStart)
                if (MessageBox.Show("Before you can use I2PTalk you must create or import an identity. Cancelling this step will close I2PTalk.", "Notice", MessageBoxButtons.OKCancel, MessageBoxIcon.Information) != DialogResult.OK)
                    return;

            DialogResult = DialogResult.Cancel;
        }

        private void textBoxName_TextChanged(object sender, EventArgs e)
        {
            if (Utils.IsValidName(textBoxName.Text))
                pictureBoxName.Image = Resources.tick;
            else
                pictureBoxName.Image = Resources.cross;
        }

        private void textBoxProfile_Enter(object sender, EventArgs e)
        {
            if (textBoxProfile.ForeColor == SystemColors.ControlDark)
            {
                textBoxProfile.Clear();
                textBoxProfile.ForeColor = SystemColors.ControlText;
            }
        }

        private void textBoxProfile_Leave(object sender, EventArgs e)
        {
            if (textBoxProfile.Text.Trim() == string.Empty)
            {
                textBoxProfile.Text = "In your profile you can tell your contacts some optional details about yourself (e.g. your age/gender/interests, your eepsite, your i2p mail address, etc...). Do not reveal any information that could be used to identify you!";
                textBoxProfile.ForeColor = SystemColors.ControlDark;
            }
        }             
    }
}
