﻿using I2PTalk.Properties;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace I2PTalk.Forms
{
    public partial class ContactDetailsForm : Form
    {
        Contact contact;

        public ContactDetailsForm(Contact contact)
        {
            InitializeComponent();

            this.contact = contact;

            textBoxName.Text = contact.DisplayName;
            textBoxAddress.Text = contact.GetI2PTalkAddress();
            textBoxProfile.Text = contact.Profile;
        }

        private void textBoxName_TextChanged(object sender, EventArgs e)
        {
            pictureBoxName.Image = Utils.IsValidName(textBoxName.Text) ? Resources.tick : Resources.cross;
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            if (textBoxName.Text == contact.DisplayName)
            {
                DialogResult = DialogResult.Cancel;
                return;
            }

            if (!Utils.IsValidName(textBoxName.Text))
            {
                MessageBox.Show("The contact name you have entered is invalid. Valid names have a maximum length of 32 characters and may only contain: A-Z, a-z, 0-9, -, _", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (Core.Instance.Identity.Contacts.Any(c => c.DisplayName == textBoxName.Text))
            {
                MessageBox.Show("A contact with this name already exists in your contact list.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (Core.Instance.Identity.AuthorizationRequests.Any(ar => ar.ContactName == textBoxName.Text))
            {
                MessageBox.Show("A contact with this name is currently waiting for your authorization.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            contact.DisplayName = textBoxName.Text;

            DialogResult = DialogResult.OK;
        }
    }
}
