﻿using I2PTalk.ChatBox;
using System;
using System.Windows.Forms;

namespace I2PTalk.Forms
{
    public partial class ChatForm : Form
    {
        Core core;
        Contact contact;

        public bool HasUnreadMessages { get; set; }

        public ChatForm(Core core, Contact contact)
        {
            InitializeComponent();

            this.core = core;
            this.contact = contact;

            Text = string.Format("I2PTalk - {0}", contact.DisplayName);

            UpdateContactOffline();
        }

        private delegate void InvokeShowDelegate();

        public void InvokeShow()
        {
            if (InvokeRequired)
            {
                Invoke(new InvokeShowDelegate(InvokeShow));
                return;
            }

            Show();
        }

        private delegate void AddReceivedMessageDelegate(string message);

        public void AddReceivedMessage(string message)
        {
            if (InvokeRequired)
            {
                Invoke(new AddReceivedMessageDelegate(AddReceivedMessage), message);
                return;
            }

            AddMessage(contact.DisplayName, message);
        }

        private void AddMessage(string contact, string message)
        {
            foreach (string line in message.Trim().Split(new string[] { "\r\n", "\r", "\n" }, StringSplitOptions.None))
            {
                chatBox.Items.Add(new MessageChatBoxItem(DateTimeOffset.Now, contact, line));
            }

            chatBox.ScrollToCaret();
        }

        private delegate void ShowLatencyDelegate(TimeSpan latency);

        public void ShowLatency(TimeSpan latency)
        {
            if (InvokeRequired)
            {
                Invoke(new ShowLatencyDelegate(ShowLatency), latency);
                return;
            }

            toolStripStatusLabelLatency.Text = string.Format("Latency: {0} ms", (int)latency.TotalMilliseconds);
        }

        public void UpdateContactOffline()
        {
            labelContactOffline.Visible = contact.Status == ContactStatus.Offline;
        }

        private void ChatForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            Hide();
        }

        private async void textBoxChatInput_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter && !e.Control)
            {
                string text = textBoxChatInput.Text.Trim();

                if (text != string.Empty)
                {
                    await core.SendChatMessage(contact, text);

                    AddMessage(core.Identity.Name, text);          
                }

                textBoxChatInput.Clear();
                e.SuppressKeyPress = true;
            }
        }

        private void toolStripButtonDeleteAndBlockContact_Click(object sender, EventArgs e)
        {
            core.DeleteAndBlockContact(contact);
        }

        private void toolStripButtonSettings_Click(object sender, EventArgs e)
        {
            SettingsForm settingsForm = new SettingsForm(core);

            settingsForm.ShowDialog();
        }
    }
}
