﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace I2PTalk.Forms
{
    public partial class BlockedContactsForm : Form
    {
        List<BlocklistEntry> blocklist;

        public BlockedContactsForm(List<BlocklistEntry> blocklist)
        {
            InitializeComponent();

            this.blocklist = blocklist;

            foreach (BlocklistEntry blocklistEntry in blocklist)
            {
                ListViewItem listViewItem = new ListViewItem();

                listViewItem.Text = blocklistEntry.ContactDisplayName;
                listViewItem.SubItems.Add(blocklistEntry.GetI2PTalkAddress());
                listViewItem.Tag = blocklistEntry;

                listViewBlockedContacts.Items.Add(listViewItem);
            }
        }

        private void buttonUnblock_Click(object sender, EventArgs e)
        {
            while (listViewBlockedContacts.SelectedIndices.Count > 0)
            {
                ListViewItem selectedItem = listViewBlockedContacts.SelectedItems[0];
                blocklist.Remove((BlocklistEntry)selectedItem.Tag);
                listViewBlockedContacts.Items.Remove(selectedItem);
            }
        }

        private void listViewBlockedContacts_SelectedIndexChanged(object sender, EventArgs e)
        {
            buttonUnblock.Enabled = listViewBlockedContacts.SelectedItems.Count > 0;
        }
    }
}
