﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace I2PTalk
{
    public class Destination
    {
        public string Base64 { get; private set; }

        string base32;

        public string Base32
        {
            get
            {
                if (base32 == null)
                    base32 = Base64ToBase32(Base64);

                return base32;
            }
        }

        private Destination()
        {
        }

        public static Destination FromBase64(string destination)
        {
            return new Destination() { Base64 = destination };
        }

        public static Destination FromBase32(string destination)
        {
            return new Destination() { base32 = destination };
        }

        public static Destination Parse(string destination)
        {
            if (destination.Length == 516)
                return Destination.FromBase64(destination);
            else
                return Destination.FromBase32(destination);
        }

        private string Base64ToBase32(string destination)
        {
            byte[] d = Convert.FromBase64String(destination.Replace('-', '+').Replace('~', '/'));

            using (SHA256 sha256 = SHA256.Create())
                return ToBase32String(sha256.ComputeHash(d)).TrimEnd('=').ToLowerInvariant() + ".b32.i2p";
        }

        private string ToBase32String(byte[] input)
        {
            int charCount = (input.Length + 4) / 5 * 8;
            char[] base32 = new char[charCount];

            byte nextChar = 0;
            int bitsRemaining = 5;
            int i = 0;

            foreach (byte b in input)
            {
                nextChar = (byte)(nextChar | (b >> (8 - bitsRemaining)));
                base32[i++] = ValueToChar(nextChar);

                if (bitsRemaining < 4)
                {
                    nextChar = (byte)((b >> (3 - bitsRemaining)) & 31);
                    base32[i++] = ValueToChar(nextChar);
                    bitsRemaining += 5;
                }

                bitsRemaining -= 3;
                nextChar = (byte)((b << bitsRemaining) & 31);
            }

            if (i != charCount)
            {
                base32[i++] = ValueToChar(nextChar);
                while (i != charCount)
                    base32[i++] = '=';
            }

            return new string(base32);
        }

        private char ValueToChar(byte b)
        {
            if (b < 26)
                return (char)(b + 65);
            else if (b < 32)
                return (char)(b + 24);
            else
                throw new ArgumentException("Byte is not a valid Base32 value.", "b");
        }

        public override bool Equals(object obj)
        {
            Destination other = obj as Destination;

            if (other == null)
                return false;

            if (Base64 != null && other.Base64 != null)
                return Base64 == other.Base64;
            else
                return Base32 == other.Base32;
        }

        public override int GetHashCode()
        {
            return Base32.GetHashCode();
        }

        public override string ToString()
        {
            return Base64 ?? Base32;
        }
    }
}
