﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace I2PTalk.ChatBox
{
    public class ChatBoxItemCollection : Collection<ChatBoxItem>
    {
        ChatBox chatBox;

        internal ChatBoxItemCollection(ChatBox chatBox)
        {
            this.chatBox = chatBox;
        }

        protected override void InsertItem(int index, ChatBoxItem item)
        {
            chatBox.InsertItem(index, item);
            base.InsertItem(index, item);
        }

        protected override void SetItem(int index, ChatBoxItem item)
        {
            chatBox.SetItem(index, item);
            base.SetItem(index, item);
        }

        protected override void RemoveItem(int index)
        {
            chatBox.RemoveItem(index);
            base.RemoveItem(index);
        }

        protected override void ClearItems()
        {
            chatBox.ClearItems();
            base.ClearItems();
        }
    }
}
