﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Collections.ObjectModel;

namespace I2PTalk.ChatBox
{
    public partial class ChatBox : UserControl
    {
        public ChatBoxItemCollection Items { get; private set; }

        Dictionary<Span, ChatBoxItem> hyperlinks = new Dictionary<Span, ChatBoxItem>();
        Span linkHovered;

        public ChatBox() 
        {
            InitializeComponent();

            Items = new ChatBoxItemCollection(this);
        }

        internal void InsertItem(int index, ChatBoxItem item)
        {
            if (index == Items.Count)
            {
                item.TextPosition = richTextBox.Text.Length;
                richTextBox.AppendText(item.GetText());                
                item.Format(richTextBox);

                foreach (Span span in item.GetHyperlinks())
                    hyperlinks.Add(span, item);
            }
            else
                throw new NotSupportedException();
        }

        internal void SetItem(int index, ChatBoxItem item)
        {
            int lengthChange = item.GetText().Length - Items[index].GetText().Length;

            item.TextPosition = Items[index].TextPosition;         

            richTextBox.Select(Items[index].TextPosition, Items[index].GetText().Length);
            richTextBox.SelectedText = item.GetText();
            item.Format(richTextBox);

            for (int i = index + 1; i < Items.Count; i++)
                Items[i].TextPosition += lengthChange;
        }

        internal void RemoveItem(int index)
        {
            int lengthChange = -Items[index].GetText().Length;

            richTextBox.Select(Items[index].TextPosition, Items[index].GetText().Length);
            richTextBox.SelectedText = string.Empty;

            for (int i = index + 1; i < Items.Count; i++)
                Items[i].TextPosition += lengthChange;
        }

        internal void ClearItems()
        {
            richTextBox.Clear();
        }

        private void richTextBox_MouseMove(object sender, MouseEventArgs e)
        {
            int charIndex = richTextBox.GetCharIndexFromPosition(e.Location);

            linkHovered = hyperlinks.FirstOrDefault(kvp =>
                kvp.Value.TextPosition + kvp.Key.Start <= charIndex && kvp.Value.TextPosition + kvp.Key.Start + kvp.Key.Length > charIndex).Key;

            if (linkHovered != null)
            {
                if (richTextBox.Cursor != Cursors.Hand)
                    richTextBox.Cursor = Cursors.Hand;
            }
            else
                if (richTextBox.Cursor != Cursors.IBeam)
                    richTextBox.Cursor = Cursors.IBeam;
        }

        private void richTextBox_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button.HasFlag(MouseButtons.Left) && linkHovered != null)
                hyperlinks[linkHovered].OnLinkClicked(linkHovered);
        }

        public void ScrollToCaret()
        {
            richTextBox.ScrollToCaret();
        }
    }
}
