﻿using System.IO;
using System.Xml;

namespace I2PTalk
{
    public static class ExtensionMethods
    {
        public static void WriteElementBoolean(this XmlWriter xmlWriter, string localName, bool value)
        {
            xmlWriter.WriteStartElement(localName);
            xmlWriter.WriteValue(value);
            xmlWriter.WriteEndElement();
        }

        public static void WriteElementInt(this XmlWriter xmlWriter, string localName, int value)
        {
            xmlWriter.WriteStartElement(localName);
            xmlWriter.WriteValue(value);
            xmlWriter.WriteEndElement();
        }
    }

    public static class Utils
    {
        public static bool IsValidAddress(string s)
        {
            if (s.Length < 8 + 1 + 1 + 516 || s.Length > 8 + 32 + 1 + 516)
                return false;

            if (!s.StartsWith("i2ptalk:"))
                return false;

            int p = s.Length - 517;

            if (s[p] != ':')
                return false;

            string name = s.Substring(8, p - 8);

            if (!IsValidName(name))
                return false;

            return true;
        }

        public static bool IsValidAddress(string s, out string name, out string destination)
        {
            name = null;
            destination = null;

            if (s.Length < 8 + 1 + 1 + 516 || s.Length > 8 + 32 + 1 + 516)
                return false;

            if (!s.StartsWith("i2ptalk:"))
                return false;

            int p = s.Length - 517;

            if (s[p] != ':')
                return false;

            name = s.Substring(8, p - 8);

            if (!IsValidName(name))
                return false;

            destination = s.Substring(p + 1);

            //for (int i = p + 1; i < s.Length; i++)
            //{
            //    char c = s[i];

            //    if (!(c >= 'A' && c <= 'Z') &&
            //        !(c >= 'a' && c <= 'z') &&
            //        !(c >= '0' && c <= '9') &&
            //        c != '+' && c != '/')
            //        return false;
            //}

            return true;
        }

        public static bool IsValidName(string s)
        {
            if (s.Length < 1 || s.Length > 32)
                return false;

            for (int i = 0; i < s.Length; i++)
            {
                char c = s[i];

                if (!(c >= 'A' && c <= 'Z') &&
                    !(c >= 'a' && c <= 'z') &&
                    !(c >= '0' && c <= '9') &&
                    !(c == '-' || c == '_'))
                    return false;
            }

            return true;
        }
    }
}
