﻿using System;
using System.Windows.Forms;

namespace I2PTalk
{
    public partial class SettingsForm : Form
    {
        Core core;

        public SettingsForm(Core core)
        {
            InitializeComponent();

            this.core = core;

            checkBoxConnectAtStartup.Checked = core.Settings.ConnectAtStartup;
            switch (core.Settings.AuthorizationPolicy)
            {
                case AuthorizationPolicy.AcceptAll:
                    radioButtonAcceptAll.Checked = true;
                    break;
                case AuthorizationPolicy.Ask:
                    radioButtonAsk.Checked = true;
                    break;
                case AuthorizationPolicy.BlockAll:
                    radioButtonBlockAll.Checked = true;
                    break;
            }
            numericUpDownInterval.Value = (int)core.Settings.StatusUpdateInterval.TotalSeconds;
            numericUpDownTimeout.Value = (int)core.Settings.StatusUpdateTimeout.TotalSeconds;

            checkBoxSaveWindowLocation.Checked = core.Settings.SaveWindowLocation;
            checkBoxShowTimeStamps.Checked = core.Settings.ShowTimeStamps;
            switch (core.Settings.IncomingChatMessageAction)
            {
                case IncomingChatMessageAction.BlinkTrayIcon:
                    radioButtonBlinkTrayIcon.Checked = true;
                    break;
                case IncomingChatMessageAction.ShowBalloon:
                    radioButtonShowBalloon.Checked = true;
                    break;
                case IncomingChatMessageAction.ShowChatWindow:
                    radioButtonShowChatWindow.Checked = true;
                    break;
            }

            textBoxSamHost.Text = core.Settings.SamHost;
            textBoxSamPort.Text = Convert.ToString(core.Settings.SamPort);
            comboBoxInboundLength.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["inbound.length"]);
            comboBoxOutboundLength.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["outbound.length"]);
            if (Convert.ToInt32(core.Settings.SamOptions["inbound.lengthVariance"]) != -1)
                comboBoxInboundLengthVariance.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["inbound.lengthVariance"]);
            else
                comboBoxInboundLengthVariance.SelectedIndex = 3;
            if (Convert.ToInt32(core.Settings.SamOptions["outbound.lengthVariance"]) != -1)
                comboBoxOutboundLengthVariance.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["outbound.lengthVariance"]);
            else
                comboBoxOutboundLengthVariance.SelectedIndex = 3;
            comboBoxInboundQuantity.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["inbound.quantity"]) - 1;
            comboBoxOutboundQuantity.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["outbound.quantity"]) - 1;
            comboBoxInboundBackupQuantity.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["inbound.backupQuantity"]);
            comboBoxOutboundBackupQuantity.SelectedIndex = Convert.ToInt32(core.Settings.SamOptions["outbound.backupQuantity"]);
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            core.Settings.ConnectAtStartup = checkBoxConnectAtStartup.Checked;
            if (radioButtonAcceptAll.Checked)
                core.Settings.AuthorizationPolicy = AuthorizationPolicy.AcceptAll;
            if (radioButtonAsk.Checked)
                core.Settings.AuthorizationPolicy = AuthorizationPolicy.Ask;
            if (radioButtonBlockAll.Checked)
                core.Settings.AuthorizationPolicy = AuthorizationPolicy.BlockAll;
            core.Settings.StatusUpdateInterval = TimeSpan.FromSeconds((int)numericUpDownInterval.Value);
            core.Settings.StatusUpdateTimeout = TimeSpan.FromSeconds((int)numericUpDownTimeout.Value);

            core.Settings.SaveWindowLocation = checkBoxSaveWindowLocation.Checked;
            core.Settings.ShowTimeStamps = checkBoxShowTimeStamps.Checked;
            if (radioButtonBlinkTrayIcon.Checked)
                core.Settings.IncomingChatMessageAction = IncomingChatMessageAction.BlinkTrayIcon;
            if (radioButtonShowBalloon.Checked)
                core.Settings.IncomingChatMessageAction = IncomingChatMessageAction.ShowBalloon;
            if (radioButtonShowChatWindow.Checked)
                core.Settings.IncomingChatMessageAction = IncomingChatMessageAction.ShowChatWindow;

            core.Settings.SamHost = textBoxSamHost.Text;
            core.Settings.SamPort = Convert.ToInt32(textBoxSamPort.Text);
            core.Settings.SamOptions["inbound.length"] = Convert.ToString(comboBoxInboundLength.SelectedIndex);
            core.Settings.SamOptions["outbound.length"] = Convert.ToString(comboBoxOutboundLength.SelectedIndex);
            if (comboBoxInboundLengthVariance.SelectedIndex != 3)
                core.Settings.SamOptions["inbound.lengthVariance"] = Convert.ToString(comboBoxInboundLengthVariance.SelectedIndex);
            else
                core.Settings.SamOptions["inbound.lengthVariance"] = "-1";
            if (comboBoxOutboundLengthVariance.SelectedIndex != 3)
                core.Settings.SamOptions["outbound.lengthVariance"] = Convert.ToString(comboBoxOutboundLengthVariance.SelectedIndex);
            else
                core.Settings.SamOptions["outbound.lengthVariance"] = "-1";
            core.Settings.SamOptions["inbound.quantity"] = Convert.ToString(comboBoxInboundQuantity.SelectedIndex + 1);
            core.Settings.SamOptions["outbound.quantity"] = Convert.ToString(comboBoxOutboundQuantity.SelectedIndex + 1);
            core.Settings.SamOptions["inbound.backupQuantity"] = Convert.ToString(comboBoxInboundBackupQuantity.SelectedIndex);
            core.Settings.SamOptions["outbound.backupQuantity"] = Convert.ToString(comboBoxOutboundBackupQuantity.SelectedIndex);

            DialogResult = DialogResult.OK;
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        private void buttonSetToDefault_Click(object sender, EventArgs e)
        {
            comboBoxInboundLength.SelectedIndex = 3;
            comboBoxOutboundLength.SelectedIndex = 3;
            comboBoxInboundLengthVariance.SelectedIndex = 0;
            comboBoxOutboundLengthVariance.SelectedIndex = 0;
            comboBoxInboundQuantity.SelectedIndex = 1;
            comboBoxOutboundQuantity.SelectedIndex = 1;
            comboBoxInboundBackupQuantity.SelectedIndex = 0;
            comboBoxOutboundBackupQuantity.SelectedIndex = 0;
        }
    }
}
