﻿using I2PTalk.Properties;
using System.Linq;
using System.Windows.Forms;

namespace I2PTalk
{
    public partial class RenameContactForm : Form
    {
        Core core;

        public string ContactName { get; private set; }

        public RenameContactForm(Core core, string contactName)
        {
            InitializeComponent();

            this.core = core;
            textBoxName.Text = contactName;
            ContactName = contactName;
        }

        private void buttonOK_Click(object sender, System.EventArgs e)
        {
            if (textBoxName.Text == ContactName)
            {
                DialogResult = DialogResult.Cancel;
                return;
            }

            if (!Utils.IsValidName(textBoxName.Text))
            {
                MessageBox.Show("The contact name you have entered is invalid. Valid names have a maximum length of 32 characters and may only contain: A-Z, a-z, 0-9, -, _", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (core.Identity.Contacts.Any(c => c.DisplayName == textBoxName.Text))
            {
                MessageBox.Show("A contact with this name already exists in your contact list.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (core.Identity.AuthorizationRequests.Any(ar => ar.ContactName == textBoxName.Text))
            {
                MessageBox.Show("A contact with this name is currently waiting for your authorization.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            ContactName = textBoxName.Text;

            DialogResult = DialogResult.OK;
        }

        private void buttonCancel_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        private void textBoxName_TextChanged(object sender, System.EventArgs e)
        {
            if (Utils.IsValidName(textBoxName.Text))
                pictureBoxName.Image = Resources.tick;                
            else
                pictureBoxName.Image = Resources.cross;
        }
    }
}
