﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Xml;

namespace I2PTalk
{
    public partial class MyIdentityForm : Form
    {
        public bool IdentityChanged { get; private set; }
        public Identity Identity { get; private set; }

        public MyIdentityForm(Identity identity)
        {
            InitializeComponent();

            IdentityChanged = false;
            this.Identity = identity;

            textBoxName.Text = identity.Name;
            textBoxAddress.Text = identity.GetI2PTalkAddress();

            if (identity.Profile != string.Empty)
            {
                textBoxProfile.Text = identity.Profile;
                textBoxProfile.ForeColor = SystemColors.ControlText;
            }
        }

        private void buttonBlockedContacts_Click(object sender, EventArgs e)
        {
            new BlockedContactsForm(Identity.Blocklist).ShowDialog();
        }   

        private void buttonOK_Click(object sender, EventArgs e)
        {
            Identity.Profile = textBoxProfile.ForeColor == SystemColors.ControlText ? textBoxProfile.Text.Trim() : string.Empty;

            DialogResult = DialogResult.OK;
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        } 

        private void buttonImport_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();

            openFileDialog.Tag = "Import identity";
            openFileDialog.FileName = "identity.xml";
            openFileDialog.Filter = "I2PTalk identity files (*.xml)|*.xml";

            if (openFileDialog.ShowDialog() != DialogResult.OK)
                return;

            XmlReader xmlReader = XmlReader.Create(openFileDialog.FileName);
            Identity = Identity.FromXml(xmlReader);
            textBoxName.Text = Identity.Name;
            textBoxAddress.Text = Identity.GetI2PTalkAddress();
            textBoxProfile.Text = Identity.Profile;
            xmlReader.Close();

            IdentityChanged = true;

            MessageBox.Show("Identity successfully imported.", "Notice", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void buttonExport_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog = new SaveFileDialog();

            saveFileDialog.Title = "Export identity";
            saveFileDialog.FileName = "identity.xml";
            saveFileDialog.Filter = "I2PTalk identity files (*.xml)|*.xml";

            if (saveFileDialog.ShowDialog() != DialogResult.OK)
                return;

            XmlWriter xmlWriter = XmlWriter.Create(saveFileDialog.FileName);
            xmlWriter.WriteStartDocument();
            Identity.WriteToXml(xmlWriter);
            xmlWriter.WriteEndDocument();
            xmlWriter.Close();

            MessageBox.Show("Identity successfully exported.", "Notice", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void buttonNew_Click(object sender, EventArgs e)
        {          
            NewIdentityForm newIdentityForm = new NewIdentityForm(false);

            if (newIdentityForm.ShowDialog() != DialogResult.OK)
                return;

            Identity = newIdentityForm.Identity;
            textBoxName.Text = Identity.Name;
            textBoxAddress.Text = Identity.GetI2PTalkAddress();
            textBoxProfile.Text = Identity.Profile;

            if (Identity.Profile != string.Empty)
            {
                textBoxProfile.Text = Identity.Profile;
                textBoxProfile.ForeColor = SystemColors.ControlText;
            }
            else
            {
                textBoxProfile.Text = "In your profile you can tell your contacts some optional details about yourself (e.g. your age/gender/interests, your eepsite, your i2p mail address, etc...). Do not reveal any information that could be used to identify you!";
                textBoxProfile.ForeColor = SystemColors.ControlDark;
            }

            IdentityChanged = true;
        }

        private void textBoxProfile_Enter(object sender, EventArgs e)
        {
            if (textBoxProfile.ForeColor == SystemColors.ControlDark)
            {
                textBoxProfile.Clear();
                textBoxProfile.ForeColor = SystemColors.ControlText;
            }
        }

        private void textBoxProfile_Leave(object sender, EventArgs e)
        {
            if (textBoxProfile.Text.Trim() == string.Empty)
            {
                textBoxProfile.Text = "In your profile you can tell your contacts some optional details about yourself (e.g. your age/gender/interests, your eepsite, your i2p mail address, etc...). Do not reveal any information that could be used to identify you!";
                textBoxProfile.ForeColor = SystemColors.ControlDark;
            }
        }
    }
}
