﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace I2PTalk
{
    public partial class BlockedContactsForm : Form
    {
        List<BlocklistEntry> blocklist;

        public BlockedContactsForm(List<BlocklistEntry> blocklist)
        {
            InitializeComponent();

            this.blocklist = blocklist;

            foreach (BlocklistEntry blocklistEntry in blocklist)
            {
                ListViewItem listViewItem = new ListViewItem();
                if (blocklistEntry.ContactName == blocklistEntry.ContactDisplayName)
                    listViewItem.Text = blocklistEntry.ContactDisplayName;
                else
                    listViewItem.Text = string.Format("{0} ({1})", blocklistEntry.ContactDisplayName, blocklistEntry.ContactName);
                listViewItem.SubItems.Add(blocklistEntry.ContactDestination);
                listViewItem.Tag = blocklistEntry;
                listViewBlockedContacts.Items.Add(listViewItem);
            }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        private void buttonUnblock_Click(object sender, EventArgs e)
        {
            while (listViewBlockedContacts.SelectedIndices.Count > 0)
            {
                ListViewItem selectedItem = listViewBlockedContacts.SelectedItems[0];
                blocklist.Remove((BlocklistEntry)selectedItem.Tag);
                listViewBlockedContacts.Items.Remove(selectedItem);
            }
        }

        private void listViewBlockedContacts_SelectedIndexChanged(object sender, EventArgs e)
        {
            buttonUnblock.Enabled = listViewBlockedContacts.SelectedItems.Count > 0;
        }
    }
}
