﻿using System;
using System.Windows.Forms;

namespace I2PTalk
{
    public partial class AuthorizationRequestsForm : Form
    {
        Identity identity;

        public AuthorizationRequestsForm(Identity identity)
        {
            InitializeComponent();

            this.identity = identity;

            foreach (AuthorizationRequest request in identity.AuthorizationRequests)
            {
                ListViewItem listViewItem = new ListViewItem();
                listViewItem.Text = request.ContactName;
                listViewItem.SubItems.Add(request.ContactDestination);
                listViewItem.Tag = request;
                listViewAuthorizationRequests.Items.Add(listViewItem);
            }
        }

        private void listViewAuthorizationRequests_SelectedIndexChanged(object sender, EventArgs e)
        {
            buttonAccept.Enabled = listViewAuthorizationRequests.SelectedItems.Count > 0;
            buttonBlock.Enabled = buttonAccept.Enabled;

            if (listViewAuthorizationRequests.SelectedItems.Count == 0)
                textBoxAuthorizationMessage.Clear();
            else
                textBoxAuthorizationMessage.Text = ((AuthorizationRequest)listViewAuthorizationRequests.SelectedItems[0].Tag).Message;
        }

        private void buttonAccept_Click(object sender, EventArgs e)
        {
            AuthorizationRequest request = (AuthorizationRequest)listViewAuthorizationRequests.SelectedItems[0].Tag;

            identity.Contacts.Add(Contact.CreateNew(request.ContactName, request.ContactName, request.ContactDestination, null, false));
            identity.AuthorizationRequests.Remove(request);
            listViewAuthorizationRequests.SelectedItems[0].Remove();
        }

        private void buttonBlock_Click(object sender, EventArgs e)
        {
            AuthorizationRequest request = (AuthorizationRequest)listViewAuthorizationRequests.SelectedItems[0].Tag;

            identity.Blocklist.Add(new BlocklistEntry(request.ContactName, request.ContactName, request.ContactDestination));
            identity.AuthorizationRequests.Remove(request);
            listViewAuthorizationRequests.SelectedItems[0].Remove();
        }
    }
}
