﻿using I2PTalk.Properties;
using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

namespace I2PTalk
{
    public partial class AddContactForm : Form
    {
        Core core;

        public string ContactName { get; private set; }
        public string ContactDisplayName { get; private set; }
        public string ContactDestination { get; private set; }
        public string AuthorizationMessage { get; private set; }

        public AddContactForm(Core core)
        {
            InitializeComponent();

            this.core = core;
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            if (!Utils.IsValidAddress(textBoxAddress.Text))               
            {
                MessageBox.Show("The I2PTalk address you have entered is invalid. Make sure you have copied the complete address.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!Utils.IsValidName(textBoxName.Text))  
            {
                MessageBox.Show("The contact name you have entered is invalid. Valid names have a maximum length of 32 characters and may only contain: A-Z, a-z, 0-9, -, _", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (core.Identity.Contacts.Any(c => c.Destination == ContactDestination))
            {
                MessageBox.Show("This contact is already in your contact list.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (core.Identity.Contacts.Any(c => c.DisplayName == ContactDisplayName))
            {
                MessageBox.Show("A contact with this name already exists in your contact list.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (core.Identity.AuthorizationRequests.Any(ar => ar.ContactDestination == ContactDestination))
            {
                MessageBox.Show("This contact is currently waiting for your authorization. Accept the authorization request to add it to your contact list.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (core.Identity.AuthorizationRequests.Any(ar => ar.ContactName == ContactDisplayName))
            {
                MessageBox.Show("A contact with this name is currently waiting for your authorization.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            AuthorizationMessage = textBoxAuthorizationMessage.ForeColor == SystemColors.ControlText ? textBoxAuthorizationMessage.Text.Trim() : null;

            DialogResult = DialogResult.OK;
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        private void buttonPaste_Click(object sender, EventArgs e)
        {
            textBoxAddress.Text = Clipboard.GetText();
        }

        private void textBoxAddress_TextChanged(object sender, EventArgs e)
        {
            string name;
            string destination;

            if (Utils.IsValidAddress(textBoxAddress.Text, out name, out destination))
            {
                pictureBoxAddress.Image = Resources.tick;
                textBoxName.Text = name;
                ContactName = name;
                ContactDestination = destination;
            }
            else
                pictureBoxAddress.Image = Resources.cross;  
        }

        private void textBoxName_TextChanged(object sender, EventArgs e)
        {
            if (Utils.IsValidName(textBoxName.Text))
            {
                pictureBoxName.Image = Resources.tick;
                ContactDisplayName = textBoxName.Text;
            }
            else
                pictureBoxName.Image = Resources.cross;
        }

        private void textBoxAuthorizationMessage_Enter(object sender, EventArgs e)
        {
            if (textBoxAuthorizationMessage.ForeColor == SystemColors.ControlDark)
            {
                textBoxAuthorizationMessage.Clear();
                textBoxAuthorizationMessage.ForeColor = SystemColors.ControlText;
            }
        }

        private void textBoxAuthorizationMessage_Leave(object sender, EventArgs e)
        {
            if (textBoxAuthorizationMessage.Text.Trim() == string.Empty)
            {
                textBoxAuthorizationMessage.Text = "You can enter a message where you explain who you are and why you want to add this contact. It will be shown to your contact when he/she receives the authorization request.";
                textBoxAuthorizationMessage.ForeColor = SystemColors.ControlDark;
            }
        }  
    }
}
