package org.klomp.snarkxl;

import java.io.*; //workaround dataloss
//import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Manage multiple snarks
 */
public class SnarkManager implements Snark.CompleteListener {
    private static SnarkManager _instance = new SnarkManager();
    public static SnarkManager instance() { return _instance; }
    private boolean xlServletInit = false;
    private String nickname = "UNSET";
    /** map of (canonical) filename to Snark instance (unsynchronized) */
    private Map _snarks;
    private Object _addSnarkLock;
    private String _configFile;
    private Properties _config;
    private String _configFile_swarm;
    private Properties _config_swarm;
    private I2PAppContext _context;
    private Log _log;
    private List _messages;
    private static final String versionXL = "20101114a";//fwd
    
    public static final String PROP_ID = "i2psnark.id";
    public static final int DEFAULT_ID = 1;
    public static final String PROP_DATA_CHECK = "check.incomplete.only";//fwd (pidfile found)
    public static final String PROP_I2CP_HOST = "i2psnark.i2cpHost";
    public static final String PROP_I2CP_PORT = "i2psnark.i2cpPort";
    public static final String PROP_I2CP_OPTS = "i2psnark.i2cpOptions";
    public static final String PROP_EEP_HOST = "i2psnark.eepHost";
    public static final String PROP_EEP_PORT = "i2psnark.eepPort";
    public static final String PROP_UPLOADERS_TOTAL = "i2psnark.uploaders.total";
    public static final String PROP_UPBW_MAX = "i2psnark.upbw.max";
    public static final String PROP_DIR = "i2psnark.dir";
    public static final String PROP_META_PREFIX = "i2psnark.zmeta.";
    
    public static final String PROP_META_BITFIELD_SUFFIX = ".bitfield";
    public static final String PROP_UMETA_PREFIX = "i2psnark.umeta.";
    //public static final String PROP_UMETA_UPLOAD_SUFFIX = ".uploaded";
    public static final String PROP_DMETA_PREFIX = "i2psnark.dmeta.";
    public static final String PROP_UDMETA_PREFIX = "i2psnark.udmeta.";
    public static final String PROP_STARTUPDELAY = "i2psnark.startupDelay";
    public static final int DEFAULT_STARTUPDELAY = 3;
    //categories
    // do not use this! public static final String PROP_CATEGORIES_STANDARD = "i2psnarkxl.categories.standard";
    public static final String PROP_CATEGORIES_BY_USER = "i2psnarkxl.categories.byUser";
    public static final String DEFAULT_CATEGORIES_STANDARD = "All," + Snark.DEFAULT_CATEGORY;
    public static final String DEFAULT_CATEGORIES_BY_USER = "Apps Audio_Books Books Docu Game Leaked Misc Movie Music Pr0n TV";
    public static final String PROP_CMETA_PREFIX = "i2psnark.cmeta.";
    //public static final String PROP_DMETA_DOWNLOAD_SUFFIX = ".downloaded";
    
    //201009
    public static final String PROP_TORRENT_PEERS_MAX = "i2psnark.peerstorrent.max";
    public static final String PROP_TOTAL_PEERS_MAX = "i2psnark.peerstotal.max";
    public static final String PROP_TORRENT_PEERS_MAX_STANDBYMODE = "i2psnark.peerstotal.max.standby";
    
    public static final String PROP_DESTINATIONS_MAX = "i2psnarkxl.destionations.max";
    public static final int DEFAULT_DESTINATIONS_MAX = 1;
    
    public static final String OLD_AUTO_START = "i2snark.autoStart";   // oops
    
    public static final String PROP_AUTO_START = "i2psnark.autoStart";   // oops
    public static final String DEFAULT_AUTO_START = "false";
    public static final String PROP_USE_OPENTRACKERS = "i2psnark.useOpentrackers";
    public static final String DEFAULT_USE_OPENTRACKERS = "true";
    public static final String PROP_OPENTRACKERS = "i2psnark.opentrackers";
    public static final String DEFAULT_OPENTRACKERS = "http://tracker.welterde.i2p/a";
    
    //eepget anonymity fix
    public static final String PROP_USE_XLProxy = "i2psnark.useXLProxy";
    public static final String DEFAULT_USE_XLProxy = "false"; // better true by default in some of the next updates
    public static final String PROP_SWARM_DIR = "i2psnark.swarmdir";
    public static final String PROP_SWARM_LEADER = "i2psnark.swarmLeader";
//    public static final String PROP_IS_SWARM_LEADER = "i2psnark.swarmLeader";
    public static final String DEFAULT_SWARM_LEADER = "NONE";
    public static final String PROP_USE_XLProxy_OfLeader = "i2psnark.useXLProxyOfLeader";
    public static final String DEFAULT_USE_XLProxy_OfLeader = "true";
    public static final String PROP_LEADER_EEP_PORT = "i2psnark.leader.eepPort";
    public static final String PROP_USE_SWARM_CONF = "i2psnark.swarmconf";
    public static final String DEFAULT_USE_SWARM_CONF = "false";
    
    public static final String PROP_MULTIPLECONNECTIONS_ALLOWED = "i2psnarkxl.multicon";   // oops
    public static final String DEFAULT_MULTIPLECONNECTIONS_ALLOWED = "false";
    /*
     * PROP_STANDBY leeching //worst seeder, do not abuse my line and waste my time to sacrify your ego!
     * make space for working stuff and at least to free the line for participating clients too.
     *
     * PROP_STANDBY seeding // fairshare and increasing the performence for longtime seeders ,at least everbody else break the seed manual.
     * with this setting the chance is high that they won't break the seed like usually.
     */
    
    public static final String PROP_CLIENT_LIST_DELETE_HOURS = "i2psnarkxl.clients.maxHoursOnListTime";
    public static final int DEFAULT_CLIENT_LIST_DELETE_HOURS = 72;
    public static final String PROP_STANDBY_LEECH = "i2psnark.standby.leech";
    public static final String PROP_STANDBY_SEED = "i2psnark.standby.seed";
    public static final String DEFAULT_STANDBY_LEECH = "true";
    public static final String DEFAULT_STANDBY_SEED = "false";
    public static final String PROP_STANDBY_TIME_LEECH = "i2psnark.standby.leech.time";
    public static final int DEFAULT_STANDBY_TIME_LEECH = 30;
    public static final String PROP_STANDBY_TIME_SEED = "i2psnark.standby.seed.time";
    public static final int DEFAULT_STANDBY_TIME_SEED = 60;
    public static final String PROP_RATIO_CONTROL_LEVEL = "i2psnark.ratiocontrol.level";
    public static final int DEFAULT_RATIO_CONTROL_LEVEL = 5;
    public static final String PROP_RESEND_CONTROL_LEVEL = "i2psnark.streaming.maxResends";
    public static final int DEFAULT_RESEND_CONTROL_LEVEL = 4; //default I2PRouter Option is 8
    //start with old amount
    public static final String PROP_TORRENT_STARTAMOUNT = "i2psnark.torrent.startamount";
    public static final String DEFAULT_TORRENT_STARTAMOUNT = "false";
    //pageRefresh
    public static final String PROP_PAGE_REFRESH_INTERVAL = "i2psnark.page.refresh.interval";
    public static final int DEFAULT_PAGE_REFRESH_INTERVAL = 240; 
    
    public static final int MIN_UP_BW = 2;
    public static final int DEFAULT_MAX_UP_BW = 20;
    public static final int DEFAULT_MAX_TORRENT_PEERS = 10;
    public static final int DEFAULT_MAX_TOTAL_PEERS = 40;
    public static final int DEFAULT_MAX_TORRENT_PEERS_STANDBYMODE = 3;// one will be removed allways by standby-needpeers, than we got at least 2 peers and one fresh peer by next tracker requests.
    //public static final String fileSeparator = System.getProperty("file.separator");
    public final static String DEFAULT_CATEGORY = "All";
    
    private static int _startDelay = DEFAULT_STARTUPDELAY;
    private static MessageDigest md5;
    private String _category;
    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            //_log.info("MD5 algorithm required");
            md5 = null;
        }
    }
    
    private SnarkManager() {
        _snarks = new HashMap();
        _addSnarkLock = new Object();
        _context = I2PAppContext.getGlobalContext();
        _log = _context.logManager().getLog(SnarkManager.class);
        _messages = new ArrayList(16);
        _category = DEFAULT_CATEGORY;
        loadConfig("dummyxl.config");
        
        
        //int minutes = getStartupDelayMinutes();
        //_messages.add("Adding torrents in " + minutes + (minutes == 1 ? " minute" : " minutes"));
        I2PThread monitor = new I2PThread(new DirMonitor(), "Snark DirMonitor");
        monitor.setDaemon(true);
        monitor.start();
        // if (_context instanceof RouterContext){
//xxx  before 0.7-7          ((RouterContext)_context).router().addShutdownTask(new SnarkManagerShutdown());
        _context.addShutdownTask(new SnarkManagerShutdown());
        // }
        
    }
    
    public boolean initSwarmConfig(){//monitor reload it again! console doesn't init it yet TODO!!
        if(!getSwarmDir().getName().equalsIgnoreCase("UNSET") && !getSwarmDir().getName().equalsIgnoreCase("NONE") && getSwarmDir().exists()){
            loadSwarmConfig(getSwarmDir().getAbsolutePath() + File.separatorChar + "swarm.config");
            if(_config_swarm != null /*&& isSwarmLeader()*/) {
                return true;//
            }else{
                addMessage("Error: can not validation the swarm.config <" + getSwarmDir().getAbsolutePath() + File.separatorChar + "swarm.config" + ">");
                             /*   _config_swarm = new Properties();
                                if (!_config_swarm.containsKey(PROP_SWARM_LEADER))
                                    _config_swarm.setProperty(PROP_SWARM_LEADER, "NONE");
                                if (!_config_swarm.containsKey(PROP_SWARM_LEADER))
                                    _config_swarm.setProperty(PROP_SWARM_LEADER, "-1");
                                DataHelper.storeProps(_config_swarm, new File(getSwarmDir().getAbsolutePath() + File.separatorChar + "swarm.config"));
                                return true;//
                              */
            }
        }
        return false;
    }
    private static final int MAX_MESSAGES = 5;
    public void addMessage(String message) {
        synchronized (_messages) {
            _messages.add(message);
           /* while (_messages.size() > MAX_MESSAGES)
                _messages.remove(0); */
        }
        if (_log.shouldLog(Log.INFO))
            _log.info("MSG: " + message);
    }
    
    /** newest last */
    public List getMessages() {
        synchronized (_messages) {
            return new ArrayList(_messages);
        }
    }
   /* public boolean shouldLeader() {
        return Boolean.valueOf(_config_swarm.getProperty(PROP_SWARM_LEADER, DEFAULT_SWARM_LEADER+"")).booleanValue();
    }*/
    public boolean shouldAutoStart() {
        return Boolean.valueOf(_config.getProperty(PROP_AUTO_START, DEFAULT_AUTO_START+"")).booleanValue();
    }
    
    //PROP_MULTIPLECONNECTIONS_ALLOWED
    public boolean shouldMultiConnect() {
        return Boolean.valueOf(_config.getProperty(PROP_MULTIPLECONNECTIONS_ALLOWED, DEFAULT_MULTIPLECONNECTIONS_ALLOWED + "")).booleanValue();
    }
    
    //PROP_TORRENT_STARTAMOUNT
    public boolean shouldStartWithAmount() {
        return Boolean.valueOf(_config.getProperty(PROP_TORRENT_STARTAMOUNT, DEFAULT_TORRENT_STARTAMOUNT+"")).booleanValue();
    }
    
    public boolean shouldUseSwarmConfig() {
        return Boolean.valueOf(_config.getProperty(PROP_USE_SWARM_CONF, DEFAULT_USE_SWARM_CONF+"")).booleanValue();
    }
    
    public boolean shouldUseOpenTrackers() {
        return Boolean.valueOf(_config.getProperty(PROP_USE_OPENTRACKERS, DEFAULT_USE_OPENTRACKERS)).booleanValue();
    }
    
    public boolean shouldUseXLProxy() {
        return Boolean.valueOf(_config.getProperty(PROP_USE_XLProxy, DEFAULT_USE_XLProxy)).booleanValue();
    }
    
    //standbyLeech
    public boolean shouldUseStandbyLeech() {
        return Boolean.valueOf(_config.getProperty(PROP_STANDBY_LEECH, DEFAULT_STANDBY_LEECH + "")).booleanValue();
    }
    //standbySeed
    public boolean shouldUseStandbySeed() {
        return Boolean.valueOf(_config.getProperty(PROP_STANDBY_SEED, DEFAULT_STANDBY_SEED + "")).booleanValue();
    }
    
    public boolean shouldUseXLProxyOfLeader() {
        return Boolean.valueOf(_config.getProperty(PROP_USE_XLProxy_OfLeader, DEFAULT_USE_XLProxy_OfLeader)).booleanValue();
    }
    
    public int getStartupDelayMinutes() { return _startDelay; }
    
    public File getDataDir() {
        String dir = _config.getProperty(PROP_DIR);
        if ( (dir == null) || (dir.trim().length() <= 0) )
            dir = "UNSET";
        return new File(dir);
    }
    
    public File getSwarmDir() {
        String dir = _config.getProperty(PROP_SWARM_DIR);
        if ( (dir == null) || (dir.trim().length() <= 0) || (dir == "NONE") )
            dir = "UNSET";
        return new File(dir);
    }
    
    public void loadConfig(String filename) {//fwd since i know this, it was just called once on startup after init sets xlServletInit = true;. if that one day changed we have to care about the logic of xlServletInit! yet i doesn't see that it was called again after the monitoring of torrents started.
        this._configFile = filename;
        if((xlServletInit)){//fwd expecting this is called just once at startup of snark after init sets xlServletInit = true;
            _messages.add("loadConfig " + filename);
        }
        _config = null;
        if (_config == null)
            _config = new Properties();
        File cfg = new File(filename);
        if (cfg.exists()) {
            //fwd: ok, starting here a workaround for the lossing data problem!
            // if the config exists means this client exists before (if multiple clients are used by the user, we can not know that).
            // now let us check if the client last used time was stopped correctly. if so than all is right and the zmeta.datas are proberly valid.
            // if it not was stopped correctly than the zmeta.datas are proberly wrong. (not allways, maybe at last session this file wasn't started at all.
            // if a file is complete we need also not to care. but in case it was removed or deleted we have to care about it's zmeta.datas too!
            // how we do that?! thought best is to write a pid-file - ? //?in the datadir (a datadir should exists because the cfg exists!) ? not yet in datadir
            // we write it in i2p/
            try {
                DataHelper.loadProps(_config, cfg);
                //--------------------------------------------------------------------
                if (_config.containsKey(PROP_DIR)){//part of dataloss workaround
                    if(!getDataDir().getName().equals("UNSET")){//toDo: make a extern methode after testphase
                        File pidfile = new File(nickname + ".pid");
                        if (pidfile.exists()) {// ups! shouldn't exists! proberly the bt-client was not shutdown correctly and the zmeta.datas are wrong!
                            _messages.add("found old pidfile! '" + pidfile + "' proberly '" + nickname + "' was not shutdown correctly!");
                            _messages.add("trying to cleanup all zmeta.datas now!");
                            ArrayList tmpConfig = null;
                            
                            FileReader fin = null;
                            // try { //fwd just to remember when we make a extern methode
                            //------------------ read the old config
                            fin = new FileReader(cfg);
                            BufferedReader in = new BufferedReader(fin);
                            String temp;
                            while ((temp = in.readLine()) != null) {
                                if(tmpConfig == null){
                                    tmpConfig = new ArrayList();
                                }
                                if(tmpConfig != null){
                                    boolean checkincomplete = true;
                                    if (_config.containsKey(PROP_DATA_CHECK) && _config.getProperty(PROP_DATA_CHECK).equalsIgnoreCase("false")){
                                        checkincomplete = false;
                                    }
                                    if(checkincomplete && temp.startsWith("i2psnark.zmeta.") && temp.endsWith(",.")){// don't check completed files
                                        tmpConfig.add(temp);
                                    }else if(!temp.startsWith("i2psnark.zmeta.")){
                                        tmpConfig.add(temp);
                                    }
                                }
                            }
                            fin.close();
                            fin = null;
                            //------------------ write the new config
                            if(tmpConfig != null){
                                
                                FileWriter fout = null;
                                fout = new FileWriter(cfg);
                                PrintWriter out = new PrintWriter(fout);
                                //BufferedWriter out = new BufferedWriter(fout);
                                for(int i = 0; i < tmpConfig.size();i++){
                                    out.println((String)tmpConfig.get(i));
                                }
                                out.close();
                                out = null;
                                _messages.add("cleaned up all zmeta.datas!");
                                
                            }
                            //-------------------- and reload the config
                            _config = null;
                            _config = new Properties();
                            DataHelper.loadProps(_config, cfg);
                            _messages.add("reload config " + filename);
                            //fwd so let's test if this working in the next weeks'
                           /* }catch (java.io.IOException ioe) {
                                _log.error("Error loading I2PSnark config '" + filename + "'", ioe);
                                 _messages.add("Error loading I2PSnark config '" + filename + "'" + ioe);
                                return null;
                            }*/
                            I2PSnarkUtil.instance().setPidfile(pidfile);
                            pidfile.delete(); // delete because proberly this client never starts any tunnel in this session and the config is clean now!
                        }else{// all is like expected
                            // pidfile.createNewFile(); took it out because proberly this client never starts any tunnel in this session and the config is clean now!
                            I2PSnarkUtil.instance().setPidfile(pidfile);
                        }
                        pidfile = null;
                    }
                }
                //--------------------------------------------------------------------
            } catch (IOException ioe) {
                _log.error("Error loading I2PSnark config '" + filename + "'", ioe);
                _messages.add("Error loading I2PSnark config '" + filename + "'" + ioe);
            }
        }
        // now add sane defaults
        if (!_config.containsKey(PROP_DATA_CHECK))
            _config.setProperty(PROP_DATA_CHECK, "true");
        if (!_config.containsKey(PROP_I2CP_HOST))
            _config.setProperty(PROP_I2CP_HOST, "localhost");
        if (!_config.containsKey(PROP_I2CP_PORT))
            _config.setProperty(PROP_I2CP_PORT, "7654");
        if (!_config.containsKey(PROP_I2CP_OPTS))
            _config.setProperty(PROP_I2CP_OPTS, "inbound.length=1 inbound.lengthVariance=1 inbound.nickname=" + nickname + " outbound.length=1 outbound.lengthVariance=1 outbound.nickname=" + nickname);
        if (!_config.containsKey(PROP_EEP_HOST))
            _config.setProperty(PROP_EEP_HOST, "localhost");
        if (!_config.containsKey(PROP_EEP_PORT))
            _config.setProperty(PROP_EEP_PORT, "4444");
        if (!_config.containsKey(PROP_UPLOADERS_TOTAL))
            _config.setProperty(PROP_UPLOADERS_TOTAL, "" + Snark.DEFAULT_TORRENT_UPLOADERS);
        if (!_config.containsKey(PROP_TORRENT_PEERS_MAX))
            _config.setProperty(PROP_TORRENT_PEERS_MAX, "" + Snark.MAX_TORRENT_PEERS);
        
        if (!_config.containsKey(PROP_DESTINATIONS_MAX))
            _config.setProperty(PROP_DESTINATIONS_MAX, "" + DEFAULT_DESTINATIONS_MAX);
        
        if (!_config.containsKey(PROP_CLIENT_LIST_DELETE_HOURS))
            _config.setProperty(PROP_CLIENT_LIST_DELETE_HOURS, "" + DEFAULT_CLIENT_LIST_DELETE_HOURS);
        if (!_config.containsKey(PROP_ID))
            _config.setProperty(PROP_ID, "" + DEFAULT_ID);
        if (!_config.containsKey(PROP_TOTAL_PEERS_MAX))
            _config.setProperty(PROP_TOTAL_PEERS_MAX, "" + Snark.MAX_TOTAL_PEERS);
        
        if (!_config.containsKey(PROP_STARTUPDELAY))
            _config.setProperty(PROP_STARTUPDELAY,  "" + DEFAULT_STARTUPDELAY);        
        if (!_config.containsKey(PROP_PAGE_REFRESH_INTERVAL))
            _config.setProperty(PROP_PAGE_REFRESH_INTERVAL, "" + DEFAULT_PAGE_REFRESH_INTERVAL);
        if (!_config.containsKey(PROP_UPBW_MAX)) {
            try {
                if (_context instanceof RouterContext)
                    _config.setProperty(PROP_UPBW_MAX, "" + (((RouterContext)_context).bandwidthLimiter().getOutboundKBytesPerSecond() / 2));
                else
                    _config.setProperty(PROP_UPBW_MAX, "" + DEFAULT_MAX_UP_BW);
            } catch (NoClassDefFoundError ncdfe) {
                _config.setProperty(PROP_UPBW_MAX, "" + DEFAULT_MAX_UP_BW);
            }
        }
        if (!_config.containsKey(PROP_DIR))
            _config.setProperty(PROP_DIR, nickname);
        
        if (!_config.containsKey(PROP_SWARM_DIR))
            _config.setProperty(PROP_SWARM_DIR, "NONE");
        else _configFile_swarm = getSwarmDir().getAbsolutePath() + File.separatorChar + "swarm.config";
        
        if (!_config.containsKey(PROP_AUTO_START))
            _config.setProperty(PROP_AUTO_START, DEFAULT_AUTO_START);
        
        //PROP_MULTIPLECONNECTIONS_ALLOWED
        if (!_config.containsKey(PROP_MULTIPLECONNECTIONS_ALLOWED))
            _config.setProperty(PROP_MULTIPLECONNECTIONS_ALLOWED, DEFAULT_MULTIPLECONNECTIONS_ALLOWED);
        
        if (!_config.containsKey(PROP_TORRENT_STARTAMOUNT))
            _config.setProperty(PROP_TORRENT_STARTAMOUNT, DEFAULT_TORRENT_STARTAMOUNT);
        
        if (!_config.containsKey(PROP_STANDBY_LEECH))
            _config.setProperty(PROP_STANDBY_LEECH, DEFAULT_STANDBY_LEECH);
        
        if (!_config.containsKey(PROP_STANDBY_SEED))
            _config.setProperty(PROP_STANDBY_SEED, DEFAULT_STANDBY_SEED);
        
        if (!_config.containsKey(PROP_USE_SWARM_CONF))
            _config.setProperty(PROP_USE_SWARM_CONF, DEFAULT_USE_SWARM_CONF);
        
        if (!_config.containsKey(PROP_STANDBY_TIME_LEECH))
            _config.setProperty(PROP_STANDBY_TIME_LEECH, "" + DEFAULT_STANDBY_TIME_LEECH);
        
        if (!_config.containsKey(PROP_STANDBY_TIME_SEED))
            _config.setProperty(PROP_STANDBY_TIME_SEED, "" + DEFAULT_STANDBY_TIME_SEED);
        
        if (!_config.containsKey(PROP_RATIO_CONTROL_LEVEL))
            _config.setProperty(PROP_RATIO_CONTROL_LEVEL, "" + DEFAULT_RATIO_CONTROL_LEVEL);
        
        if (!_config.containsKey(PROP_RESEND_CONTROL_LEVEL))
            _config.setProperty(PROP_RESEND_CONTROL_LEVEL, "" + DEFAULT_RESEND_CONTROL_LEVEL);
        
        if (!_config.containsKey(PROP_CATEGORIES_BY_USER))
            _config.setProperty(PROP_CATEGORIES_BY_USER, "" + DEFAULT_CATEGORIES_BY_USER);
        updateConfig();
    }
    
    public void loadSwarmConfig(String filename) {
        _configFile_swarm = filename;
        if((xlServletInit)){
            //_messages.add("loadConfig_swarm " + filename);
        }
        _config_swarm = null;
        if (_config_swarm == null)
            _config_swarm = new Properties();
        File cfg = new File(filename);
        
        if (cfg.exists()) {
            try {
                DataHelper.loadProps(_config_swarm, cfg);
            }catch (IOException ioe) {
                _log.error("Error loading I2PSnark config '" + filename + "'", ioe);
                _messages.add("Error loading I2PSnark config '" + filename + "'" + ioe);
            }
        }else{
            try{
                //_config_swarm = new Properties();
                if (!_config_swarm.containsKey(PROP_SWARM_LEADER))
                    _config_swarm.setProperty(PROP_SWARM_LEADER, "NONE");
                if (!_config_swarm.containsKey(PROP_LEADER_EEP_PORT))
                    _config_swarm.setProperty(PROP_LEADER_EEP_PORT, "-1");
                DataHelper.storeProps(_config_swarm, cfg);
            }catch (IOException ioe) {
                _messages.add("Error creating swarmconfig '" + filename + "'" + ioe);
            }
        }
        // now add sane defaults
        
        
    }
    
    private void updateConfig() {
        String i2cpHost = _config.getProperty(PROP_I2CP_HOST);
        int i2cpPort = getInt(PROP_I2CP_PORT, 7654);
        String opts = _config.getProperty(PROP_I2CP_OPTS);
        Map i2cpOpts = new HashMap();
        if (opts != null) {
            StringTokenizer tok = new StringTokenizer(opts, " ");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf('=');
                if (split > 0)
                    i2cpOpts.put(pair.substring(0, split), pair.substring(split+1));
            }
        }
        if (i2cpHost != null) {
            I2PSnarkUtil.instance().setI2CPConfig(i2cpHost, i2cpPort, i2cpOpts);
            _log.debug("Configuring with I2CP options " + i2cpOpts);
        }
        //I2PSnarkUtil.instance().setI2CPConfig("66.111.51.110", 7654, new Properties());
        String eepHost = _config.getProperty(PROP_EEP_HOST);
        int eepPort = getInt(PROP_EEP_PORT, 4444);
        if (eepHost != null)
            I2PSnarkUtil.instance().setProxy(eepHost, eepPort);
        I2PSnarkUtil.instance().setMaxUploaders(getInt(PROP_UPLOADERS_TOTAL, Snark.DEFAULT_TORRENT_UPLOADERS));
        I2PSnarkUtil.instance().setMaxUpBW(getInt(PROP_UPBW_MAX, DEFAULT_MAX_UP_BW));
        I2PSnarkUtil.instance().setClientsMaxHoursOnListTime(getInt(PROP_CLIENT_LIST_DELETE_HOURS, DEFAULT_CLIENT_LIST_DELETE_HOURS));
        I2PSnarkUtil.instance().setMaxPeers(getInt(PROP_TORRENT_PEERS_MAX, DEFAULT_MAX_TORRENT_PEERS));
        
        I2PSnarkUtil.instance().setMaxDestinations(getInt(PROP_DESTINATIONS_MAX, DEFAULT_DESTINATIONS_MAX));
        
        I2PSnarkUtil.instance().setMaxPeersTotal(getInt(PROP_TOTAL_PEERS_MAX, DEFAULT_MAX_TOTAL_PEERS));
        I2PSnarkUtil.instance().setMaxPeersStandbyMode(getInt(PROP_TORRENT_PEERS_MAX_STANDBYMODE, DEFAULT_MAX_TORRENT_PEERS_STANDBYMODE));
        I2PSnarkUtil.instance().setStandbyTimeLeech(getInt(PROP_STANDBY_TIME_LEECH, DEFAULT_STANDBY_TIME_LEECH));
        I2PSnarkUtil.instance().setStandbyTimeSeed(getInt(PROP_STANDBY_TIME_SEED, DEFAULT_STANDBY_TIME_SEED));
        I2PSnarkUtil.instance().setUseXLID(getInt(PROP_ID, DEFAULT_ID));
        I2PSnarkUtil.instance().setRatioControlLevel(getInt(PROP_RATIO_CONTROL_LEVEL, DEFAULT_RATIO_CONTROL_LEVEL));
        I2PSnarkUtil.instance().setResendControlLevel(getInt(PROP_RESEND_CONTROL_LEVEL, DEFAULT_RESEND_CONTROL_LEVEL));
        I2PSnarkUtil.instance().setPageRefeshInterval(getInt(PROP_PAGE_REFRESH_INTERVAL, DEFAULT_PAGE_REFRESH_INTERVAL));
        _startDelay = getInt(PROP_STARTUPDELAY, DEFAULT_STARTUPDELAY);
        if(!getDataDir().getName().equals("UNSET")){//fwd, yet the app isn't inited correctly. try it next time! but .. i'm sure that one day somebody name the the datadir reasonly  "UNSET" for the files. greetings to Murphy!
            getDataDir().mkdirs();
        }
    }
    
    private int getInt(String prop, int defaultVal) {
        String p = _config.getProperty(prop);
        try {
            if ( (p != null) && (p.trim().length() > 0) )
                return  Integer.parseInt(p.trim());
        } catch (NumberFormatException nfe) {
            // ignore
        }
        return defaultVal;
    }
    
    public void updateConfig(String dataDir, boolean autoStart, String seedPct, String eepHost,
            String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts,
            String upLimit, String peerLimit, String peerLimitTotal, String upBW, boolean useOpenTrackers,
            String openTrackers,boolean useXLProxy,String swarmDir,boolean isLeader,boolean useXLProxyOfLeader,
            boolean useSwarmConfig, boolean standbyLeech, boolean standbySeed, String standbyTimeLeech, String standbyTimeSeed,
            boolean startAmount, String ratioControlLevel, String resendByI2PRouter,
            String userCategories, String pageRefesh, String destinationsLimit, boolean multiConnect, String startDelay ) {
        
        boolean changed = false;
        boolean wasSwarmLeader = false;
        
        if (eepHost != null) {
            int port = I2PSnarkUtil.instance().getEepProxyPort();
            try { port = Integer.parseInt(eepPort); } catch (NumberFormatException nfe) {}
            String host = I2PSnarkUtil.instance().getEepProxyHost();
            if ( (eepHost.trim().length() > 0) && (port > 0) &&
                    ((!host.equals(eepHost) || (port != I2PSnarkUtil.instance().getEepProxyPort()) )) ) {
                I2PSnarkUtil.instance().setProxy(eepHost, port);
                changed = true;
                _config.setProperty(PROP_EEP_HOST, eepHost);
                _config.setProperty(PROP_EEP_PORT, eepPort+"");
                //eppget fix
                org.i2p.i2psnarkxl.tunnel.ProxyHttpClient.instance().refreshSettings();
                addMessage("EepProxy location changed to " + eepHost + ":" + port);
                if(/*shouldUseSwarmConfig() &&*/ _config_swarm != null && isSwarmLeader()){
                    //_config.setProperty(PROP_LEADER_EEP_PORT, eepPort + "");
                    _config_swarm.setProperty(PROP_LEADER_EEP_PORT, eepPort + "");
                }
            }
        }
        if (upLimit != null) {
            int limit = I2PSnarkUtil.instance().getMaxUploaders();
            try { limit = Integer.parseInt(upLimit); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getMaxUploaders()) {
                if ( limit >= Snark.MIN_TOTAL_UPLOADERS ) {
                    I2PSnarkUtil.instance().setMaxUploaders(limit);
                    changed = true;
                    _config.setProperty(PROP_UPLOADERS_TOTAL, "" + limit);
                    addMessage("Total uploaders limit changed to " + limit);
                } else {
                    addMessage("Minimum total uploaders limit is " + Snark.MIN_TOTAL_UPLOADERS);
                }
            }
        }
        
        if (standbyTimeLeech != null) {
            int minute = 60*1000;
            int limit = I2PSnarkUtil.instance().getStandbyTimeLeech();
            try { limit = Integer.parseInt(standbyTimeLeech); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getStandbyTimeLeech()) {
                if ( limit * minute >= Snark.STANDBYMODE_FALLBACK_TIME ) {
                    I2PSnarkUtil.instance().setStandbyTimeLeech(limit);
                    changed = true;
                    _config.setProperty(PROP_STANDBY_TIME_LEECH, "" + limit);
                    addMessage("Standby fallback time (Leech) changed to " + limit + " minutes");
                } else {
                    addMessage("Minimum Standby fallback time (Leech) is " + Snark.STANDBYMODE_FALLBACK_TIME/minute + " minutes");
                }
            }
        }
        //ratioControlLevel
        if (ratioControlLevel != null) {
            //int minute = 60*1000;
            int limit = I2PSnarkUtil.instance().getRatioControlLevel();
            try { limit = Integer.parseInt(ratioControlLevel); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getRatioControlLevel()) {
                if ( limit != I2PSnarkUtil.instance().getRatioControlLevel()) {
                    if(limit > 2 && limit < 9){
                        I2PSnarkUtil.instance().setRatioControlLevel(limit);
                        changed = true;
                        _config.setProperty(PROP_RATIO_CONTROL_LEVEL, "" + limit);
                        addMessage("Ratio Control Level changed to 0." + limit + "");
                    }else{
                        changed = true;
                        _config.setProperty(PROP_RATIO_CONTROL_LEVEL, "" + DEFAULT_RATIO_CONTROL_LEVEL);
                        I2PSnarkUtil.instance().setRatioControlLevel(Snark.RATIO_CONTROL_LEVEL);
                        addMessage("Ratio Control Level has to be between 0.3 and 0.8, current setting is " + I2PSnarkUtil.instance().getRatioControlLevel() + "");
                    }
                } else {
                    addMessage("Ratio Control Level: Unknown error appears during change! Ratio Control Level is " + I2PSnarkUtil.instance().getRatioControlLevel() + "");
                }
            }
        }
        
        //resendByI2PRouter
        if (resendByI2PRouter != null) {
            //int minute = 60*1000;
            int limit = I2PSnarkUtil.instance().getResendControlLevel();
            try { limit = Integer.parseInt(resendByI2PRouter); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getResendControlLevel()) {
                if ( limit != I2PSnarkUtil.instance().getResendControlLevel()) {
                    if(limit > 1 && limit < 11){
                        I2PSnarkUtil.instance().setResendControlLevel(limit);
                        changed = true;
                        _config.setProperty(PROP_RESEND_CONTROL_LEVEL, "" + limit);
                        addMessage("Resend Level changed to " + limit + "");
                    }else{
                        changed = true;
                        _config.setProperty(PROP_RESEND_CONTROL_LEVEL, "" + DEFAULT_RESEND_CONTROL_LEVEL);
                        I2PSnarkUtil.instance().setResendControlLevel(Snark.RESEND_CONTROL_LEVEL);
                        addMessage("Resend Control Level has to be between 2 and 10, current setting is " + I2PSnarkUtil.instance().getRatioControlLevel() + "");
                    }
                } else {
                    addMessage("Ratio Control Level: Unknown error appears during change! Resend Control Level is " + I2PSnarkUtil.instance().getRatioControlLevel() + "");
                }
            }
        }
        
        if (standbyTimeSeed != null) {
            int minute = 60*1000;
            int limit = I2PSnarkUtil.instance().getStandbyTimeSeed();
            try { limit = Integer.parseInt(standbyTimeSeed); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getStandbyTimeSeed()) {
                if ( limit * minute >= Snark.STANDBYMODE_FALLBACK_TIME ) {
                    I2PSnarkUtil.instance().setStandbyTimeSeed(limit);
                    changed = true;
                    _config.setProperty(PROP_STANDBY_TIME_SEED, "" + limit);
                    addMessage("Standby fallback time (Seed) changed to " + limit + " minutes");
                } else {
                    addMessage("Minimum Standby fallback time (Seed) is " + Snark.STANDBYMODE_FALLBACK_TIME/minute + " minutes");
                }
            }
        }
        
        if (peerLimit != null) {
            int limit = I2PSnarkUtil.instance().getMaxPeers();
            try { limit = Integer.parseInt(peerLimit); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getMaxPeers()) {
                if ( limit >= Snark.MIN_TORRENT_PEERS ) {
                    I2PSnarkUtil.instance().setMaxPeers(limit);
                    changed = true;
                    _config.setProperty(PROP_TORRENT_PEERS_MAX, "" + limit);
                    addMessage("Torrent peers limit changed to " + limit);
                } else {
                    addMessage("Minimum Torrent peers limit is " + Snark.MIN_TORRENT_PEERS);
                }
            }
        }
        
        if (destinationsLimit != null) {
            int limit = I2PSnarkUtil.instance().getMaxDestinations();
            try { limit = Integer.parseInt(destinationsLimit); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getMaxDestinations()) {
                if ( limit >= 1 ) {
                    I2PSnarkUtil.instance().setMaxDestinations(limit);
                    changed = true;
                    _config.setProperty(PROP_DESTINATIONS_MAX, "" + limit);
                    addMessage("Destinations limit changed to " + limit);
                    if(limit < I2PSnarkUtil.instance().getActiveDestinations())addMessage("disconnecting " + (I2PSnarkUtil.instance().getActiveDestinations() - limit) + " Destination(s)");
                    while(limit < I2PSnarkUtil.instance().getActiveDestinations()){
                        I2PSnarkUtil.instance().disconnect(I2PSnarkUtil.instance().getActiveDestinations()-1);
                    }
                    if(limit > I2PSnarkUtil.instance().getActiveDestinations() && getActiveTorrents() > 0){
                        addMessage("connecting with " + (limit - I2PSnarkUtil.instance().getActiveDestinations())+ " new Destination(s)");
                        I2PSnarkUtil.instance().connect();
                    }
                } else {
                    addMessage("Minimum Destinations limit is " + "1");
                }
            }
        }
        
        //startDelay
        if (startDelay != null) {
            int limit = getStartupDelayMinutes();
            try { limit = Integer.parseInt(startDelay); } catch (NumberFormatException nfe) {}
            if ( limit != _startDelay) {
                if ( limit >= 1 ) {
                     _startDelay = limit;
                    changed = true;
                    _config.setProperty(PROP_STARTUPDELAY, "" + limit);
                    addMessage("Autostart delay changed to " + limit);
                } else {
                    addMessage("Minimum Autostart delay " + 1);
                }
            }
        }
        
        if (peerLimitTotal != null) {
            int limit = I2PSnarkUtil.instance().getMaxPeersTotal();
            try { limit = Integer.parseInt(peerLimitTotal); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getMaxPeersTotal()) {
                if ( limit >= Snark.MIN_TOTAL_PEERS ) {
                    I2PSnarkUtil.instance().setMaxPeersTotal(limit);
                    changed = true;
                    _config.setProperty(PROP_TOTAL_PEERS_MAX, "" + limit);
                    addMessage("Total peers limit changed to " + limit);
                } else {
                    addMessage("Minimum total peers limit is " + Snark.MIN_TOTAL_PEERS);
                }
            }
        }
        if (pageRefesh != null) {
            int limit = I2PSnarkUtil.instance().getPageRefeshInterval();
            try { limit = Integer.parseInt(pageRefesh); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getPageRefeshInterval()) {
                if ( limit >= 15 ) {
                    I2PSnarkUtil.instance().setPageRefeshInterval(limit);
                    changed = true;
                    _config.setProperty(PROP_PAGE_REFRESH_INTERVAL, "" + limit);
                    addMessage("Page refresh interval changed to " + limit);
                } else {
                    addMessage("Minimum Page refresh interval is " + "15 seconds");// at least the min time to change the config hurry
                }
            }
        }
        if (upBW != null) {
            int limit = I2PSnarkUtil.instance().getMaxUpBW();
            try { limit = Integer.parseInt(upBW); } catch (NumberFormatException nfe) {}
            if ( limit != I2PSnarkUtil.instance().getMaxUpBW()) {
                if ( limit >= MIN_UP_BW ) {
                    I2PSnarkUtil.instance().setMaxUpBW(limit);
                    changed = true;
                    _config.setProperty(PROP_UPBW_MAX, "" + limit);
                    addMessage("Up BW limit changed to " + limit + "KBps");
                } else {
                    addMessage("Minimum Up BW limit is " + MIN_UP_BW + "KBps");
                }
            }
        }
        if (i2cpHost != null) {
            int oldI2CPPort = I2PSnarkUtil.instance().getI2CPPort();
            String oldI2CPHost = I2PSnarkUtil.instance().getI2CPHost();
            int port = oldI2CPPort;
            try { port = Integer.parseInt(i2cpPort); } catch (NumberFormatException nfe) {}
            String host = oldI2CPHost;
            Map opts = new HashMap();
            if (i2cpOpts == null) i2cpOpts = "";
            StringTokenizer tok = new StringTokenizer(i2cpOpts, " \t\n");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf('=');
                if (split > 0)
                    opts.put(pair.substring(0, split), pair.substring(split+1));
            }
            Map oldOpts = new HashMap();
            String oldI2CPOpts = _config.getProperty(PROP_I2CP_OPTS);
            if (oldI2CPOpts == null) oldI2CPOpts = "";
            tok = new StringTokenizer(oldI2CPOpts, " \t\n");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf('=');
                if (split > 0)
                    oldOpts.put(pair.substring(0, split), pair.substring(split+1));
            }
            
            if ( (i2cpHost.trim().length() > 0) && (port > 0) &&
                    ((!host.equals(i2cpHost) ||
                    (port != I2PSnarkUtil.instance().getI2CPPort()) ||
                    (!oldOpts.equals(opts)))) ) {
                boolean snarksActive = false;
                Set names = listTorrentFiles();
                for (Iterator iter = names.iterator(); iter.hasNext(); ) {
                    Snark snark = getTorrent((String)iter.next());
                    if ( (snark != null) && (!snark.stopped) ) {
                        snarksActive = true;
                        break;
                    }
                }
                if (snarksActive) {
                    addMessage("Cannot change the I2CP settings while torrents are active");
                    _log.debug("i2cp host [" + i2cpHost + "] i2cp port " + port + " opts [" + opts
                            + "] oldOpts [" + oldOpts + "]");
                } else {
                    if (I2PSnarkUtil.instance().connected()) {
                        I2PSnarkUtil.instance().disconnect(-1);
                        addMessage("Disconnecting old I2CP destination");
                    }
                    Properties p = new Properties();
                    p.putAll(opts);
                    addMessage("I2CP settings changed to " + i2cpHost + ":" + port + " (" + i2cpOpts.trim() + ")");
                    I2PSnarkUtil.instance().setI2CPConfig(i2cpHost, port, p);
                    boolean ok = I2PSnarkUtil.instance().connect();
                    if (!ok) {
                        addMessage("Unable to connect with the new settings, reverting to the old I2CP settings");
                        I2PSnarkUtil.instance().setI2CPConfig(oldI2CPHost, oldI2CPPort, oldOpts);
                        ok = I2PSnarkUtil.instance().connect();
                        if (!ok)
                            addMessage("Unable to reconnect with the old settings!");
                    } else {
                        addMessage("Reconnected on the new I2CP destination");
                        _config.setProperty(PROP_I2CP_HOST, i2cpHost.trim());
                        _config.setProperty(PROP_I2CP_PORT, "" + port);
                        _config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                        changed = true;
                        // no PeerAcceptors/I2PServerSockets to deal with, since all snarks are inactive
                        for (Iterator iter = names.iterator(); iter.hasNext(); ) {
                            String name = (String)iter.next();
                            Snark snark = getTorrent(name);
                            if ( (snark != null) && (snark.acceptor != null) ) {
                                snark.acceptor.restart();
                                addMessage("I2CP listener restarted for " + snark.meta.getName());
                            }
                        }
                    }
                }
                changed = true;
            }
        }
        if (shouldAutoStart() != autoStart) {
            _config.setProperty(PROP_AUTO_START, autoStart + "");
            addMessage("Adjusted autostart to " + autoStart);
            changed = true;
        }
        //PROP_MULTIPLECONNECTIONS_ALLOWED
        if (shouldMultiConnect() != multiConnect) {
            _config.setProperty(PROP_MULTIPLECONNECTIONS_ALLOWED, multiConnect + "");
            addMessage("Adjusted multiple connections to " + multiConnect);
            changed = true;
        }
        
        if (shouldStartWithAmount() != startAmount) {
            _config.setProperty(PROP_TORRENT_STARTAMOUNT, startAmount + "");
            addMessage("Adjusted startAmount to " + startAmount);
            changed = true;
        }
        
        if (shouldUseStandbyLeech() != standbyLeech) {
            _config.setProperty(PROP_STANDBY_LEECH, standbyLeech + "");
            addMessage("Adjusted standby (leeching) to " + standbyLeech);
            changed = true;
        }
        
        if (shouldUseStandbySeed() != standbySeed) {
            _config.setProperty(PROP_STANDBY_SEED, standbySeed + "");
            addMessage("Adjusted standby (seeding) to " + standbySeed);
            changed = true;
        }
        
        if (shouldUseOpenTrackers() != useOpenTrackers) {
            _config.setProperty(PROP_USE_OPENTRACKERS, useOpenTrackers + "");
            addMessage((useOpenTrackers ? "En" : "Dis") + "abled open trackers - torrent restart required to take effect");
            changed = true;
        }
        if ( shouldUseXLProxy() != useXLProxy) {
            //eepget anonymity fix
            _config.setProperty(PROP_USE_XLProxy, useXLProxy + "");
            addMessage((useXLProxy ? "En" : "Dis") + "abled useXLProxy");
            if(I2PSnarkUtil.instance().connected() && useXLProxy){
                org.i2p.i2psnarkxl.tunnel.ProxyHttpClient.instance().startControllerTunnel();
            }else if(!useXLProxy){
                org.i2p.i2psnarkxl.tunnel.ProxyHttpClient.instance().stopControllerTunnel();
            }
            if(shouldUseSwarmConfig() && _config_swarm != null && isSwarmLeader()){
                //_config.setProperty(PROP_LEADER_EEP_PORT, I2PSnarkUtil.instance().getEepProxyPort() + "");
                _config_swarm.setProperty(PROP_LEADER_EEP_PORT, I2PSnarkUtil.instance().getEepProxyPort() + "");
            }
            changed = true;
        }
        
        //if(swarmDir.isEmpty())swarmDir = "NONE";
        if(shouldUseSwarmConfig()){
            if(getSwarmDir().getName().equalsIgnoreCase("NONE") && swarmDir != null && swarmDir.isEmpty()){
                //ignore
            }else{
                if (!getSwarmDir().getAbsolutePath().equalsIgnoreCase(swarmDir)) {
                    if(swarmDir == null || swarmDir.isEmpty())swarmDir = new String("NONE");
                    _config.setProperty(PROP_SWARM_DIR, swarmDir + "");
                    addMessage("Adjusted swarm directory to " + swarmDir);
                    changed = true;
                }
            }
        }
        if (shouldUseSwarmConfig() && _config_swarm != null && isSwarmLeader() != isLeader) {
            //_config.setProperty(PROP_SWARM_LEADER, isLeader + "");
            if(isLeader){
                _config_swarm.setProperty(PROP_SWARM_LEADER, nickname + "");
                //_config.setProperty(PROP_LEADER_EEP_PORT, I2PSnarkUtil.instance().getEepProxyPort() + "");
                _config_swarm.setProperty(PROP_LEADER_EEP_PORT, I2PSnarkUtil.instance().getEepProxyPort() + "");
                addMessage("Adjusted swarm leader to " + nickname);
            }else{
                if(_config_swarm != null){
                    wasSwarmLeader = true;
                    _config_swarm.setProperty(PROP_SWARM_LEADER, "NONE" + "");
                    //_config.setProperty(PROP_LEADER_EEP_PORT, I2PSnarkUtil.instance().getEepProxyPort() + "-1");
                    _config_swarm.setProperty(PROP_LEADER_EEP_PORT, "-1");
                    addMessage("Adjusted swarm leader to " + "NONE");
                }
            }
            changed = true;
        }
        
        if (shouldUseSwarmConfig() && shouldUseXLProxyOfLeader() != useXLProxyOfLeader) {
            //eepget anonymity fix
            _config.setProperty(PROP_USE_XLProxy_OfLeader, useXLProxyOfLeader + "");
            addMessage((useXLProxyOfLeader ? "En" : "Dis") + "abled useXLProxyOfLeader");
            if(useXLProxyOfLeader && !isLeader){
                //we use the proxy from the leader of the swarm
                org.i2p.i2psnarkxl.tunnel.ProxyHttpClient.instance().stopControllerTunnel();
                //org.i2p.i2psnarkxl.tunnel.ProxyHttpClient.instance().startControllerTunnel();
            }else if(!I2PSnarkUtil.instance().connected() && useXLProxyOfLeader && isLeader && useXLProxy){
                //even when we are not connected we need a proxy for the swarm units!
                org.i2p.i2psnarkxl.tunnel.ProxyHttpClient.instance().startControllerTunnel();
            }else if(I2PSnarkUtil.instance().connected() && useXLProxy && !useXLProxyOfLeader){
                // we use own proxy
                org.i2p.i2psnarkxl.tunnel.ProxyHttpClient.instance().startControllerTunnel();
            }
            changed = true;
        }
        
        if (openTrackers != null) {
            if (openTrackers.trim().length() > 0 && !openTrackers.trim().equals(getOpenTrackerString())) {
                _config.setProperty(PROP_OPENTRACKERS, openTrackers.trim());
                addMessage("Open Tracker list changed - torrent restart required to take effect");
                changed = true;
            }
        }
        //PROP_CATEGORIES_nnn
        if (userCategories != null) {
            if (userCategories.trim().length() > 0 && !userCategories.trim().equals(getUserCategoriesString())) {
                _config.setProperty(PROP_CATEGORIES_BY_USER, userCategories.trim());
                addMessage("Category list changed " + userCategories);
                changed = true;
                //clean possible wrong categories---------------------------
                Snark snark = null;
                Set files = listTorrentFiles();
                TreeSet fileNames = new TreeSet(files); // sorts it alphabetically
                List rv = getUserCategoriesList();
                for (Iterator iter = fileNames.iterator(); iter.hasNext(); ) {
                    String name = (String)iter.next();
                    snark = getTorrent(name);
                    if (snark != null && !rv.contains(snark.getCategory())){
                        snark.setCategory(snark.DEFAULT_CATEGORY);
                    }
                }                
            }
        }
        
        if (shouldUseSwarmConfig() != useSwarmConfig) {//need to be last!
            _config.setProperty(PROP_USE_SWARM_CONF, useSwarmConfig + "");
            addMessage("Adjusted useSwarmConfig to " + useSwarmConfig);
            changed = true;
            if(useSwarmConfig){
                if(_config_swarm != null){
                    swarmDir = getSwarmDir().getAbsolutePath();
                    initSwarmConfig();
                    isLeader = isSwarmLeader();
                    useXLProxyOfLeader = shouldUseXLProxyOfLeader();
                }
            }
        }
        if (changed) {
            saveConfig(_configFile,_config);
            if(_config_swarm != null && isSwarmLeader() || wasSwarmLeader){
                saveConfig(_configFile_swarm,_config_swarm);
            }
        } else {
            addMessage("Configuration unchanged");
        }
    }
    
    public int getActiveTorrents(){
        int active = 0;
        for (Iterator iter = listTorrentFiles().iterator(); iter.hasNext(); ) {
                        String name = (String)iter.next();
                        Snark snark = getTorrent(name);
                        if ( !snark.stopped ) {
                            active ++;
                        }
                    }
        return active;
    }
    
    //todo sort probs before saving
    public synchronized void saveConfig(String cfx,Properties prob) {
        try {
            synchronized (cfx) {
                prob.remove(PROP_ID);//read code!
                prob.remove(OLD_AUTO_START);// remove this line and OLD_AUTO_START in future versions
                DataHelper.storeProps(prob, new File(cfx));
            }
        } catch (IOException ioe) {
            addMessage("Unable to save the config to '" + cfx + "'");
        }
        /*//fwd original
        try {
            synchronized (_configFile) {
                DataHelper.storeProps(_config, new File(_configFile));
            }
        } catch (IOException ioe) {
            addMessage("Unable to save the config to '" + _configFile + "'");
        }
         **/
    }
    
    public Properties getConfig() { return _config; }
    
    /** hardcoded for sanity.  perhaps this should be customizable, for people who increase their ulimit, etc. */
    private static final int MAX_FILES_PER_TORRENT = -1;//128;
    
    /** set of filenames that we are dealing with */
    public Set listTorrentFiles() { synchronized (_snarks) { return new HashSet(_snarks.keySet()); } }
    /**
     * Grab the torrent given the (canonical) filename
     */
    public Snark getTorrent(String filename) { synchronized (_snarks) { return (Snark)_snarks.get(filename); } }
    public void addTorrent(String filename) { addTorrent(filename, false); }
    public void addTorrent(String filename, boolean dontAutoStart) {
        if ((!dontAutoStart) && !I2PSnarkUtil.instance().connected()) {
            addMessage("Connecting to I2P");
            boolean ok = I2PSnarkUtil.instance().connect();
            if (!ok) {
                addMessage("Error connecting to I2P - check your I2CP settings");
                return;
            }
        }
        File sfile = new File(filename);
        boolean torrentAdded = false;
        try {
            String test_filename = sfile.getCanonicalPath();
        } catch (IOException ioe) {
            _log.error("Unable to add the torrent " + filename, ioe);
            addMessage("ERR: Could not add the torrent '" + filename + "': " + ioe.getMessage());
            return;
        }
        File dataDir = sfile.getParentFile();//getDataDir();//fwd xl swarm
        if(dataDir == null){
            dataDir = getDataDir();
            System.out.println("dataDir failt: " + filename);
        }else{
            /*
            try{
                System.out.println("dataDir : " + dataDir.getCanonicalPath());
            }catch (IOException ioe) {
                ioe.printStackTrace();
            }
             **/
        }
        Snark torrent = null;
        Snark torrent_d = null;
        Snark torrent_s = null;
        boolean bd = false;
        boolean bs = false;
        synchronized (_snarks) {
            torrent = (Snark)_snarks.get(filename);
            //System.out.println("addTorrentNameO: " + filename);
            
            String fd = getDataDir().getAbsolutePath() + File.separator + sfile.getName();
            torrent_d = (Snark)_snarks.get(fd);
            //System.out.println("addTorrentNameD: " + fd);
            bd = (torrent_d != null) ? true : false;
            
            String fs = getSwarmDir().getAbsolutePath() + File.separator + sfile.getName();
            torrent_s = (Snark)_snarks.get(fs);
            //System.out.println("addTorrentNameS: " + fs);
            bs = (torrent_s != null) ? true : false;
        }
        // don't hold the _snarks lock while verifying the torrent
        if (torrent == null && !bd && !bs) {
            synchronized (_addSnarkLock) {
                // double-check
                synchronized (_snarks) {
                    if(_snarks.get(filename) != null)
                        return;
                    /*if(_snarks.get(getDataDir().getAbsolutePath() + File.separator + sfile.getName()) != null){
                        addMessage("delete file: " + sfile.getName() + ". File is allready listed.");
                        //sfile.delete();
                        return;
                    }
                    if(_snarks.get(getSwarmDir().getAbsolutePath() + File.separator + sfile.getName()) != null){
                        addMessage("delete file: " + sfile.getName() + ". File is allready listed.");
                        //sfile.delete();
                        return;
                    }*/
                }
                
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(sfile);
                    MetaInfo info = new MetaInfo(fis);
                    fis.close();
                    fis = null;
                    //String metainfohash = Base64.encode(info.getInfoHash()) ;
                    //Snark nsnark = getTorrentByMetaInfoHash(metainfohash);
                    String rejectMessage = locked_validateTorrent(info);
                    if (rejectMessage != null) {
                        sfile.delete();
                        addMessage(rejectMessage);
                        return;
                   /* } else if(nsnark != null && new File(nsnark.torrent) != sfile.getCanonicalFile()){
                        addMessage("delete file: " + sfile.getName() + ". File is allready listed.");
                        sfile.delete();
                       return;*/
                    } else {
                        torrent = new Snark(filename, null, -1, null, null, false, dataDir.getPath());
                        //System.out.println("addTorrent: " + torrent.torrent);
                        torrent.completeListener = this;
                        synchronized (_snarks) {
                            
                            
                            if( !isSwarmLeader() && isSwarmDir(sfile) && !torrent.storage.complete()){
                                // addMessage("Torrent incomplete or not initalized by the swarm leader: '" + filename + "' dropped!");
                                // drop swarmfiles that are incompleted for ordinary swarmunits
                            }else{
                                _snarks.put(filename, torrent);
                                instance().saveTorrentStatus(torrent.storage.getMetaInfo(), torrent.storage.getBitField());
                                torrentAdded = true;
                            }
                            //_snarks.put(torrent.torrent, torrent);
                        }
                    }
                } catch (IOException ioe) {
                    addMessage("Torrent in " + sfile.getName() + " is invalid: " + ioe.getMessage());
                    if (sfile.exists())
                        sfile.delete();
                    return;
                } finally {
                    if (fis != null) try { fis.close(); } catch (IOException ioe) {}
                }
            }
        } else {
            
            if(sfile.exists() && torrent == null){// listed in a different datastore
                if(bd){
                    sfile.delete();
                    addMessage("delete file: " + sfile.getAbsolutePath() + ". File is allready listed in '" + ((bd) ? getDataDir().getAbsolutePath() : getSwarmDir().getAbsolutePath()) + "'.");
                }else if(bs && isSwarmLeader()){
                    // don't delete it when it is located in the swarm-directory! Only the swarm leader should be allowed to deleting a swarm-torrent!
                    sfile.delete();
                    addMessage("delete file: " + sfile.getAbsolutePath() + ". File is allready listed in '" + ((bd) ? getDataDir().getAbsolutePath() : getSwarmDir().getAbsolutePath()) + "'.");
                }else{
                    addMessage("file: " + sfile.getAbsolutePath() + ". File is allready listed in '" + ((bd) ? getDataDir().getAbsolutePath() : getSwarmDir().getAbsolutePath()) + "'.");
                }
            }else{//mmh? same file is listed. that shouldn't happen!
                addMessage("file: " + sfile.getAbsolutePath() + ". File is allready listed.");
            }
            return;
        }
        // ok, snark created, now lets start it up or configure it further
        File f = new File(filename);
        if (!dontAutoStart && shouldAutoStart() && torrentAdded) {
            torrent.startTorrent();
            addMessage("Torrent added and started: '" + f.getName() + "'");
        } else {
            if(torrentAdded)
                addMessage("Torrent added: '" + filename + "'");
        }
    }
    
    /**
     * Get the timestamp for a torrent from the config file
     */
    public long getSavedTorrentTime(MetaInfo metainfo, File torrentFile) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String time = _config.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        if(_config_swarm != null && isSwarmDir(torrentFile) && time == null && !isSwarmLeader()){
            String time_swarm = _config_swarm.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
            if (time_swarm != null){
                time = time_swarm;
            }
        }
        if (time == null)
            return 0;
        int comma = time.indexOf(',');
        if (comma <= 0)
            return 0;
        time = time.substring(0, comma);
        try { return Long.parseLong(time); } catch (NumberFormatException nfe) {}
        return 0;
    }
    
    /**
     * Get the saved bitfield for a torrent from the config file.
     * Convert "." to a full bitfield.
     */
    public BitField getSavedTorrentBitField(MetaInfo metainfo, File torrentFile) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String bf = _config.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        
        //-------------------- swarm
        String metainfohash = Base64.encode(metainfo.getInfoHash()) ;
        //Snark snark = getTorrentByMetaInfoHash(metainfohash);
        if(_config_swarm != null && isSwarmDir(torrentFile) && bf == null && !isSwarmLeader()){
            String bf_swarm = _config_swarm.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
            if (bf_swarm != null){
                bf = bf_swarm;
                //System.out.println("SavedTorrentBitField swarm-" + SnarkManager.instance().getNickname() + "-");
                
            }else{// fake it. leader says OK
                //if(!isSwarmLeader() && isSwarmUnit())
                //bf =  "" + (System.currentTimeMillis()-1000) + ",.";
                //System.out.println("SavedTorrentBitField null-" + SnarkManager.instance().getNickname() + "-");
            }
        }//else
        //System.out.println("SavedTorrentBitField normal-" + SnarkManager.instance().getNickname() + "-");
        //--------------------
        
        if (bf == null)
            return null;
        int comma = bf.indexOf(',');
        if (comma <= 0)
            return null;
        bf = bf.substring(comma + 1).trim();
        int len = metainfo.getPieces();
        if (bf.equals(".")) {
            BitField bitfield = new BitField(len);
            for (int i = 0; i < len; i++)
                bitfield.set(i);
            return bitfield;
        }
        byte[] bitfield = Base64.decode(bf);
        if (bitfield == null)
            return null;
        if (bitfield.length * 8 < len)
            return null;
        return new BitField(bitfield, len);
    }
    
    
    /**
     * XL
     * Get the storaged bitfield for a torrent.
     * and return the byte[] of it.
     */
    public Snark getTorrentByMetaInfoHash(String metainfohash) {
        MetaInfo metainfo = null;
        //BitField bf = null;
        Snark snark = null;
        Set files = listTorrentFiles();
        TreeSet fileNames = new TreeSet(files); // sorts it alphabetically
        //ArrayList rv = new ArrayList(fileNames.size());
        for (Iterator iter = fileNames.iterator(); iter.hasNext(); ) {
            String name = (String)iter.next();
            snark = getTorrent(name);
            if (snark != null){
                String mhash = Base64.encode(snark.meta.getInfoHash());
                if(mhash.equals(metainfohash)){
                    //    bf = snark.storage.getBitField();
                    //metainfo = snark.meta;
                    break;
                }
            }else {
                _log.error("snark for metainfohash = null" + metainfohash);
            }
        }
        // if(metainfo == null)return null;
        //BitField bf =  getSavedTorrentBitField( metainfo) ;
        // if (bf == null) return null;
        return snark;
    }
    /**
     * XL
     * Get the storaged bitfield for a torrent.
     * and return the byte[] of it.
     */
    public byte[] getTorrentBitFieldByteByMetaInfoHash(String metainfohash) {
        MetaInfo metainfo = null;
        BitField bf = null;
        Set files = listTorrentFiles();
        TreeSet fileNames = new TreeSet(files); // sorts it alphabetically
        //ArrayList rv = new ArrayList(fileNames.size());
        for (Iterator iter = fileNames.iterator(); iter.hasNext(); ) {
            String name = (String)iter.next();
            Snark snark = getTorrent(name);
            if (snark != null){
                String mhash = Base64.encode(snark.meta.getInfoHash());
                if(mhash.equals(metainfohash)){
                    bf = snark.storage.getBitField();
                    //metainfo = snark.meta;
                    break;
                }
            }else {
                _log.error("snark for metainfohash = null" + metainfohash);
            }
        }
        
        // if(metainfo == null)return null;
        //BitField bf =  getSavedTorrentBitField( metainfo) ;
        if (bf == null) return null;
        return bf.getFieldBytes();
    }
    
    /**
     * XL
     * Get the storaged bitfield for a torrent.
     * and return the byte[] of it.
     * todo: is nearly same methode like getTorrentBitFieldByteByMetaInfoHash(..). make a util.class methode of them
     */
    public byte[] getTorrentSuperseedBitFieldByteByMetaInfoHash(String metainfohash) {
        MetaInfo metainfo = null;
        byte[] bfb = null;
        Set files = listTorrentFiles();
        TreeSet fileNames = new TreeSet(files); // sorts it alphabetically
        //ArrayList rv = new ArrayList(fileNames.size());
        for (Iterator iter = fileNames.iterator(); iter.hasNext(); ) {
            String name = (String)iter.next();
            Snark snark = getTorrent(name);
            if (snark != null){
                String mhash = Base64.encode(snark.meta.getInfoHash());
                if(mhash.equals(metainfohash)){
                    bfb = snark.storage.getSuperseedBitField();
                    //metainfo = snark.meta;
                    break;
                }
            }else {
                _log.error("snark for metainfohash = null" + metainfohash);
            }
        }
        
        if (bfb == null) return null;
        return bfb;
    }
    
    /**
     * XL
     * Get the storaged bitfield for a torrent.
     * and return the byte[] of it.
     * todo: is nearly same methode like getTorrentBitFieldByteByMetaInfoHash(..). make a util.class methode of them
     */
    public byte[] getTorrentSuperseedXORBitFieldByteByMetaInfoHash(String metainfohash) {
        MetaInfo metainfo = null;
        byte[] bfb = null;
        Set files = listTorrentFiles();
        TreeSet fileNames = new TreeSet(files); // sorts it alphabetically
        //ArrayList rv = new ArrayList(fileNames.size());
        for (Iterator iter = fileNames.iterator(); iter.hasNext(); ) {
            String name = (String)iter.next();
            Snark snark = getTorrent(name);
            if (snark != null){
                String mhash = Base64.encode(snark.meta.getInfoHash());
                if(mhash.equals(metainfohash)){
                    bfb = snark.storage.getXORSuperseedBitField();
                    //metainfo = snark.meta;
                    break;
                }
            }else {
                _log.error("snark for metainfohash = null" + metainfohash);
            }
        }
        
        if (bfb == null) return null;
        return bfb;
    }
    /*
     * Ratio: counting all saved down/up amount ever
     */
    public float getUpDownRatio(MetaInfo metainfo, PeerCoordinator coordinator){
        
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        if (_config.containsKey(PROP_UMETA_PREFIX + infohash) && _config.containsKey(PROP_DMETA_PREFIX + infohash)){
            long oldup = Long.valueOf(_config.getProperty(PROP_UMETA_PREFIX + infohash )).longValue();
            long olddown = Long.valueOf(_config.getProperty(PROP_DMETA_PREFIX + infohash )).longValue();
            //;amount < metainfo.getPieceLength(0) causes weird values
            if(oldup <= metainfo.getPieceLength(0) && olddown <= metainfo.getPieceLength(0))return -1f;
            if(oldup <= metainfo.getPieceLength(0) )return -1f;
            if(olddown <= 0 && coordinator != null && coordinator.isCompleted()){// a firstseed? show ratio
                olddown = metainfo.getTotalLength(); // show at least a ratio for the firstseeder
            } else if(olddown <= metainfo.getPieceLength(0))return -1f;
            
            float udRatio = ((float)((float) oldup / olddown));
            if(udRatio >= 0.001f)
                return udRatio;
        }
        return -1f;
    }
    
    public void resetTorrentToStoredAmount(PeerCoordinator coordinator, boolean sessionstart) {
        if(coordinator == null)return;
        byte[] ih = coordinator.metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        if (_config.containsKey(PROP_UDMETA_PREFIX + infohash) && _config.containsKey(PROP_UMETA_PREFIX + infohash) && _config.containsKey(PROP_DMETA_PREFIX + infohash)){
            long oldup = Long.valueOf(_config.getProperty(PROP_UMETA_PREFIX + infohash )).longValue();
            long olddown = Long.valueOf(_config.getProperty(PROP_DMETA_PREFIX + infohash )).longValue();
            String oldhash = _config.getProperty(PROP_UDMETA_PREFIX + infohash );
            //to avoid of faking just a simple md5 hash
            String newhash = calcMD5("" + PROP_META_PREFIX + infohash + "" + oldup + "" + olddown);
            if(oldhash.equals(newhash)){
                //System.out.println(getNickname() + " hash for amount matches: starting torrent with stored amount " + newhash + " " + coordinator.metainfo.getName());
                coordinator.setUploadedSavedByStatus(oldup);
                coordinator.setDownloadedSavedByStatus(olddown);
                coordinator.setUploadedToStoredAmount(oldup);
                coordinator.setDownloadedToStoredAmount(olddown);
                coordinator.setResetAmount(true);
                if(sessionstart){
                    coordinator.setStoredAmountSessionStart(oldup,olddown);
                }
                addMessage("hash for amount matches: starting torrent with stored amount " + " " + coordinator.metainfo.getName());
            }else{
                coordinator.setResetAmount(false);
                _config.remove(PROP_UMETA_PREFIX + infohash);
                _config.remove(PROP_DMETA_PREFIX + infohash);
                _config.remove(PROP_UDMETA_PREFIX + infohash);
                Snark snark_todo = getTorrentByMetaInfoHash(infohash);
                saveTorrentStatus(coordinator.metainfo,snark_todo.storage.getBitField());
                //System.out.println(getNickname() + " hash not matches. removing keys for stored amount: " + newhash + " " + coordinator.metainfo.getName());
                addMessage("hash of keys not matches. removing keys for stored amount: " + " " + coordinator.metainfo.getName());
            }
        }else{
            coordinator.setResetAmount(false);
            _config.remove(PROP_UMETA_PREFIX + infohash);
            _config.remove(PROP_DMETA_PREFIX + infohash);
            _config.remove(PROP_UDMETA_PREFIX + infohash);
            Snark snark_todo = getTorrentByMetaInfoHash(infohash);
            saveTorrentStatus(coordinator.metainfo,snark_todo.storage.getBitField());
            //System.out.println(getNickname() + "Missing key for amount, cleaning amount keys : " + coordinator.metainfo.getName());
            addMessage("Missing key for amount, cleaning keys for stored amount: " + coordinator.metainfo.getName());
            
        }
    }
    
    private void cleanAmountFake(MetaInfo metainfo){
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        if (_config.containsKey(PROP_UDMETA_PREFIX + infohash) && _config.containsKey(PROP_UMETA_PREFIX + infohash) && _config.containsKey(PROP_DMETA_PREFIX + infohash)){
            long oldup = Long.valueOf(_config.getProperty(PROP_UMETA_PREFIX + infohash )).longValue();
            long olddown = Long.valueOf(_config.getProperty(PROP_DMETA_PREFIX + infohash )).longValue();
            String oldhash = _config.getProperty(PROP_UDMETA_PREFIX + infohash );
            //to avoid of faking just a simple md5 hash
            String newhash = calcMD5("" + PROP_META_PREFIX + infohash + "" + oldup + "" + olddown);
            if(oldhash.equals(newhash)){
                addMessage("hash for amount matches: " + " " + metainfo.getName());
            }else{
                _config.remove(PROP_UMETA_PREFIX + infohash);
                _config.remove(PROP_DMETA_PREFIX + infohash);
                _config.remove(PROP_UDMETA_PREFIX + infohash);
                
                addMessage("hash of keys not matches. cleaning keys for stored amount: " + " " + metainfo.getName());
            }
        }else{
            _config.remove(PROP_UMETA_PREFIX + infohash);
            _config.remove(PROP_DMETA_PREFIX + infohash);
            _config.remove(PROP_UDMETA_PREFIX + infohash);
            addMessage("Missing key for amount, cleaning keys for stored amount: " + metainfo.getName());
        }
    }
    /**
     * Save the completion status of a torrent and the current time in the config file
     * in the form "i2psnark.zmeta.$base64infohash=$time,$base64bitfield".
     * The config file property key is appended with the Base64 of the infohash,
     * with the '=' changed to '$' since a key can't contain '='.
     * The time is a standard long converted to string.
     * The status is either a bitfield converted to Base64 or "." for a completed
     * torrent to save space in the config file and in memory.
     */
    public boolean configContainsKey(String key){
        return _config.containsKey(key) ;
    }
    
     public void setSelectedCategory(String val){
        _category = val;        
    }
    public String getSelectedCategory(){
        return _category;
    }
    
    public synchronized void saveTorrentCategoryStatus(MetaInfo metainfo, String category) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        _config.setProperty(PROP_CMETA_PREFIX + infohash, category);
        saveConfig(_configFile,_config);
    }
    public synchronized void saveTorrentStatus(MetaInfo metainfo, BitField bitfield) {
        boolean isNewFile;
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String now = "" + System.currentTimeMillis();
        String bfs;
        if (bitfield.complete()) {
            bfs = ".";
        } else {
            byte[] bf = bitfield.getFieldBytes();
            bfs = Base64.encode(bf);
        }
        if (!_config.containsKey(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX) )
            isNewFile = true;
        else
            isNewFile = false;
        
        _config.setProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX, now + "," + bfs);
        
        //--------------------------------------------- new 201009xx
        //todo keep a eye
        /*
         * experimental
         *
         **/
        String metainfohash_todo = Base64.encode(metainfo.getInfoHash()) ;
        Snark snark_todo = getTorrentByMetaInfoHash(metainfohash_todo);
        
        //--------------------->
        // uploaded key
        
        
        if(snark_todo != null && !snark_todo.checkedAmountFake){
            cleanAmountFake(metainfo);
            snark_todo.checkedAmountFake = true;
        }
        
        /*
         * firstSeedUseRatioOneToOne if true than the tracker announce the (wrong) restored up/download amount when resetTorrentToStoredAmount() is used!
         * means the firstseeder starts with a displayed amount of up/download by filesize on the trackerpage
         * else firstSeedUseRatioOneToOne = false: the ratio for this torrent is 'NaN'
         * firstSeedUseRatioOneToOne = true: the ratio for this torrent is '1.0'
         */
        boolean firstSeedUseRatioOneToOne = false;
        
        if (snark_todo != null && !_config.containsKey(PROP_UMETA_PREFIX + infohash) && snark_todo.storage != null && snark_todo.storage.complete() && firstSeedUseRatioOneToOne)
            _config.setProperty(PROP_UMETA_PREFIX + infohash,  "" + metainfo.getTotalLength());// first seed// for ratio 1.0 add filesize
        else if (!_config.containsKey(PROP_UMETA_PREFIX + infohash))
            _config.setProperty(PROP_UMETA_PREFIX + infohash, "0");
        
        // downloaded key
        if (snark_todo != null && !_config.containsKey(PROP_DMETA_PREFIX + infohash) && snark_todo.storage != null && snark_todo.storage.complete() && firstSeedUseRatioOneToOne)
            _config.setProperty(PROP_DMETA_PREFIX + infohash, "" + metainfo.getTotalLength());// first seed// for ratio 1.0 add filesize
        else if (!_config.containsKey(PROP_DMETA_PREFIX + infohash))
            _config.setProperty(PROP_DMETA_PREFIX + infohash, "0" );
        //<----------------------
        
        long oldup = Long.valueOf(_config.getProperty(PROP_UMETA_PREFIX + infohash )).longValue();
        long olddown = Long.valueOf(_config.getProperty(PROP_DMETA_PREFIX + infohash )).longValue();
        
        if(snark_todo != null && snark_todo.coordinator != null){
            if(isNewFile){//for some misc circumstances a new created file has sometimes a previous setting of up/download amount (up to 10mb's !) //todo find out why!
                snark_todo.coordinator.setUploadedSavedByStatus(0);
                snark_todo.coordinator.setDownloadedSavedByStatus(0);
                snark_todo.coordinator.setUploadedToStoredAmount(0);
                snark_todo.coordinator.setDownloadedToStoredAmount(0);
                _config.setProperty(PROP_UMETA_PREFIX + infohash, "0");
                _config.setProperty(PROP_DMETA_PREFIX + infohash, "0" );
                String hash = calcMD5("" + PROP_META_PREFIX + infohash + "" + 0 + "" + 0);
                _config.setProperty(PROP_UDMETA_PREFIX + infohash , ""+  hash);
                //System.out.println("save status for newfile " + metainfo.getName() + " : up " + 0 + " (+" + snark_todo.coordinator.getUploaded() + ") down " + 0 + " (+" + snark_todo.coordinator.getDownloaded() + ")" );
                
            }else{
                long sinceLastSavedUploaded = snark_todo.coordinator.getUploadedSavedByStatus();
                long sinceLastSavedDownloaded = snark_todo.coordinator.getDownloadedSavedByStatus();
                
                long newSavedUploaded = snark_todo.coordinator.getUploaded() - sinceLastSavedUploaded;
                long newSavedDownloaded = snark_todo.coordinator.getDownloaded() - sinceLastSavedDownloaded;
                
                long uploadedEver = oldup + newSavedUploaded;
                long downloadedEver = olddown + newSavedDownloaded;
                
                _config.setProperty(PROP_UMETA_PREFIX + infohash , "" + uploadedEver);
                _config.setProperty(PROP_DMETA_PREFIX + infohash , "" +  downloadedEver);
                
                //to avoid of faking just a simple md5 hash
                String hash = calcMD5("" + PROP_META_PREFIX + infohash + "" + uploadedEver + "" + downloadedEver);
                _config.setProperty(PROP_UDMETA_PREFIX + infohash , ""+  hash);
                
                snark_todo.coordinator.setUploadedSavedByStatus(sinceLastSavedUploaded + newSavedUploaded);
                snark_todo.coordinator.setDownloadedSavedByStatus(sinceLastSavedDownloaded + newSavedDownloaded);
                //
                
                //System.out.println("save status for " + metainfo.getName() + " : up " + uploadedEver + " (+" + newSavedUploaded + ") down " + downloadedEver + " (+" + newSavedDownloaded + ")" );
            }
        }
        //--------------------------------------------- new end
        
        saveConfig(_configFile,_config);
        //--------------------------------------------- new 201009xx
        //todo keep a eye
        /*
         * experimental
         *
         **/
        //finally to get not worst values after saving the config: reset the values for up and down
        // -- _config.setProperty(PROP_UMETA_PREFIX + infohash , "" + oldup);
        // -- _config.setProperty(PROP_DMETA_PREFIX + infohash , "" +  olddown);
        //--------------------------------------------- new end
        
        //xl swarm
        if (bitfield.complete()) {
            String metainfohash = Base64.encode(metainfo.getInfoHash()) ;
            Snark snark = getTorrentByMetaInfoHash(metainfohash);
            if(snark != null){
                File torrent = new File(snark.torrent);
                //try{
                if(_config_swarm != null && isSwarmLeader() && isSwarmDir(torrent)){
                    _config_swarm.setProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX, now + "," + bfs);
                    saveConfig(_configFile_swarm,_config_swarm);
                }else{
                    //System.out.println("_config_swarm: " + (_config_swarm != null ? "true" : "false"));
                    //System.out.println("is leader: " + isSwarmLeader());
                    //System.out.println("is swarm dir: " + torrent.getParent() +  " | " + getSwarmDir().getCanonicalPath() + " " +  isSwarmDir(torrent));
                }
            }
            //} catch(IOException ioe) {
            //    _log.error("Error  " + ioe);
            //    _messages.add("Error " + ioe);
            //}
        }
    }
    
    public static String calcMD5(String data) {
        try {
            synchronized (md5) {
                md5.reset();
                md5.update(data.getBytes("ISO-8859-1"));
                return bytesToHex(md5.digest());
            }
        } catch (UnsupportedEncodingException e) {
            //e=null;
            //_log.error("UnsupportedEncodingException 643 " + e);
            return null;
        }
    }
    
    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            int c = bytes[i] & 0xff;
            sb.append(c < 0x10 ? "0" : "").append(Integer.toHexString(c));
        }
        return sb.toString();
    }
    
    public int getSwarmLeaderPort(){
        if (_config_swarm != null && _config_swarm.containsKey(PROP_LEADER_EEP_PORT)){
            int port;
            try {
                String eepPort = _config_swarm.getProperty(PROP_LEADER_EEP_PORT);
                port = Integer.parseInt(eepPort);
                return port;
            } catch (NumberFormatException nfe) {return -1;}
        }else
            return -1;
        
    }
    public boolean isSwarmLeader(){
        try{
            if(_config_swarm != null)
                return (_config_swarm.getProperty(PROP_SWARM_LEADER).equalsIgnoreCase(nickname) ? true : false);
            else
                return false;
        }catch (Exception e){
            //e.printStackTrace();
            return false;
        }
    }
    
    public String getSwarmLeader(){
        try{
            return _config_swarm.getProperty(PROP_SWARM_LEADER) ;
        }catch (Exception e){
            //e.printStackTrace();
            return "NONE";
        }
    }
    public boolean isSwarmDir(File f){
        try{
            return (f.getParent().equalsIgnoreCase(getSwarmDir().getCanonicalPath()) ? true : false);
        } catch(IOException ioe) {
            //ioe.printStackTrace();
            return false;
        }
    }
    
    public boolean isSwarmUnit(){
        if(getSwarmDir().getName().equalsIgnoreCase("NONE") || getSwarmDir().getName().equalsIgnoreCase("UNSET")){
            return false;
        } else return true;
    }
    public boolean isDataDir(File f){
        try{
            return (f.getParent().equalsIgnoreCase(getDataDir().getCanonicalPath()) ? true : false);
        } catch(IOException ioe) {
            //ioe.printStackTrace();
            return false;
        }
    }
    /**
     * Remove the status of a torrent from the config file.
     * This may help the config file from growing too big.
     */
    public synchronized void removeTorrentStatus(MetaInfo metainfo) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        _config.remove(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        _config.remove(PROP_UMETA_PREFIX + infohash);
        _config.remove(PROP_DMETA_PREFIX + infohash);
        _config.remove(PROP_UDMETA_PREFIX + infohash);
        _config.remove(PROP_CMETA_PREFIX + infohash);
        saveConfig(_configFile,_config);
        //-----swarm
        if(_config_swarm != null && _config_swarm.containsKey(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX)){
            _config_swarm.remove(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        } else if(_config_swarm == null)initSwarmConfig();
        if(_config_swarm != null && isSwarmLeader()){
            saveConfig(_configFile_swarm,_config_swarm);
        }
    }
    
    private String locked_validateTorrent(MetaInfo info) throws IOException {
        String announce = info.getAnnounce();
        // basic validation of url
        if ((!announce.startsWith("http://")) ||
                (announce.indexOf(".i2p/") < 0))
            return "Non-i2p tracker in " + info.getName() + ", deleting it";
        List files = info.getFiles();
        if ( (files != null) && (files.size() > MAX_FILES_PER_TORRENT && MAX_FILES_PER_TORRENT > 0) ) {
            return "Too many files in " + info.getName() + " (" + files.size() + "), deleting it";
        } else if (info.getPieces() <= 0) {
            return "No pieces in " + info.getName() + "?  deleting it";
        } else if (info.getPieceLength(0) > 8*1024*1024) {
            return "Pieces are too large in " + info.getName() + " (" + info.getPieceLength(0)/1024 + "KB), deleting it";
        } else if (info.getTotalLength() > 100*1024*1024*1024l) {
            System.out.println("torrent info: " + info.toString());
            List lengths = info.getLengths();
            if (lengths != null)
                for (int i = 0; i < lengths.size(); i++)
                    System.out.println("File " + i + " is " + lengths.get(i) + " long");
            
            return "Torrents larger than 100GB are not supported yet (because we're paranoid): " + info.getName() + ", deleting it";
        } else {
            // ok
            return null;
        }
    }
    
    /**
     * Stop the torrent, leaving it on the list of torrents unless told to remove it
     */
    public Snark stopTorrent(String filename, boolean shouldRemove) {
        File sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        } catch (IOException ioe) {
            _log.error("Unable to remove the torrent " + filename, ioe);
            addMessage("ERR: Could not remove the torrent '" + filename + "': " + ioe.getMessage());
            return null;
        }
        int remaining = 0;
        Snark torrent = null;
        synchronized (_addSnarkLock) {
            synchronized (_snarks) {
                if (shouldRemove){
                    torrent = (Snark)_snarks.remove(filename);
                }else
                    torrent = (Snark)_snarks.get(filename);
                remaining = _snarks.size();
            }
        }
        if (torrent != null) {
            boolean wasStopped = torrent.stopped;
            torrent.stopTorrent();
            if (remaining == 0) {
                // should we disconnect/reconnect here (taking care to deal with the other thread's
                // I2PServerSocket.accept() call properly?)
                ////I2PSnarkUtil.instance().
            }
            if (!wasStopped)
                addMessage("Torrent stopped: '" + sfile.getName() + "'");
            
            //fwd cleanup zmetas too
            if (shouldRemove && torrent.storage != null)
                removeTorrentStatus(torrent.storage.getMetaInfo());
        }
        return torrent;
    }
    /**
     * Stop the torrent and delete the torrent file itself, but leaving the data
     * behind.
     */
    public void removeTorrent(String filename) {
        Snark torrent = stopTorrent(filename, false);
        if (torrent != null) {
            synchronized (_addSnarkLock) {
                synchronized (_snarks) {
                    File torrentFile = new File(torrent.torrent);
                    
                    if (torrent.storage != null && torrentFile.exists()){
                        removeTorrentStatus(torrent.storage.getMetaInfo());
                        try{
                            torrent.storage.close();
                            if( (isSwarmLeader() && isSwarmDir(torrentFile)) ){
                                torrentFile.delete();
                            }else if( !isSwarmDir(torrentFile) ){
                                torrentFile.delete();
                            }
                        }catch (IOException ioe) {
                            _log.error("Unable to remove the torrent " + filename, ioe);
                            addMessage("ERR: Could not remove the torrent '" + filename + "': " + ioe.getMessage());
                            return;
                        }
                    }else{
                        if(torrentFile.exists()){
                            if( (isSwarmLeader() && isSwarmDir(torrentFile)) ){
                                torrentFile.delete();
                            }else if( !isSwarmDir(torrentFile) ){
                                torrentFile.delete();
                            }
                            //addMessage("Torrent removing failt: '" + filename + "'");
                        }
                    }
                    if(torrentFile.exists()){
                        addMessage("Torrent removing failt: '" + filename + "'");
                    }else{
                        _snarks.remove(filename);
                        addMessage("Torrent removed: '" + filename + "'");
                    }
                }
            }
            
        }else{
            System.out.println("removeTorrent is null: " + filename );
        }
    }
    
    private class DirMonitor implements Runnable {
        public void run() {
            try {
                // do not run before the current config is set!
                while(!xlServletInit){
                    Thread.sleep(1*1000);
                }
                Thread.sleep(3*1000);// give a bit time to read and init the config (just in case getStartupDelayMinutes() == 0)
            } catch (InterruptedException ie) {}
            
            try { Thread.sleep(60*1000*getStartupDelayMinutes()); } catch (InterruptedException ie) {}
            // the first message was a "We are starting up in 1m"
            synchronized (_messages) {
                if (_messages.size() == 1)
                    _messages.remove(0);
            }
            int loop = 0;
            while (true) {
                File dir = getDataDir();
                _log.debug("Directory Monitor loop over " + dir.getAbsolutePath());
                try {
                    monitorTorrents(dir);
                    //fwd xl-swarm --------------------->
                    if(true && loop == 2){//common; only every 3 minutes (starts with 0)
                        
                        if(initSwarmConfig()) {
                            monitorTorrents(getSwarmDir());
                            //System.out.println("swarm directory : " +  getSwarmDir().getAbsolutePath() + " _config_swarm : " + _config_swarm + " Leader : " + _config_swarm.getProperty(PROP_SWARM_LEADER));
                        }else{
                            //System.out.println("swarm directory : " +  getSwarmDir().getAbsolutePath() + " _config_swarm : " + _config_swarm);
                        }
                        
                        //System.out.println("swarm directory : " + getSwarmDir().getAbsolutePath());
                        
                    }
                    //fwd xl-swarm <---------------------
                } catch (Exception e) {
                    _log.error("Error in the DirectoryMonitor", e);
                }
                try { Thread.sleep(60*1000); } catch (InterruptedException ie) {}
                loop++;
                if(loop > 2)loop = 0;
            }
        }
    }
    
    public void torrentComplete(Snark snark) {
        File f = new File(snark.torrent);
        long len = snark.meta.getTotalLength();
        addMessage("Download complete of " + f.getName()
        + (len < 5*1024*1024 ? " (size: " + (len/1024) + "KB)" : " (size: " + (len/(1024*1024l)) + "MB)"));
    }
    
    private void monitorTorrents(File dir) {
        String fileNames[] = dir.list(TorrentFilenameFilter.instance());
        List foundNames = new ArrayList(0);
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; i++) {
                try {
                    foundNames.add(new File(dir, fileNames[i]).getCanonicalPath());
                } catch (IOException ioe) {
                    _log.error("Error resolving '" + fileNames[i] + "' in '" + dir, ioe);
                }
            }
        }
        
        Set existingNames = listTorrentFiles();
        // lets find new ones first...
        for (int i = 0; i < foundNames.size(); i++) {
            if (existingNames.contains(foundNames.get(i))) {
                // already known.  noop
                //} else if (existingNames.contains(dir + File.pathSeparator + foundNames.get(i))) {
                // already known.  noop
            } else {
                if (shouldAutoStart() && !I2PSnarkUtil.instance().connect())
                    addMessage("Unable to connect to I2P");
                //if( isDataDir(dir) || (isSwarmDir(dir) && isSwarmLeader()) || (isSwarmDir(dir) && ))
                addTorrent((String)foundNames.get(i), !shouldAutoStart());
            }
        }
        // now lets see which ones have been removed...
        for (Iterator iter = existingNames.iterator(); iter.hasNext(); ) {
            String name = (String)iter.next();
            if (foundNames.contains(name)) {
                // known and still there.  noop
            } else {
                // known, but removed.  drop it
                File f = new File(name);
                if(!f.exists() ){// fwd
                    //stopTorrent(name, true);
                    removeTorrent(name);
                }else{
                    // try{
                    if(!isSwarmDir(f) && !isDataDir(f)){// fwd
                        stopTorrent(name, true);
                    }
                    /*} catch(IOException ioe) {
                        _log.error("Error  " + ioe);
                        _messages.add("Error " + ioe);
                    }*/
                }
                
            }
        }
    }
    
    private static final String DEFAULT_TRACKERS[] = {
        // "Postman", "http://YRgrgTLGnbTq2aZOZDJQ~o6Uk5k6TK-OZtx0St9pb0G-5EGYURZioxqYG8AQt~LgyyI~NCj6aYWpPO-150RcEvsfgXLR~CxkkZcVpgt6pns8SRc3Bi-QSAkXpJtloapRGcQfzTtwllokbdC-aMGpeDOjYLd8b5V9Im8wdCHYy7LRFxhEtGb~RL55DA8aYOgEXcTpr6RPPywbV~Qf3q5UK55el6Kex-6VCxreUnPEe4hmTAbqZNR7Fm0hpCiHKGoToRcygafpFqDw5frLXToYiqs9d4liyVB-BcOb0ihORbo0nS3CLmAwZGvdAP8BZ7cIYE3Z9IU9D1G8JCMxWarfKX1pix~6pIA-sp1gKlL1HhYhPMxwyxvuSqx34o3BqU7vdTYwWiLpGM~zU1~j9rHL7x60pVuYaXcFQDR4-QVy26b6Pt6BlAZoFmHhPcAuWfu-SFhjyZYsqzmEmHeYdAwa~HojSbofg0TMUgESRXMw6YThK1KXWeeJVeztGTz25sL8AAAA.i2p/announce.php=http://tracker.postman.i2p/"
        "PaTracker", "http://lnQ6yoBTxQuQU8EQ1FlF395ITIQF-HGJxUeFvzETLFnoczNjQvKDbtSB7aHhn853zjVXrJBgwlB9sO57KakBDaJ50lUZgVPhjlI19TgJ-CxyHhHSCeKx5JzURdEW-ucdONMynr-b2zwhsx8VQCJwCEkARvt21YkOyQDaB9IdV8aTAmP~PUJQxRwceaTMn96FcVenwdXqleE16fI8CVFOV18jbJKrhTOYpTtcZKV4l1wNYBDwKgwPx5c0kcrRzFyw5~bjuAKO~GJ5dR7BQsL7AwBoQUS4k1lwoYrG1kOIBeDD3XF8BWb6K3GOOoyjc1umYKpur3G~FxBuqtHAsDRICkEbKUqJ9mPYQlTSujhNxiRIW-oLwMtvayCFci99oX8MvazPS7~97x0Gsm-onEK1Td9nBdmq30OqDxpRtXBimbzkLbR1IKObbg9HvrKs3L-kSyGwTUmHG9rSQSoZEvFMA-S0EXO~o4g21q1oikmxPMhkeVwQ22VHB0-LZJfmLr4SAAAA.i2p/announce.php=http://tracker2.postman.i2p/"
                //, "gchan", "http://KhdjkFvAVZzpOPWia6jWIvDOTx4hrCsN4j41RcmHSyXIADn3WRtFqWEwXXTK-1HljFgddsqERymEf7KyHXYH7TJgOLpcpzjP6QWzfoPejZNjgGS3Vh63tZlqsb5MmUQnGQ40YXoELOhBFbzhNttfIWF-lq13dRakdKAIL7g1WlJF6PJAZ9i0VBbgokbLiwiqrkdtc9XJCgMksHxA5w~VkECx7p4Sw5MDaYfjEqUtwODT-zGBqnIr3ICROkv7yG9ZFrGX-7~tid8EG2jlMslXW~IFSi11MDghS7z9N5uuH~S-5gJ4P0kdXiA~md3yuEEp3shLg~n3n4pcW9nZyRPd1VYkkiKhLs4rkFwq0vrn1rpsk8dVeYZQsGVgEoAJVJrXzbe3diylhgQYqhYGo4hNHuMJFhAoqLGr-pZMHEJchGvX5Ab5b8ahUDUxQi~T9Ls5BEqXKQ-J6nRRQNh6lzT9wiGohZNWYILzFywPOMy0eVTxIQfJueRwQOjxkyV7HbJDAAAA.i2p/tracker/announce.php=http://gchan.i2p/tracker/"
                //       , "eBook", "http://E71FRom6PZNEqTN2Lr8P-sr23b7HJVC32KoGnVQjaX6zJiXwhJy2HsXob36Qmj81TYFZdewFZa9mSJ533UZgGyQkXo2ahctg82JKYZfDe5uDxAn1E9YPjxZCWJaFJh0S~UwSs~9AZ7UcauSJIoNtpxrtbmRNVFLqnkEDdLZi26TeucfOmiFmIWnVblLniWv3tG1boE9Abd-6j3FmYVrRucYuepAILYt6katmVNOk6sXmno1Eynrp~~MBuFq0Ko6~jsc2E2CRVYXDhGHEMdt-j6JUz5D7S2RIVzDRqQyAZLKJ7OdQDmI31przzmne1vOqqqLC~1xUumZVIvF~yOeJUGNjJ1Vx0J8i2BQIusn1pQJ6UCB~ZtZZLQtEb8EPVCfpeRi2ri1M5CyOuxN0V5ekmPHrYIBNevuTCRC26NP7ZS5VDgx1~NaC3A-CzJAE6f1QXi0wMI9aywNG5KGzOPifcsih8eyGyytvgLtrZtV7ykzYpPCS-rDfITncpn5hliPUAAAA.i2p/pub/bt/announce.php=http://de-ebook-archiv.i2p/pub/bt/"
                //       , "Gaytorrents", "http://uxPWHbK1OIj9HxquaXuhMiIvi21iK0~ZiG9d8G0840ZXIg0r6CbiV71xlsqmdnU6wm0T2LySriM0doW2gUigo-5BNkUquHwOjLROiETnB3ZR0Ml4IGa6QBPn1aAq2d9~g1r1nVjLE~pcFnXB~cNNS7kIhX1d6nLgYVZf0C2cZopEow2iWVUggGGnAA9mHjE86zLEnTvAyhbAMTqDQJhEuLa0ZYSORqzJDMkQt90MV4YMjX1ICY6RfUSFmxEqu0yWTrkHsTtRw48l~dz9wpIgc0a0T9C~eeWvmBFTqlJPtQZwntpNeH~jF7nlYzB58olgV2HHFYpVYD87DYNzTnmNWxCJ5AfDorm6AIUCV2qaE7tZtI1h6fbmGpGlPyW~Kw5GXrRfJwNvr6ajwAVi~bPVnrBwDZezHkfW4slOO8FACPR28EQvaTu9nwhAbqESxV2hCTq6vQSGjuxHeOuzBOEvRWkLKOHWTC09t2DbJ94FSqETmZopTB1ukEmaxRWbKSIaAAAA.i2p/announce.php=http://gaytorrents.i2p/"
                //       , "NickyB", "http://9On6d3cZ27JjwYCtyJJbowe054d5tFnfMjv4PHsYs-EQn4Y4mk2zRixatvuAyXz2MmRfXG-NAUfhKr0KCxRNZbvHmlckYfT-WBzwwpiMAl0wDFY~Pl8cqXuhfikSG5WrqdPfDNNIBuuznS0dqaczf~OyVaoEOpvuP3qV6wKqbSSLpjOwwAaQPHjlRtNIW8-EtUZp-I0LT45HSoowp~6b7zYmpIyoATvIP~sT0g0MTrczWhbVTUZnEkZeLhOR0Duw1-IRXI2KHPbA24wLO9LdpKKUXed05RTz0QklW5ROgR6TYv7aXFufX8kC0-DaKvQ5JKG~h8lcoHvm1RCzNqVE-2aiZnO2xH08H-iCWoLNJE-Td2kT-Tsc~3QdQcnEUcL5BF-VT~QYRld2--9r0gfGl-yDrJZrlrihHGr5J7ImahelNn9PpkVp6eIyABRmJHf2iicrk3CtjeG1j9OgTSwaNmEpUpn4aN7Kx0zNLdH7z6uTgCGD9Kmh1MFYrsoNlTp4AAAA.i2p/bittorrent/announce.php=http://nickyb.i2p/bittorrent/"
                //       , "Orion", "http://gKik1lMlRmuroXVGTZ~7v4Vez3L3ZSpddrGZBrxVriosCQf7iHu6CIk8t15BKsj~P0JJpxrofeuxtm7SCUAJEr0AIYSYw8XOmp35UfcRPQWyb1LsxUkMT4WqxAT3s1ClIICWlBu5An~q-Mm0VFlrYLIPBWlUFnfPR7jZ9uP5ZMSzTKSMYUWao3ejiykr~mtEmyls6g-ZbgKZawa9II4zjOy-hdxHgP-eXMDseFsrym4Gpxvy~3Fv9TuiSqhpgm~UeTo5YBfxn6~TahKtE~~sdCiSydqmKBhxAQ7uT9lda7xt96SS09OYMsIWxLeQUWhns-C~FjJPp1D~IuTrUpAFcVEGVL-BRMmdWbfOJEcWPZ~CBCQSO~VkuN1ebvIOr9JBerFMZSxZtFl8JwcrjCIBxeKPBmfh~xYh16BJm1BBBmN1fp2DKmZ2jBNkAmnUbjQOqWvUcehrykWk5lZbE7bjJMDFH48v3SXwRuDBiHZmSbsTY6zhGY~GkMQHNGxPMMSIAAAA.i2p/bt/announce.php=http://orion.i2p/bt/"
                //       , "anonymity", "http://8EoJZIKrWgGuDrxA3nRJs1jsPfiGwmFWL91hBrf0HA7oKhEvAna4Ocx47VLUR9retVEYBAyWFK-eZTPcvhnz9XffBEiJQQ~kFSCqb1fV6IfPiV3HySqi9U5Caf6~hC46fRd~vYnxmaBLICT3N160cxBETqH3v2rdxdJpvYt8q4nMk9LUeVXq7zqCTFLLG5ig1uKgNzBGe58iNcsvTEYlnbYcE930ABmrzj8G1qQSgSwJ6wx3tUQNl1z~4wSOUMan~raZQD60lRK70GISjoX0-D0Po9WmPveN3ES3g72TIET3zc3WPdK2~lgmKGIs8GgNLES1cXTolvbPhdZK1gxddRMbJl6Y6IPFyQ9o4-6Rt3Lp-RMRWZ2TG7j2OMcNSiOmATUhKEFBDfv-~SODDyopGBmfeLw16F4NnYednvn4qP10dyMHcUASU6Zag4mfc2-WivrOqeWhD16fVAh8MoDpIIT~0r9XmwdaVFyLcjbXObabJczxCAW3fodQUnvuSkwzAAAA.i2p/anonymityTracker/announce.php=http://anonymityweb.i2p/anonymityTracker/"
                //       , "The freak's tracker", "http://mHKva9x24E5Ygfey2llR1KyQHv5f8hhMpDMwJDg1U-hABpJ2NrQJd6azirdfaR0OKt4jDlmP2o4Qx0H598~AteyD~RJU~xcWYdcOE0dmJ2e9Y8-HY51ie0B1yD9FtIV72ZI-V3TzFDcs6nkdX9b81DwrAwwFzx0EfNvK1GLVWl59Ow85muoRTBA1q8SsZImxdyZ-TApTVlMYIQbdI4iQRwU9OmmtefrCe~ZOf4UBS9-KvNIqUL0XeBSqm0OU1jq-D10Ykg6KfqvuPnBYT1BYHFDQJXW5DdPKwcaQE4MtAdSGmj1epDoaEBUa9btQlFsM2l9Cyn1hzxqNWXELmx8dRlomQLlV4b586dRzW~fLlOPIGC13ntPXogvYvHVyEyptXkv890jC7DZNHyxZd5cyrKC36r9huKvhQAmNABT2Y~pOGwVrb~RpPwT0tBuPZ3lHYhBFYmD8y~AOhhNHKMLzea1rfwTvovBMByDdFps54gMN1mX4MbCGT4w70vIopS9yAAAA.i2p/bytemonsoon/announce.php"
                , "welterde", "http://BGKmlDOoH3RzFbPRfRpZV2FjpVj8~3moFftw5-dZfDf2070TOe8Tf2~DAVeaM6ZRLdmFEt~9wyFL8YMLMoLoiwGEH6IGW6rc45tstN68KsBDWZqkTohV1q9XFgK9JnCwE~Oi89xLBHsLMTHOabowWM6dkC8nI6QqJC2JODqLPIRfOVrDdkjLwtCrsckzLybNdFmgfoqF05UITDyczPsFVaHtpF1sRggOVmdvCM66otyonlzNcJbn59PA-R808vUrCPMGU~O9Wys0i-NoqtIbtWfOKnjCRFMNw5ex4n9m5Sxm9e20UkpKG6qzEuvKZWi8vTLe1NW~CBrj~vG7I3Ok4wybUFflBFOaBabxYJLlx4xTE1zJIVxlsekmAjckB4v-cQwulFeikR4LxPQ6mCQknW2HZ4JQIq6hL9AMabxjOlYnzh7kjOfRGkck8YgeozcyTvcDUcUsOuSTk06L4kdrv8h2Cozjbloi5zl6KTbj5ZTciKCxi73Pn9grICn-HQqEAAAA.i2p/a=http://tracker.welterde.i2p/stats?mode=top5"
                //       , "mastertracker", "http://VzXD~stRKbL3MOmeTn1iaCQ0CFyTmuFHiKYyo0Rd~dFPZFCYH-22rT8JD7i-C2xzYFa4jT5U2aqHzHI-Jre4HL3Ri5hFtZrLk2ax3ji7Qfb6qPnuYkuiF2E2UDmKUOppI8d9Ye7tjdhQVCy0izn55tBaB-U7UWdcvSK2i85sauyw3G0Gfads1Rvy5-CAe2paqyYATcDmGjpUNLoxbfv9KH1KmwRTNH6k1v4PyWYYnhbT39WfKMbBjSxVQRdi19cyJrULSWhjxaQfJHeWx5Z8Ev4bSPByBeQBFl2~4vqy0S5RypINsRSa3MZdbiAAyn5tr5slWR6QdoqY3qBQgBJFZppy-3iWkFqqKgSxCPundF8gdDLC5ddizl~KYcYKl42y9SGFHIukH-TZs8~em0~iahzsqWVRks3zRG~tlBcX2U3M2~OJs~C33-NKhyfZT7-XFBREvb8Szmd~p66jDxrwOnKaku-G6DyoQipJqIz4VHmY9-y5T8RrUcJcM-5lVoMpAAAA.i2p/announce.php=http://tracker.mastertracker.i2p/"
                //       , "Galen", "http://5jpwQMI5FT303YwKa5Rd38PYSX04pbIKgTaKQsWbqoWjIfoancFdWCShXHLI5G5ofOb0Xu11vl2VEMyPsg1jUFYSVnu4-VfMe3y4TKTR6DTpetWrnmEK6m2UXh91J5DZJAKlgmO7UdsFlBkQfR2rY853-DfbJtQIFl91tbsmjcA5CGQi4VxMFyIkBzv-pCsuLQiZqOwWasTlnzey8GcDAPG1LDcvfflGV~6F5no9mnuisZPteZKlrv~~TDoXTj74QjByWc4EOYlwqK8sbU9aOvz~s31XzErbPTfwiawiaZ0RUI-IDrKgyvmj0neuFTWgjRGVTH8bz7cBZIc3viy6ioD-eMQOrXaQL0TCWZUelRwHRvgdPiQrxdYQs7ixkajeHzxi-Pq0EMm5Vbh3j3Q9kfUFW3JjFDA-MLB4g6XnjCbM5J1rC0oOBDCIEfhQkszru5cyLjHiZ5yeA0VThgu~c7xKHybv~OMXION7V8pBKOgET7ZgAkw1xgYe3Kkyq5syAAAA.i2p/tr/announce.php=http://galen.i2p/tr/"
                , "crstrack", "http://b4G9sCdtfvccMAXh~SaZrPqVQNyGQbhbYMbw6supq2XGzbjU4NcOmjFI0vxQ8w1L05twmkOvg5QERcX6Mi8NQrWnR0stLExu2LucUXg1aYjnggxIR8TIOGygZVIMV3STKH4UQXD--wz0BUrqaLxPhrm2Eh9Hwc8TdB6Na4ShQUq5Xm8D4elzNUVdpM~RtChEyJWuQvoGAHY3ppX-EJJLkiSr1t77neS4Lc-KofMVmgI9a2tSSpNAagBiNI6Ak9L1T0F9uxeDfEG9bBSQPNMOSUbAoEcNxtt7xOW~cNOAyMyGydwPMnrQ5kIYPY8Pd3XudEko970vE0D6gO19yoBMJpKx6Dh50DGgybLQ9CpRaynh2zPULTHxm8rneOGRcQo8D3mE7FQ92m54~SvfjXjD2TwAVGI~ae~n9HDxt8uxOecAAvjjJ3TD4XM63Q9TmB38RmGNzNLDBQMEmJFpqQU8YeuhnS54IVdUoVQFqui5SfDeLXlSkh4vYoMU66pvBfWbAAAA.i2p/tracker/announce.php=http://crstrack.i2p/tracker/"
    };
    /** comma delimited list of name=announceURL=baseURL for the trackers to be displayed */
    public static final String PROP_TRACKERS = "i2psnark.trackers";
    private static Map trackerMap = null;
    /** sorted map of name to announceURL=baseURL */
    public Map getTrackers() {
        if (trackerMap != null) // only do this once, can't be updated while running
            return trackerMap;
        Map rv = new TreeMap();
        String trackers = _config.getProperty(PROP_TRACKERS);
        if ( (trackers == null) || (trackers.trim().length() <= 0) )
            trackers = _context.getProperty(PROP_TRACKERS);
        if ( (trackers == null) || (trackers.trim().length() <= 0) ) {
            for (int i = 0; i < DEFAULT_TRACKERS.length; i += 2)
                rv.put(DEFAULT_TRACKERS[i], DEFAULT_TRACKERS[i+1]);
        } else {
            StringTokenizer tok = new StringTokenizer(trackers, ",");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf('=');
                if (split <= 0)
                    continue;
                String name = pair.substring(0, split).trim();
                String url = pair.substring(split+1).trim();
                if ( (name.length() > 0) && (url.length() > 0) )
                    rv.put(name, url);
            }
        }
        
        trackerMap = rv;
        return trackerMap;
    }
    
    public String getOpenTrackerString() {
        return _config.getProperty(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS);
    }
    
    public String getUserCategoriesString() {
        return _config.getProperty(PROP_CATEGORIES_BY_USER, DEFAULT_CATEGORIES_BY_USER);
    }
    
    public String getStandardCategoriesString() {
        return DEFAULT_CATEGORIES_STANDARD;
    }
    /** comma delimited list open trackers to use as backups */
    /** sorted map of name to announceURL=baseURL */
    public List getOpenTrackers() {
        if (!shouldUseOpenTrackers())
            return null;
        List rv = new ArrayList(1);
        String trackers = getOpenTrackerString();
        StringTokenizer tok = new StringTokenizer(trackers, ", ");
        while (tok.hasMoreTokens())
            rv.add(tok.nextToken());
        
        if (rv.size() <= 0)
            return null;
        return rv;
    }
    
    /** comma delimited list categories to use as backups */
    /** sorted map of name to categories */
    public List getUserCategoriesList() {
        if (!true)//todo
            return null;
        List rv = new ArrayList(1);
        String categories = getUserCategoriesString();
        StringTokenizer tok = new StringTokenizer(categories, ", ");
        while (tok.hasMoreTokens()){
            String cat = tok.nextToken();
            if(!rv.contains(cat))
                rv.add(cat);
        }
        if (rv.size() <= 0)
            return null;
        return rv;
    }
    /** comma delimited list categories to use as backups */
    /** sorted map of name to categories */
    public List getStandardCategoriesList() {
        if (!true)//todo
            return null;
        List rv = new ArrayList(1);
        String categories = getStandardCategoriesString();
        StringTokenizer tok = new StringTokenizer(categories, ", ");
        while (tok.hasMoreTokens())
            rv.add(tok.nextToken());
        
        if (rv.size() <= 0)
            return null;
        return rv;
    }
    public void setXLServletInit(boolean value){
        if(!xlServletInit){
            //init it only once!
            xlServletInit = value;
            if(xlServletInit){
                _messages.add("Configuration file is '" + this._configFile + "'");
                int minutes = getStartupDelayMinutes();
                _messages.add("Adding torrents in " + minutes + (minutes == 1 ? " minute" : " minutes"));
            }
        }
    }
    
    public String getNickname(){
        return nickname;
    }
    
    public String getVersionXL(){
        return versionXL;
    }
    public int getAverageLongInSeconds(){
        return PeerCoordinator.getAverageLongInSeconds();
    }
    public int getAverageShortInSeconds(){
        return PeerCoordinator.getAverageShortInSeconds();//Watchout! hardcoded see:uploaded_old[n?]// current n = '6'
    }
    public void setNickname(String value){
        nickname = value;
        //_messages.add("Setting nickname " + nickname);
    }
    
    private static class TorrentFilenameFilter implements FilenameFilter {
        private static final TorrentFilenameFilter _filter = new TorrentFilenameFilter();
        public static TorrentFilenameFilter instance() { return _filter; }
        public boolean accept(File dir, String name) {
            return (name != null) && (name.endsWith(".torrent"));
        }
    }
    
    public class SnarkManagerShutdown extends I2PThread {
        public void run() {
            Set names = listTorrentFiles();
            for (Iterator iter = names.iterator(); iter.hasNext(); ) {
                Snark snark = getTorrent((String)iter.next());
                if ( (snark != null) && (!snark.stopped) )
                    snark.stopTorrent();
            }
        }
    }
}
