/* PeerCheckTasks - TimerTask that checks for good/bad up/downloaders.
   Copyright (C) 2003 Mark J. Wielaard
 
   This file is part of Snark.
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package org.klomp.snarkxl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimerTask;

/**
 * TimerTask that checks for good/bad up/downloader. Works together
 * with the PeerCoordinator to select which Peers get (un)choked.
 */
class PeerCheckerTask extends TimerTask {
    private final long KILOPERSECOND = 1024*(PeerCoordinator.CHECK_PERIOD/1000);
    
    private final PeerCoordinator coordinator;
    private final static int minute = 60*1000;
    
    PeerCheckerTask(PeerCoordinator coordinator) {
        this.coordinator = coordinator;
    }
    
    private Random random = new Random();
    
    public void run() {
        
        if(!coordinator.halted() && System.currentTimeMillis()/1000 % (20 * 60) == 0){// save all 20 min // //todo: own timertask
            coordinator.snark.forceSaveTorrentStatus();
        }
        synchronized(coordinator.peers) {
            Iterator it = coordinator.peers.iterator();
            if ((!it.hasNext()) || coordinator.halted()) {
                coordinator.peerCount = 0;
                //worst coordinator.interestedAndChoking = 0;
                coordinator.setRateHistory(0, 0);
                //worst coordinator.setUploaders(0);
                if (coordinator.halted())
                    cancel();
                
                //-------------------- Standby --------------->
                
                boolean hasNoDownloadersSeen = coordinator.snark.downloaderLastSeenTime + I2PSnarkUtil.instance().getStandbyTimeLeech() * minute  < System.currentTimeMillis();
                boolean isStartPhase = coordinator.snark.getStartTimeSeeding() <= 0 || coordinator.snark.getStartTimeSeeding() + I2PSnarkUtil.instance().getStandbyTimeSeed()  * minute > System.currentTimeMillis();
                
                if((SnarkManager.instance().shouldUseStandbyLeech() && !coordinator.isCompleted() && hasNoDownloadersSeen  && !coordinator.storage.isSuperseed) || (SnarkManager.instance().shouldUseStandbySeed() && coordinator.isCompleted() && !isStartPhase && !coordinator.storage.isSuperseed)){
                    if(!coordinator.isInStandbyMode()){
                        coordinator.setStandbyMode(true);
                        coordinator.lastRemovedPeerTimeStandby = System.currentTimeMillis();//count from now
                    }
                }else{
                    if(coordinator.isInStandbyMode())
                        coordinator.setStandbyMode(false);
                    //}//old remove after test the new rule
                }
                //<-------------------- Standby ---------------
                return;
            }
            
            // Calculate total uploading and worst downloader.
            long worstdownload = Long.MAX_VALUE;
            Peer worstDownloader = null;
            
            int peers = 0;
            int uploaders = 0;
            //coordinator.uploaders = 0;
            int downloaders = 0;
            int removedCount = 0;
            
            long uploaded = 0;
            long downloaded = 0;
            
            // Keep track of peers we remove now,
            // we will add them back to the end of the list.
            List removed = new ArrayList();
            int uploadLimit = coordinator.allowedUploaders();
            boolean overBWLimit = coordinator.overUpBWLimit();
            while (it.hasNext()) {
                Peer peer = (Peer)it.next();
                
                // Remove dying peers // and seeder/seeder
                if (!peer.isConnected() || (peer.isCompleted() && coordinator.isCompleted())) {
                    it.remove();
                    
                    if((peer.isCompleted() && coordinator.isCompleted())){//seeder/seeder
                        peer.disconnect(false);
                    }else{
                        //coordinator.peers.remove(peer);
                        //coordinator.removePeerFromPieces(peer);
                        String info = peer.toString();
                        //System.out.println("[isInStandbyMode found no connected] : removed. " + info);
                    }
                    coordinator.peerCount = coordinator.peers.size();
                    continue;
                }
                
                if (coordinator.isInStandbyMode() && peer.isConnected() && peer.isChokeSwitchAllowed() && peer.isChoking() &&
                        coordinator.lastRemovedPeerTimeStandby + 30*60*1000 < System.currentTimeMillis()) {//get at least one free place for a new tracker request and give someone else a chance
                    it.remove();
                    
                    if(!coordinator.needPeers()){//seeder/seeder
                        //if(!peer.isChoked())coordinator.uploaders--;
                        String info = peer.toString();
                        peer.disconnect(false);
                        
                        //coordinator.peers.remove(peer);
                        //coordinator.removePeerFromPieces(peer);
                        //System.out.println("[isInStandbyMode interval] : removed. " + info);
                    }
                    // proberly not removing a peer but it's not neccessary because coordinator.needPeers()
                    coordinator.lastRemovedPeerTimeStandby = System.currentTimeMillis();
                    coordinator.peerCount = coordinator.peers.size();
                    continue;
                }
                
                peers++;
                
                if (!peer.isChoking())
                    uploaders++;
                // coordinator.uploaders++;//uploaders--;
                
                if (!peer.isChoked() && peer.isInteresting())
                    downloaders++;
                
                long upload = peer.getUploaded();
                if(upload > 0)
                    uploaded += upload;
                long download = peer.getDownloaded();
                if(download > 0)
                    downloaded += download;
                
                peer.setRateHistory(upload, download);
                peer.resetCounters();
                
                Snark.debug(peer + ":", Snark.DEBUG);
                Snark.debug(" ul: " + upload/KILOPERSECOND
                        + " dl: " + download/KILOPERSECOND
                        + " i: " + peer.isInterested()
                        + " I: " + peer.isInteresting()
                        + " c: " + peer.isChoking()
                        + " C: " + peer.isChoked(),
                        Snark.DEBUG);
                
                // Choke half of them rather than all so it isn't so drastic...
                // unless this torrent is over the limit all by itself.
                boolean overBWLimitChoke = upload > 0 &&
                        ((overBWLimit && random.nextBoolean()) ||
                        (coordinator.overUpBWLimit(uploaded)));
                
                //toDo remove the comments
                //ups! forgetting to remove it after tests
                // if(!peer.isCompleted() && !coordinator.isCompleted()){// workaround see below
       /* fwd huh, is here a bug?!
        * when we choking a snark-seeder than the seeder stop uploading to us about the download = 0 stuff
        * howlong this is not fixed in the orig snark we have to watchout here.
        *
        * if this anybody cleanup one day than see also the workaround fix in methode peer.setChoking(boolean)
        *
        * maybe i misunderstood the source but i'm not quite sure. so i do not remove comments to remember me in time!
        * this need still a deeper look at
        */
                if(peer.isChokeSwitchAllowed()){
                    // If we are at our max uploaders and we have lots of other
                    // interested peers try to make some room.
                    // (Note use of coordinator.uploaders)
                    if ((((uploaders == uploadLimit
                            && coordinator.getInterestedAndChoking() > 0)
                            || uploaders > uploadLimit
                            || overBWLimitChoke)
                            && !peer.isChoking()) ||
                            coordinator.hasBadRatio(peer)
                            || (coordinator.isInStandbyMode() /*&& !peer.isChoking()*/ && coordinator.peers.size() > 1 ))//fwd ratio
                    {
                        // Check if it still wants pieces from us.
                        if(!peer.isChoking()){
                            if((coordinator.isInStandbyMode() && !peer.isChoking() && coordinator.peers.size() > 1 )){
                                Snark.debug("Choke StandbyMode: " + peer,
                                        Snark.INFO);
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                removedCount++;
                                // Put it at the back of the list
                                it.remove();
                                removed.add(peer);
                            }else if (!peer.isInterested() || coordinator.snark.storage.getForceStopseed() ||( coordinator.snark.storage.isSuperseed  && (coordinator.snark.storage.toSendRandomPieceXL.size() == 0))) {
                                Snark.debug("Choke uninterested peer: " + peer,
                                        Snark.INFO);
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                
                                // Put it at the back of the list
                                it.remove();
                                removed.add(peer);
                            }else if (!peer.isChoking() && !coordinator.isInStandbyMode() &&
                                    (coordinator.peers.size() > coordinator.allowedUploaders() &&
                                    (peer.getLastUnchokesend() + (PeerCoordinator.MAX_CHOKE_TIME_FACTOR * PeerCoordinator.MIN_CHOKE_TIME)) < System.currentTimeMillis() )) {
                                //System.out.println("Choke long unchoked peer: " + peer);
                                Snark.debug("Choke long unchoked peer: " + peer,
                                        Snark.INFO);
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                
                                // Put it at the back of the list
                                it.remove();
                                removed.add(peer);
                            } else if (overBWLimitChoke) {
                                Snark.debug("BW limit (" + upload + "/" + uploaded + "), choke peer: " + peer,
                                        Snark.INFO);
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                removedCount++;
                                
                                // Put it at the back of the list for fairness, even though we won't be unchoking this time
                                it.remove();
                                removed.add(peer);
                            } else if (peer.isInteresting() && peer.isChoked()) {
                                // If they are choking us make someone else a downloader
                                Snark.debug("Choke choking peer: " + peer, Snark.DEBUG);
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                removedCount++;
                                
                                // Put it at the back of the list
                                it.remove();
                                removed.add(peer);
                            } else if (!peer.isInteresting() && !coordinator.isCompleted()) {
                                // If they aren't interesting make someone else a downloader
                                Snark.debug("Choke uninteresting peer: " + peer, Snark.DEBUG);
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                removedCount++;
                                
                                // Put it at the back of the list
                                it.remove();
                                removed.add(peer);
                            }
       /* fwd huh, is here a bug?!
        * when we choking a snark-seeder than the seeder stop uploading to us about the download = 0 stuff
        * howlong this is not fixed in the orig snark we have to watchout here.
        *
        * if this anybody cleanup one day than see also the workaround fix in methode peer.setChoking(boolean)
        * edit:
        * the problem seems to be the "peer.isInteresting()". often it returns true even when we are completed.
        * it should returning false if we are completed!
        * toDo: set all peers setInteresting(false) when we are completed.
        * check the PeerState havePiece(int piece) methode for activities about that.
        * check also the opposite if the peer is completed and shouldn't have any interests in our pieces
        * if it still ?wants? or display a interest on our pieces. there it seems to be the same and wrong behaviour.
        *
        */
                            else if (peer.isInteresting()
                            && !peer.isChoked()
                            && peer.getDownloadTotal() == 0 && //toDo: this need still a deeper look at
                                    !coordinator.isCompleted() //<---  this line need to be done in snark too (if we are the seeder than who should uploading something to us?!
                                    && coordinator.hasBadRatio(peer) )//fwd fix workaround do not choke seeders of orig snark .. see comment above
                            {
                                //ng but di We are downloadidn't receive anything...
                                Snark.debug("Choke downloader that doesn't deliver:"
                                        + peer, Snark.DEBUG);
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                removedCount++;
                                
                                // Put it at the back of the list
                                it.remove();
                                removed.add(peer);
                            } else if (peer.isInteresting() && !peer.isChoked() &&
                                    coordinator.hasBadRatio(peer) )//fwd ratio
                            {
                                peer.setChoking(true);
                                //uploaders--;
                                uploaders++;
                                // coordinator.uploaders--;
                                removedCount++;
                                
                                // Put it at the back of the list
                                it.remove();
                                removed.add(peer);
                            } else if (peer.isInteresting() && !peer.isChoked() &&
                                    peer.getDownloadTotal() < worstdownload && !peer.isCompleted() ) {
                                // Make sure download is good if we are uploading
                                worstdownload = peer.getDownloadTotal();
                                worstDownloader = peer;
                            }
                        }
                        if (upload > 0 && upload < worstdownload && (coordinator.isCompleted() || coordinator.isOnlyseed())) {
                            // Make sure upload is good if we are seeding
                            worstdownload = upload;
                            worstDownloader = peer;
                        }
                        if(worstDownloader == null && peer.isChoking() && coordinator.isInStandbyMode() && downloaders == 0 && !coordinator.needPeers()){
                            worstdownload = peer.getDownloadTotal(); //todo
                            worstDownloader = peer;
                            //System.out.println("[worstdownload] InStandbyMode: found");
                        }
                    }
                    
                    //WATCHOUT about the new settings for CHECK_PERIOD do not flood with requests
                    //if(!coordinator.isInStandbyMode() && worstDownloader != null && !peer.equals(worstDownloader) )
                    
                    /*
                     if(peer.isRequestsendAllowed())
                     peer.retransmitRequests();
                    if(!coordinator.isInStandbyMode())
                        peer.keepAlive();
                     */
                }else{
                    //System.out.println("[no worstdownload] :. peerCount = " + coordinator.peerCount + "/getPeersTotal = " +  PeerCoordinatorSet.instance().getPeersTotal() + " ");
                    
                }
                
                //timeout
                if (!peer.isChoking() &&
                        ((peer.getLastUnchokesend() + ((2 * PeerCoordinator.MAX_CHOKE_TIME_FACTOR) * PeerCoordinator.MIN_CHOKE_TIME)) < System.currentTimeMillis() )) {
                    //System.out.println("Choke timeout; long unchoked peer: " + peer);
                    Snark.debug("Choke timeout; long unchoked peer: " + peer,
                            Snark.INFO);
                    peer.setChoking(true);
                    //uploaders--;
                    uploaders++;
                    // coordinator.uploaders--;
                    
                    // Put it at the back of the list
                    it.remove();
                    removed.add(peer);
                }
                
                if(peer.isRequestsendAllowed())
                    peer.retransmitRequests();
                if(!coordinator.isInStandbyMode())
                    peer.keepAlive();
                
            }//while
            
            // Resync actual uploaders value
            // (can shift a bit by disconnecting peers)
            //coordinator.uploaders = uploaders;
            
            // Remove the worst downloader if needed. (uploader if seeding)
            if(worstDownloader != null)
                if ((((uploaders == uploadLimit
                    && coordinator.getInterestedAndChoking() > 0)
                    || uploaders > uploadLimit)
                    )) {
                if(worstDownloader.isChokeSwitchAllowed() && !coordinator.isInStandbyMode() && !coordinator.needPeers() ){
                    Snark.debug("Choke worst downloader: " + worstDownloader,
                            Snark.DEBUG);
                    //System.out.println("[worstdownload] : checked " + worstDownloader.metainfo.getName());
                    if(!worstDownloader.isChoking()){
                        worstDownloader.setChoking(true);
                        uploaders--;
                    }
                    if (worstDownloader.isConnected()){
                        worstDownloader.disconnect(false);
                        
                        if(removed.remove(worstDownloader))removedCount--;
                        coordinator.peers.remove(worstDownloader);
                        coordinator.removePeerFromPieces(worstDownloader);
                        coordinator.peerCount = coordinator.peers.size();
                    }
                    // Put it at the back of the list
                    //removed.add(worstDownloader);
                    //removedCount++;
                }
                
                }
            // Put peers back at the end of the list that we removed earlier.
            coordinator.peers.addAll(removed);
            coordinator.peerCount = coordinator.peers.size();
            //worst coordinator.interestedAndChoking += removedCount;
            //worst coordinator.setUploaders(uploaders);
            // store the rates
            coordinator.setRateHistory(uploaded, downloaded);
            //for standby mode
            if(downloaders > 0)
                coordinator.snark.downloaderLastSeenTime = System.currentTimeMillis();
            
            int minute = 60*1000;
            boolean hasNoDownloadersSeen = coordinator.snark.downloaderLastSeenTime + I2PSnarkUtil.instance().getStandbyTimeLeech() * minute  < System.currentTimeMillis();
            boolean isStartPhase = coordinator.snark.getStartTimeSeeding() <= 0 || coordinator.snark.getStartTimeSeeding() + I2PSnarkUtil.instance().getStandbyTimeSeed()  * minute > System.currentTimeMillis() ;
            
            if((SnarkManager.instance().shouldUseStandbyLeech() && !coordinator.isCompleted() && hasNoDownloadersSeen && !coordinator.storage.isSuperseed ) || (SnarkManager.instance().shouldUseStandbySeed() && coordinator.isCompleted() && !isStartPhase && !coordinator.storage.isSuperseed)){
                
                //if( !coordinator.isCompleted() && coordinator.snark.downloaderLastSeenTime + coordinator.snark.STANDBYMODE_FALLBACK_TIME < System.currentTimeMillis()){
                if(!coordinator.isInStandbyMode()){
                    coordinator.setStandbyMode(true);
                    coordinator.lastRemovedPeerTimeStandby = System.currentTimeMillis();//count from now
                }
                if(!coordinator.needPeers() &&  worstDownloader != null){
                    if(true || worstDownloader.isChokeSwitchAllowed()){
                        //removed.remove(worstDownloader);
                        if(!worstDownloader.isChoking())uploaders--;
                        //else coordinator.interestedAndChoking --;
                        String info = worstDownloader.toString();
                        if (worstDownloader.isConnected()){
                            worstDownloader.disconnect(false);
                            // synchronized(coordinator.peers) {
                            coordinator.peers.remove(worstDownloader);
                            coordinator.removePeerFromPieces(worstDownloader);
                            coordinator.peerCount = coordinator.peers.size();
                            // }
                            //coordinator.peerCount = coordinator.peers.size();
                            coordinator.lastRemovedPeerTimeStandby = System.currentTimeMillis();
                            //System.out.println("[worstdownload] : removed. " + info);
                        }
                    }else{
                        //System.out.println("[worstdownload] : not removed. peerCount = " + coordinator.peerCount + "/getPeersTotal = " +  PeerCoordinatorSet.instance().getPeersTotal() + " ");
                        
                    }
                }
            }else{
                if(coordinator.isInStandbyMode())
                    coordinator.setStandbyMode(false);
                //}//old remove after test the new rule
            }
            // Optimistically unchoke a peer at least
            if ((!overBWLimit) && !coordinator.overUpBWLimit(uploaded))
                coordinator.unchokePeer();
            
        }
    }
}
