/*
 * Client.java
 *
 Copyright (C) 2008, 2009 fwd
 
   This file is part of I2PSnarkXL.
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 */

package org.i2p.i2psnarkxl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;// sort
import java.util.HashMap;
import java.util.Random;
import java.util.Set;// sort
import java.util.TreeSet;// sort
import java.util.Iterator;// sort

import org.i2p.i2psnarkxl.peermanager.utils.BTPeerIDByteDecoder;
//import java.io.IOException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Base64;
import net.i2p.data.Destination;

import org.klomp.snarkxl.MetaInfo;
import org.klomp.snarkxl.Peer;
//import org.klomp.snarkxl.PeerCoordinator;
//import org.klomp.snarkxl.SnarkManager;

import net.i2p.I2PAppContext;
import net.i2p.util.Log;

public class Client extends Thread implements Comparable, Runnable{
    private Log _log = new Log(Client.class);
    private I2PAppContext _context;
    
    private static final Client _instance = new Client();
    public synchronized static final Client instance() { return _instance; }
    
    public static final List clientsXL = new ArrayList();
    public static final List bannedClientsXL = new ArrayList();
    public static final List generalBannedClientsXL = new ArrayList();
    //private SnarkManager _manager;
    
    private static boolean stop = true;
    // Identifying properties.
    private final I2PSocket sock;
    private Peer peer;
    private final byte[] clientID;
    private final Destination destination;
    //private final byte[] ourID;
    final MetaInfo metainfo;
    
    //toDo: make'em all private
    long starttime = -1; //first seen
    long stoppedtime = 0L; //last seen
    long connectedtime = -1;
    long previous_connected_time = 0L;
    long current_connection_start = 0L;
    long banned_since = 0L;
    long general_banned_since = 0L;
    
    int reconnected = 0;
    int piecesClientFirstSeen = -1;
    int piecesClient = -1;
    
    boolean isConnected = false;
    boolean hasPeer = false;
    boolean hasbadratio = false;
    boolean choking = false;
    
    long downloadrate = 0;
    long uploadrate = 0;
    long download_total = 0;
    long upload_total = 0;
    long old_download_total = 0;
    long old_upload_total = 0;
    
    private Thread t;
    /** Creates a new instance of Client */
    private Client( final Peer _peer, final I2PSocket _sock, byte[] _clientID, MetaInfo _metainfo){
        this.peer = _peer;
        this.sock = _sock;
        this.clientID = _clientID;
        //ourID = _ourID;
        this.metainfo = _metainfo;
        if(starttime == -1)
            this.starttime = System.currentTimeMillis();// first seen but proberly not connected
        
        long _connectedtime = System.currentTimeMillis();// last connecting try
        if(this.sock != null) this.destination = this.sock.getPeerDestination();
        else destination = null;
        synchronized(instance().clientsXL) {
            if(!instance().clientsXL.contains(this)){
                this.connectedtime = _connectedtime;
                // add to head
                instance().clientsXL.add(0,this);
                start();
            }else{
                //((Client)(instance().clientsXL.get(instance().clientsXL.indexOf(this)))).connectedtime = _connectedtime;
                //((Client)(instance().clientsXL.get(instance().clientsXL.indexOf(this)))).peer = peer;
                
                updateInstance();
            }
        }
    }
    
    //Client xlClient = new Client(peer, getI2PSocket(), getPeerID().getID(), metainfo);
    public Client(final Peer _peer ){
        peer = null;
        sock = null;
        clientID =null;
        metainfo = null;
        destination = null;
        stop = false;
        starttime = -1;
        connectedtime = -1;
        Client client = new Client(_peer, _peer.getI2PSocket(), _peer.getPeerID().getID(), _peer.getMetaInfo());
        client = null;
    }
    /** Creates a new instance of Client */
    private Client(){
        _context = I2PAppContext.getGlobalContext();
        _log = _context.logManager().getLog(Client.class);
        //_manager = SnarkManager.instance();
        peer = null;
        sock = null;
        clientID =null;
        metainfo = null;
        destination = null;
        stop = false;
        starttime = System.currentTimeMillis();
    }
    
    private synchronized void updateInstance(){
        Client client = (Client)(instance().clientsXL.get(instance().clientsXL.indexOf(this)));
        long _connectedtime = System.currentTimeMillis();
        
        if(client != null){
            Peer _peer = client.peer;
            if(_peer != null){//damn ??? is this not thread safe?
                if(_peer.getI2PSocket() != null){
                    /*
                     * toDo check why we get sometimes 2 and more peers for this client
                     * some are bad and will fail after short time
                     *
                     * mmh, might this be about the backup tunnels?
                     */
                    if(! _peer.getI2PSocket().isClosed() ){
                        return;
                    }
                }
            }
            // sock and metainfo are not updated. we need them to identify the clients about their first connections
            client.connectedtime = _connectedtime;
            client.peer = this.peer;
            client.reconnected++;
            
         /* remove the client from list
          * the Thread stopps automatic on the update() routine if nesseccary
          *
          */
            //instance().clientsXL.remove((Client)(instance().clientsXL.get(instance().clientsXL.indexOf(this))));
            
            //re-add the updated client at head
            //instance().clientsXL.add(0,client);
        }
        
    }
    /*
     * The vars in the Client.class are not the exact current values of the app
     * we have to refresh them while running to become uptodate.
     * The access to the static elements in this class is better performed than
     * the access elsewhere in other classes. For the templates (or a common gui) it's not neccessary to
     * get a exact value in time or on the fly. The exactness of values in time
     * we controll by the (thread) sleep() methode.
     * do not fly to the moon with this, you will crash ... but for a trip in space around the moon
     * it'll be ok.
     */
    private synchronized void update(){
        // do something
        boolean error = false;
        synchronized(instance().clientsXL) {
            Client client = ((Client)(instance().clientsXL.get(instance().clientsXL.indexOf(this))));
            if(client != null){
                Peer _peer = client.peer;
                if(_peer == null){//toDo make a cleanup methode.
                    //really? (thread safe?) toDo make a getPeerByClient(client) Methode and check all peers if they do not match!
                    //cleanup all
                    if(client.hasPeer){
                        client.hasPeer = false;
                        
                        //capture connection time
                        if(client.isConnected){
                            //client.stoppedtime = System.currentTimeMillis();
                            if(current_connection_start > 1000L)
                                client.previous_connected_time += System.currentTimeMillis() - client.current_connection_start;
                            
                            client.current_connection_start = 0L;
                            client.isConnected = false;
                        }
                        
                        //store the goodies
                        client.old_download_total += client.download_total ;
                        client.old_upload_total += client.upload_total ;
                    }
                    client.downloadrate = 0;
                    client.uploadrate = 0;
                    client.choking = false;
                    return; // wait for next updateInstance() (reconnect with new peer)
                }
                
                // check if the peer is uptodate
                //
                if(_peer.getI2PSocket() == null){//toDo make a cleanup methode.
                    //really? (thread safe?) toDo make a getI2PSocket(peer) Methode and check all peers if they do not match!
                    
                    //cleanup all
                    if(client.hasPeer){
                        client.hasPeer = false;
                        
                        //capture connection time
                        if(client.isConnected){
                            //client.stoppedtime = System.currentTimeMillis();
                            if(current_connection_start > 1000L)
                                client.previous_connected_time += System.currentTimeMillis() - client.current_connection_start;
                            
                            client.current_connection_start = 0L;
                            client.isConnected = false;
                        }
                        
                        //store the goodies
                        client.old_download_total += client.download_total ;
                        client.old_upload_total += client.upload_total ;
                    }
                    client.downloadrate = 0;
                    client.uploadrate = 0;
                    client.choking = false;
                    return; // wait for next updateInstance() (reconnect with new peer)
                }
                
                client.hasPeer = true;
                
                //capture connection time
                if(client.isConnected != _peer.isConnected()){
                    client.isConnected = _peer.isConnected();
                    if(!client.isConnected){// switched from state connected to unconnected
                        //cleanup all
                        client.downloadrate = 0;
                        client.uploadrate = 0;
                        //client.stoppedtime = System.currentTimeMillis();
                        //capture connection time
                        client.previous_connected_time += System.currentTimeMillis() - client.current_connection_start;
                        client.current_connection_start = 0L;
                    }else{// we are new connected
                        client.current_connection_start = System.currentTimeMillis();
                    }
                }
                
                if(client.isConnected){//toDo make a refres methode
                    long _stoppedtime = _peer.getInactiveTime();
                    if(_stoppedtime > 0L){
                        client.stoppedtime = System.currentTimeMillis() - _stoppedtime;
                    }
                    client.downloadrate = _peer.getDownloadRate();
                    client.uploadrate = _peer.getUploadRate();
                    client.download_total = _peer.getDownloadTotal() ;
                    client.upload_total = _peer.getUploadTotal();
                    client.choking = _peer.isChoking();
                    if(client.piecesClientFirstSeen == -1 && _peer.getCompleted() > 0 && //we might loss 1-2 pieces but we need to be sure the connection is working
                            System.currentTimeMillis() - client.current_connection_start > 2 * 60 * 1000){//first connect. give us some time to get all pieces
                        client.piecesClientFirstSeen = _peer.getCompleted();
                    }
                    client.piecesClient = _peer.getCompleted();
                    if(client.isBanned())
                        _peer.disconnect(true);
                }
                client.hasbadratio = _peer.hasBadRatio();
                
                
                
            }else{
                error = true;
            }
        }
        if(error){
            halt();
        }
    }
    
    
    public boolean isConnected(){
        return isConnected;
    }
    
    /*
     * returns 0 if the client is not banned
     * returns 1 if the client is banned all connections
     * returns 2 if the client is banned for one or more torrents
     **/
    public int getBanned(){
        if(instance().generalBannedClientsXL.contains((String)this.getClientAddress())){
            return 1;
        }
        if(instance().bannedClientsXL.contains(this)){
            return 2;
        }
        return 0;
    }
    
    /**
     * Whether or not we are choking the peer.
     */
    public boolean isChoking() {
        return choking;
    }
    /*
     * returns if the client is banned for this torrent
     **/
    public boolean isBanned(){
        if(instance().bannedClientsXL.contains(this)){
            return true;
        }
        if(instance().generalBannedClientsXL.contains((String)this.getClientAddress())){
            return true;
        }
        return false;
    }
    
    public void ban(boolean general){
        if(general){
            instance().generalBannedClientsXL.add(0,(String)this.getClientAddress());
            general_banned_since = System.currentTimeMillis();
        }else{
            instance().bannedClientsXL.add(0,this);
            banned_since = System.currentTimeMillis();
        }
        //instance().clientsXL.add(0,this);
    }
    
    public void unBan(boolean general){
        if(general){
            if(instance().generalBannedClientsXL.contains((String)this.getClientAddress())){
                instance().generalBannedClientsXL.remove((String)(instance().generalBannedClientsXL.get(instance().generalBannedClientsXL.indexOf((String)this.getClientAddress()))));
                general_banned_since = 0L;
            }
            
        }else if(instance().bannedClientsXL.contains(this)){
            instance().bannedClientsXL.remove((Client)(instance().bannedClientsXL.get(instance().bannedClientsXL.indexOf(this))));
            banned_since = 0L;
        }
        //instance().clientsXL.add(0,this);
    }
    
    public boolean hasBadRatio(){
        //toDo: check if we are seeding
        //  if(isCompleted()) return false;// we are seeding
        return hasbadratio;
    }
    
    
    public boolean hasPeer(){
        return hasPeer;
    }
    
    public long getUploadRate() {
        return uploadrate;
    }
    
    public long getDownloadRate() {
        return downloadrate;
    }
    
    public long getDownloadTotal() {
        return download_total + old_download_total;
    }
    
    public long getUploadTotal() {
        return upload_total + old_upload_total;
    }
    
    public long getUploadTotalFromOther() {
        //methode differs  +- size of last piece
        long value = 0L;
        int pieceLength = metainfo.getPieceLength(0);
        if(piecesClientFirstSeen > -1 && piecesClientFirstSeen < piecesClient){//dataloss?! if piecesClient is < piecesClientFirstSeen
            value = (long)( (long) piecesClient - (long) piecesClientFirstSeen) * (long) pieceLength  ;
            value -= upload_total + old_upload_total;
            if(value < 0L)value = 0L; // dataloss strikes again! //
        }
        return value;
    }
    
    public long getDownloadTotalSession() {
        return download_total ;
    }
    
    public long getUploadTotalSession() {
        return upload_total ;
    }
    
    public int getReconnections() {
        return reconnected;
    }
    
    public String getClientName(){
        String value="null";
        value = getClientIDString().substring(5, 9);
        return value;
    }
    
    //getClientSoft
    public String getClientSoft(){
        String value = getClientDescription( clientID );
        return value;
    }
    
    public String getClientAddress(){
        String value = destination.toBase64();
        return value;
    }
    
    public String getClientTorrentName(){
        String value = metainfo.getName();
        return value;
    }
    
    /*
    public Client getClientByPeer(Peer peer){
        //Client client = ((Client)(peer.getI2PSocket(), peer.getPeerID().getID(), peer.getMetaInfo()));
        Client client = null;
        for(int i=0; i<clientsXL.size();i++){
            if((((Client)clientsXL.get(i)).compareTo(peer)) == 1){
                client = ((Client)clientsXL.get(i));
                break;
            }
        }
            return client;
    }
     */
    
    //overall_connected_time +- thread.sleep(?)'s in run
    // all time connections of this i2p session
    //REM: if we change this to deliver a LONG than to not forget to substracting System.currentTimeMillis()!
    public String getClientConnectionTime(){
        long value = 0L;
        if(current_connection_start > 1000L){
            value = current_connection_start;
        }else
            value = System.currentTimeMillis();
        value -= previous_connected_time;
        return getFormatTimeStemp(value);
    }
    
    //current_connection_time +- thread.sleep(?) in run
    /* How long we are connected over current peer
     * since current peer.isConnected() == true
     */
    //REM: if we change this to deliver a LONG than to not forget to substracting System.currentTimeMillis()!
    public String getClientConnectedSince(){
        long value = 0L;
        if(current_connection_start > 1000L){
            value = current_connection_start;
        }else
            value = System.currentTimeMillis();
        return getFormatTimeStemp(value);
    }
    
    public String getLastSeen(){
        if(!(stoppedtime > 0L))
            return "Never";
        return getFormatTimeStemp(stoppedtime);
    }
    
    public String getClientKnownSince(){
        return getFormatTimeStemp(starttime);
    }
    
    public String getClientLastTry(){
        return getFormatTimeStemp(connectedtime);
    }
    
    private String getFormatTimeStemp(long value){
        long hours = ((System.currentTimeMillis() - value) / ((1000) * 60 * 60));
        long minutes = (((System.currentTimeMillis() - value)  - (hours * ((1000) * 60 * 60))) / ((1000) * 60 ));
        long seconds = (((System.currentTimeMillis() - value) - (hours * ((1000) * 60 * 60) + minutes * ((1000) * 60 ))) / ((1000) )) ;
        
        StringBuffer timeStemp = new StringBuffer();
        
        if(hours < 10)
            timeStemp.append("0");
        timeStemp.append("" + hours);
        timeStemp.append(":");
        if(minutes < 10)
            timeStemp.append("0");
        timeStemp.append("" + minutes);
        timeStemp.append(":");
        if(seconds < 10)
            timeStemp.append("0");
        timeStemp.append("" + seconds);
        
        return timeStemp.toString();
    }
    /**
     * Returns the String "id@address" where id is the base64 encoded id
     * and address is the base64 dest (was the base64 hash of the dest) which
     * should match what the bytemonsoon tracker reports on its web pages.
     */
    public String getClientIDString() {
        int nonZero = 0;
        for (int i = 0; i < clientID.length; i++) {
            if (clientID[i] != 0) {
                nonZero = i;
                break;
            }
        }
        return Base64.encode(clientID, nonZero, clientID.length-nonZero).substring(0,4) + "@" + destination.toBase64().substring(0,6);
    }
    
    /*
     *
     *
     */
    public synchronized void run() {
        assert(t == Thread.currentThread());
        while(!stop) {
            sleep(1000);
            if(clientsXL.size() > 0 ){
                // do something
                update();
            }
        }
        
    }
    
    private synchronized void sleep(int value){
        try {
            //Random randB = new Random(System.currentTimeMillis());//fwd save CPU power
            //Thread.sleep(value + (Math.abs(randB.nextInt()) % 4000));
            Thread.sleep(value + instance().clientsXL.size()*50);//sleep 0,5 sec more foreach 10 clients
        } catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }
    
    public synchronized void start() {
        stop = false;
        assert(t == null);
        t = new Thread(this, "Client Manager");
        t.setDaemon(true);
        t.setPriority(Thread.MIN_PRIORITY);
        t.start();
    }
    
    public synchronized void halt() {
        if (true) throw new RuntimeException("Client Manager forced to stop!");
        stop = true;
        
        Thread thread = t;
        if (thread != null)
            thread.interrupt();
    }
    
    /**
     * Two Clients are equal when they have the same id, address and torrent.
     */
    public boolean equals(Object o) {
        Client p = (Client)o;
        boolean isID = idencode(clientID).equals(p.idencode(clientID));
        boolean isAddress = destination.calculateHash().toBase64().equals(p.destination.calculateHash().toBase64());
        boolean isTorrent = metainfo.getInfoHash().equals(p.metainfo.getInfoHash());
        if(isID && isAddress && isTorrent){
            return true;
        }else{
            return false;
        }
    }
    /**
     * Compares the clients.
     */
    public int compareTo(Object o) {
        Client p = (Client)o;
        boolean isID = idencode(clientID).equals(p.idencode(clientID));
        boolean isAddress = destination.calculateHash().toBase64().equals(p.destination.calculateHash().toBase64());
        boolean isTorrent = metainfo.getInfoHash().equals(p.metainfo.getInfoHash());
        if(isID && isAddress && isTorrent){
            return 0;
        }else{
            return 1;
        }
    }
    
    private byte[] getClientID(){
        return clientID;
    }
    
    private byte[] getOurID(){
        return clientID;
    }
    
    private MetaInfo getMetaInfo(){
        return metainfo;
    }
    
    /**
     * Returns Destination
     */
    public Destination getDestination() {
        return destination;
    }
    /**
     * Returns socket (for debug printing)
     */
    public String getSocket() {
        return sock.toString();
    }
    
    /**
     * Returns socket
     */
    public I2PSocket getI2PSocket() {
        return sock;
    }
    /**
     * Encode an id as a hex encoded string and remove leading zeros.
     */
    public static String idencode(byte[] bs) {
        boolean leading_zeros = true;
        
        StringBuffer sb = new StringBuffer(bs.length*2);
        for (int i = 0; i < bs.length; i++) {
            int c = bs[i] & 0xFF;
            if (leading_zeros && c == 0)
                continue;
            else
                leading_zeros = false;
            
            if (c < 16)
                sb.append('0');
            sb.append(Integer.toHexString(c));
        }
        
        return sb.toString();
    }
    
    /**
     * Get a client description (name and version) from the given peerID byte array.
     * @param peer_id peerID sent in handshake
     * @return description
     */
    public static String getClientDescription( byte[] peer_id ) {
        return BTPeerIDByteDecoder.decode( peer_id );
    }
    
    /*
     *
     */
    public List sortByName(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(((Client)(list.get(ai))).getClientName().toLowerCase()+ai,list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
      /*
       *
       */
    public List sortByBTClient(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(((Client)(list.get(ai))).getClientSoft().toLowerCase()+((Client)(list.get(ai))).getClientName().toLowerCase()+ai,list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
     /*
      *
      */
    public List sortByConnectionTime(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(((Client)(list.get(ai))).getClientConnectionTime().toLowerCase()+ai,list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
     /*
      *
      */
    public List sortByKnownSince(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(((Client)(list.get(ai))).getClientKnownSince().toLowerCase()+ai,list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
     /*
      *
      */
    public List sortByLastSeen(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(((Client)(list.get(ai))).getLastSeen().toLowerCase()+ai,list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
      /*
       *
       */
    public List sortByConnectedSince(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(((Client)(list.get(ai))).getClientConnectedSince().toLowerCase()+ai,list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
     /*
      *
      */
    public List sortByUploadTotal(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(getSizeFormatedLongString(((Client)(list.get(ai))).getUploadTotal() , ai),list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
      /*
       * the UFO sort ;)
       */
    public List sortByUploadTotalFromOther(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(getSizeFormatedLongString(((Client)(list.get(ai))).getUploadTotalFromOther() , ai),list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
     /*
      *
      */
    public List sortByDownloadTotal(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(getSizeFormatedLongString(((Client)(list.get(ai))).getDownloadTotal() , ai),list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
     /*
      *
      */
    public List sortByUploadRate(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(getSizeFormatedLongString(((Client)(list.get(ai))).getUploadRate() , ai),list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
     /*
      *
      */
    public List sortByDownloadRate(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(getSizeFormatedLongString(((Client)(list.get(ai))).getDownloadRate() , ai),list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
     /*
      *
      */
    public List sortByReconnections(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put(getSizeFormatedLongString(((Client)(list.get(ai))).getReconnections() , ai),list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
     /*
      *
      */
    public List sortByBanned(boolean descending) {
        
        Map peersTmp = new HashMap();
        List list = instance().clientsXL;
        for(int ai = 0;ai < list.size();ai++){
            peersTmp.put("" + ((Client)(list.get(ai))).isBanned() + "" + ai,list.get(ai));// + ai because else we lost clients with same name =name1;name5;name34 ..
        }
        
        Set peersSet =  peersTmp.keySet();
        TreeSet peerTS = new TreeSet(peersSet); // sorts it alphabetically by Hash (current not the name of peers but enough that the peers keep the same range)
        ArrayList rv = new ArrayList(peerTS.size());
        Iterator pts;
        if(descending)
            pts = peerTS.descendingIterator();
        else
            pts = peerTS.iterator();
        
        for (Iterator iter = pts; iter.hasNext(); ) {
            String name = (String )iter.next();
            rv.add((Client)(peersTmp.get(name)));
        }
        return rv;
    }
    
    private String getSizeFormatedLongString(long value, int loop){
        // needed for sorting integers and long as string in a hashmap
        // (hashmap lost/overwrite none unique elements) that took a while to figure it out!
        // else we loss the right range and without loop some values that are same numbers
        // bit, byte, kb, mb, gb, 1, 10, 100 ... >
         /* 000001
          * 000010
          * 000100
          * 001000
          * ...
          **/
        String var = "" + value;
        String varLoop = "" + loop; // the loop caring that we get in all cases a unique value
        StringBuffer formatedstring = new StringBuffer();
        StringBuffer formatedloop = new StringBuffer();
        int max = 33 ;// how long could it be? 33 should be enough for all cases.
        
        for(int i=0; i < (4 - varLoop.length() ); i++)// place for 9.999 clients ;)
            formatedloop.append("0");
        
        formatedloop.append(varLoop);
        
        for(int i=0; i < (max - var.length() ); i++)
            formatedstring.append("0");
        
        formatedstring.append(var);
        formatedstring.append(formatedloop);
        
        return formatedstring.toString();
    }
    
    /**
     * Primarily used for serializing this key
     */
    public String toString() {
        String ENDLINE="\n";
        String SEMI="; ";
        
        StringBuffer output = new StringBuffer("");
        if(clientID != null)
            output.append(getClientDescription( clientID ));
        else output.append("null");
        output.append(SEMI);
        
        if(clientID != null)
            output.append(getClientName());
        else output.append("null");
        output.append(SEMI);
        
        /*
        if(clientID != null)
            output.append(idencode(clientID));
        else output.append("null");
        output.append(SEMI);
         */
        
        if(sock != null)
            if(destination != null)
                output.append("" + destination.calculateHash().toBase64());
            else output.append("null");
        else output.append("null");
        output.append(SEMI);
        
//        output.append(idencode(ourID));
//        output.append(SEMI);
        
        if(metainfo != null)
            output.append(metainfo.getName());
        else output.append("null");
        output.append(SEMI);
        
        output.append("Known since: " + ((System.currentTimeMillis() - starttime)/ (1000)) );
        output.append(SEMI);
        
        output.append("last connection try: " + ((System.currentTimeMillis() - connectedtime)/ (1000)) );
        output.append(SEMI);
        
        output.append(ENDLINE);
        return output.toString();
    }
}
