#! /usr/bin/env python
# -*- coding: utf-8 -*-
#-----------------------------------------------------------------------------
# Name:        urlfetch.py
# Purpose:     
#
# Author:      Jeremy Arendt
#
# Created:     2004/20/02
# RCS-ID:      $Id: urlfetch.py,v 1.3 2005/09/16 07:41:38 Inigo Exp $
# Copyright:   (c) 2002
# Licence:     See G3.LICENCE
#-----------------------------------------------------------------------------
import wx
import sys
from threading import Thread
#I2P: Not needed anymore, we now use urllib2 directly (needed to use a proxy - at least I think so)
#from BitTorrent.zurllib import URLError, urlopen, Request
#/I2P
#I2P: Replacement for the above. URLError is still needed, although we could also import it directly
from BitTorrent.zurllib import URLError
import urllib2
#/I2P
from os.path import split, join
from urlparse import urlparse
from socket import gaierror, timeout

from leoxv import parseloadurl

if sys.platform == "win32":   
    win32_flag = True
else:
    win32_flag = False

class URLDialog(wx.Dialog):
    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, title = _("Add .torrent from URL"))
        self.label1 = wx.StaticText(self, -1, _("URL:"))
        self.edit1 = wx.TextCtrl(self, -1, "", size = (300, -1))
        #I2P: removed, because we currently don't support it anymore
        #self.label2 = wx.StaticText(self, -1, _("Referrer:"))
        #self.edit2 = wx.TextCtrl(self, -1, "", size = (300, -1))
        #/I2P
        self.okbutt = wx.Button(self, wx.ID_OK)
        self.cancelbutt = wx.Button(self, wx.ID_CANCEL)
        #I2P: removed, because we currently don't support refferer pretending anymore
        #self.guessbutt = wx.Button(self, -1, _("Calc referrer"))
        #self.label2.SetToolTipString(_("Needed if torrent site uses referer checking."))
        #self.edit2.SetToolTipString(_("Needed if torrent site uses referer checking."))
        #self.guessbutt.SetToolTipString(_("Guesses possible referrer"))
        #/I2P
        boxsizer = wx.FlexGridSizer(cols=1, rows=1)
        buttsizer = wx.FlexGridSizer(cols=5, rows=1, vgap=2, hgap=2)
        urlsizer = wx.FlexGridSizer(cols=2, rows=3, vgap=2, hgap=2)
        urlsizer.Add(self.label1, 0, wx.ALL|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 4)
        urlsizer.Add(self.edit1, 0, wx.RIGHT|wx.EXPAND|wx.FIXED_MINSIZE, 1)
        #I2P: removed, because we currently don't support refferer pretending anymore
        #urlsizer.Add(self.label2, 0, wx.ALL|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE, 4)
        #urlsizer.Add(self.edit2, 0, wx.RIGHT|wx.EXPAND|wx.FIXED_MINSIZE, 1)
        #/I2P
        urlsizer.AddGrowableCol(1)
        boxsizer.Add(urlsizer, 1, wx.EXPAND, 0)
        buttsizer.Add( (-1,-1) )
        buttsizer.Add(self.okbutt, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
        buttsizer.Add(self.cancelbutt, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
        #I2P: removed, because we currently don't support refferer pretending anymore
        #buttsizer.Add(self.guessbutt, 0, wx.ALL|wx.FIXED_MINSIZE, 4)
        #/I2P
        buttsizer.Add( (-1,-1) )
        buttsizer.AddGrowableCol(0)
        buttsizer.AddGrowableCol(2)
        boxsizer.Add(buttsizer, 1, wx.EXPAND, 0)
        self.SetAutoLayout(True)
        self.SetSizer(boxsizer)
        self.Fit()
        boxsizer.SetSizeHints(self)
        self.Layout()

#I2P: removed, because we currently don't support refferer pretending anymore
#        self.Bind(wx.EVT_BUTTON, self.OnGuess, self.guessbutt)
#
#    def OnGuess(self, event):
#        target = self.edit1.GetValue()
#        if target != "":
#            self.edit2.SetValue(split(target)[0])
#/I2P


class T_FetchFile(Thread):

    #I2P: Added the proxy
    def __init__(self, callback, callback_params, url, destpath, proxy, referer=None):

        Thread.__init__(self)

        self.success = False

        self.callback = callback
        self.params = callback_params
        self.url = url
        self.path = destpath
        self.name = "Fetch"
        self.referer = referer
        #I2P: this is a variable for the eep-proxy
        self.proxy = proxy
        #/I2P
        
    def run(self):

        if win32_flag:
            try:
                filename = join(self.path, split(urlparse(self.url)[2])[1])
                #I2P: replaced with a simpler approach using the eep-proxy
                #req = Request(self.url)
                ##d0c - added referer to header
                #if self.referer != None:
                #    req.add_header('Referer', self.referer)
                #h = urlopen(req)
                ##d0c end
                #/I2P
                #I2P: New code to fetch a file from an url
                proxyhandler    = urllib2.ProxyHandler({'http': 'http://anonymous:passwd@' + self.proxy})
                opener   = urllib2.build_opener(proxyhandler, urllib2.HTTPBasicAuthHandler(), urllib2.HTTPHandler)
                h = opener.open(self.url)
                #/I2P
                
            except (OSError, ValueError, URLError, gaierror, timeout), msg:
                print "Error fetching url", msg
                return False
        else:
            #I2P: This doesn't use the proxy: Try to just use the below method
            #try:           
            #    filename = join(self.path, split(urlparse(self.url)[2])[1])          
            #    url = parseloadurl(self.url)          
            #    h = (url)        
            #except:
            #/I2P
            try:
                filename = join(self.path, split(urlparse(self.url)[2])[1])
                ##I2P: replaced with a simpler approach using the eep-proxy
                #req = Request(self.url)
                ##d0c - added referer to header
                #if self.referer != None:
                #    req.add_header('Referer', self.referer)
                #h = urlopen(req)
                ##d0c end
                ##/I2P
                #I2P: New code to fetch a file from an url
                proxy    = urllib2.ProxyHandler({'http': 'http://anonymous:passwd@' + self.proxy})
                opener   = urllib2.build_opener(proxy, urllib2.HTTPBasicAuthHandler(), urllib2.HTTPHandler)
                h = opener.open(self.url)
                #/I2P
                    
            except msg:
                print "Error fetching url"
                return False     

        try:
            f = open(filename, 'wb')
            f.write(h.read())
            f.close()
            self.success = True
            self.callback( self.params, [filename] )
            return True
        except IOError, msg:
            self.success = False
            print msg
            return False


def dummy_callback(params1, params2):
    print params1, params2
    

if __name__ == "__main__":                                                       #referer - d0c
    f = T_FetchFile(dummy_callback, "test", "http://localhost/test.torrent", "", "http://localhost")
    _ = lambda x: x # needed for gettext
    f.start()
    
